/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.ant.AntBuildExtenderAccessorImpl;
import org.netbeans.modules.project.ant.AntBuildExtenderAccessor;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ant.AntBuildExtenderImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AntBuildExtender {
    private HashMap<String, Extension> extensions;
    private AntBuildExtenderImplementation implementation;
    private static final DocumentBuilder db;

    AntBuildExtender(AntBuildExtenderImplementation antBuildExtenderImplementation) {
        this.implementation = antBuildExtenderImplementation;
    }

    public List<String> getExtensibleTargets() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.implementation.getExtensibleTargets());
        arrayList = Collections.unmodifiableList(arrayList);
        return arrayList;
    }

    public synchronized Extension addExtension(String string, FileObject fileObject) {
        assert (fileObject != null);
        assert (fileObject.isValid() && fileObject.isData());
        assert (FileOwnerQuery.getOwner((FileObject)fileObject) == this.implementation.getOwningProject());
        FileObject fileObject2 = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.xml").getParent();
        assert (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject));
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        if (this.extensions.get(string) != null) {
            throw new IllegalStateException("Extension with id '" + string + "' already exists.");
        }
        Extension extension = new Extension(string, fileObject, FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject));
        this.extensions.put(string, extension);
        this.updateProjectMetadata();
        return extension;
    }

    public synchronized void removeExtension(String string) {
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        if (this.extensions.get(string) == null) {
            return;
        }
        this.extensions.remove(string);
        this.updateProjectMetadata();
    }

    public synchronized Extension getExtension(String string) {
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        return this.extensions.get(string);
    }

    synchronized Set<Extension> getExtensions() {
        HashSet<Extension> hashSet = new HashSet<Extension>();
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        hashSet.addAll(this.extensions.values());
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document createNewDocument() {
        DocumentBuilder documentBuilder = db;
        synchronized (documentBuilder) {
            return db.newDocument();
        }
    }

    private void updateProjectMetadata() {
        FileObject fileObject;
        Document document = AntBuildExtender.createNewDocument();
        Element element = document.createElementNS(AntBuildExtenderAccessor.AUX_NAMESPACE, AntBuildExtenderAccessor.ELEMENT_ROOT);
        if (this.extensions != null) {
            fileObject = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.xml").getParent();
            for (Extension extension : this.extensions.values()) {
                Element element2 = document.createElement(AntBuildExtenderAccessor.ELEMENT_EXTENSION);
                element2.setAttribute(AntBuildExtenderAccessor.ATTR_ID, extension.id);
                String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)extension.file);
                assert (string != null);
                element2.setAttribute(AntBuildExtenderAccessor.ATTR_FILE, string);
                element.appendChild(element2);
                for (String string2 : extension.dependencies.keySet()) {
                    for (String string3 : extension.dependencies.get(string2)) {
                        Element element3 = document.createElement(AntBuildExtenderAccessor.ELEMENT_DEPENDENCY);
                        element3.setAttribute(AntBuildExtenderAccessor.ATTR_TARGET, string2);
                        element3.setAttribute(AntBuildExtenderAccessor.ATTR_DEPENDSON, string3);
                        element2.appendChild(element3);
                    }
                }
            }
        }
        fileObject = (AuxiliaryConfiguration)this.implementation.getOwningProject().getLookup().lookup(AuxiliaryConfiguration.class);
        fileObject.putConfigurationFragment(element, true);
    }

    private void readProjectMetadata() {
        AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)this.implementation.getOwningProject().getLookup().lookup(AuxiliaryConfiguration.class);
        Element element = auxiliaryConfiguration.getConfigurationFragment(AntBuildExtenderAccessor.ELEMENT_ROOT, AntBuildExtenderAccessor.AUX_NAMESPACE, true);
        FileObject fileObject = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.xml").getParent();
        this.extensions = new HashMap();
        if (element != null) {
            String string = element.getNamespaceURI();
            NodeList nodeList = element.getElementsByTagNameNS(string, AntBuildExtenderAccessor.ELEMENT_EXTENSION);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string2 = element2.getAttribute(AntBuildExtenderAccessor.ATTR_ID);
                assert (string2.length() > 0) : "Illegal project.xml";
                String string3 = element2.getAttribute(AntBuildExtenderAccessor.ATTR_FILE);
                FileObject fileObject2 = fileObject.getFileObject(string3);
                assert (fileObject2 != null) : "Missing file " + string3 + " for extension " + string2;
                Extension extension = new Extension(string2, fileObject2, string3);
                this.extensions.put(string2, extension);
                NodeList nodeList2 = element2.getElementsByTagNameNS(string, AntBuildExtenderAccessor.ELEMENT_DEPENDENCY);
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    String string4 = element3.getAttribute(AntBuildExtenderAccessor.ATTR_TARGET);
                    String string5 = element3.getAttribute(AntBuildExtenderAccessor.ATTR_DEPENDSON);
                    assert (string4 != null);
                    assert (string5 != null);
                    extension.loadDependency(string4, string5);
                }
            }
        }
    }

    static {
        AntBuildExtenderAccessorImpl.createAccesor();
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Object)parserConfigurationException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Extension {
        String id;
        FileObject file;
        String path;
        TreeMap<String, Collection<String>> dependencies;

        Extension(String string, FileObject fileObject, String string2) {
            this.id = string;
            this.file = fileObject;
            this.path = string2;
            this.dependencies = new TreeMap();
        }

        String getPath() {
            return this.path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDependency(String string, String string2) {
            assert (AntBuildExtender.this.implementation.getExtensibleTargets().contains(string)) : "The target '" + string + "' is not designated by the project type as extensible.";
            Class<AntBuildExtender> clazz = AntBuildExtender.class;
            synchronized (AntBuildExtender.class) {
                this.loadDependency(string, string2);
                AntBuildExtender.this.updateProjectMetadata();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadDependency(String string, String string2) {
            Class<AntBuildExtender> clazz = AntBuildExtender.class;
            synchronized (AntBuildExtender.class) {
                Collection<String> collection = this.dependencies.get(string);
                if (collection == null) {
                    collection = new ArrayList<String>();
                    this.dependencies.put(string, collection);
                }
                if (!collection.contains(string2)) {
                    collection.add(string2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        public void removeDependency(String string, String string2) {
            Collection<String> collection = this.dependencies.get(string);
            if (collection != null) {
                collection.remove(string2);
                AntBuildExtender.this.updateProjectMetadata();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<String, Collection<String>> getDependencies() {
            TreeMap<String, Collection<String>> treeMap = new TreeMap<String, Collection<String>>();
            Class<AntBuildExtender> clazz = AntBuildExtender.class;
            synchronized (AntBuildExtender.class) {
                for (String string : this.dependencies.keySet()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.addAll(this.dependencies.get(string));
                    treeMap.put(string, arrayList);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return treeMap;
            }
        }
    }
}

