/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.visualweb.ejb.ui.ExportEjbDataSourcesPanel;
import org.netbeans.modules.visualweb.extension.openide.awt.JFileChooser_RAVE;
import org.openide.util.NbBundle;

public class ImportExportFileChooser {
    public static String defaultFilePath = System.getProperty("user.home") + File.separator + "exported_ejb_datasources.jar";
    private JFileChooser fileChooser = JFileChooser_RAVE.getJFileChooser();
    private Component parent;

    public ImportExportFileChooser(Component component) {
        this.parent = component;
        File file = null;
        File file2 = new File(defaultFilePath);
        if (file2.exists()) {
            file = file2.isDirectory() ? file2 : file2.getParentFile();
        }
        if (file == null) {
            file = new File(System.getProperty("user.home"));
        }
        if (file2 != null && file2.exists()) {
            this.fileChooser.setSelectedFile(file2);
        }
        this.fileChooser.setCurrentDirectory(file);
        this.fileChooser.addChoosableFileFilter(new JarFilter());
    }

    public static void setCurrentFilePath(String string) {
        defaultFilePath = string;
    }

    public String getExportFile() {
        if (this.fileChooser.showSaveDialog(this.parent) == 0) {
            String string = this.fileChooser.getSelectedFile().getAbsolutePath();
            return string;
        }
        return null;
    }

    public String getImportFile() {
        if (this.fileChooser.showOpenDialog(this.parent) == 0) {
            String string = this.fileChooser.getSelectedFile().getAbsolutePath();
            return string;
        }
        return null;
    }

    public class JarFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            if (string != null) {
                return string.equals("jar");
            }
            return false;
        }

        public String getDescription() {
            return NbBundle.getMessage(ExportEjbDataSourcesPanel.class, (String)"JAR_FILE_FILTER_DESCRIPTION");
        }
    }
}

