/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.visualweb.ejb.ui.EjbDataSourcePropertiesPanel;
import org.netbeans.modules.visualweb.ejb.ui.PortableEjbDataSource;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class EjbDataSourcesSelectionPanel
extends JPanel {
    private EjbDataSourcePropertiesPanel propsPanel;
    private PortableEjbDataSource[] ejbDataSources;
    private int prevSelectedIndex = 0;
    private JPanel buttonPanel;
    private JButton clearAllButton;
    private JLabel datasourceLabel;
    private JList datasourceList;
    private JScrollPane listScrollPane;
    private JButton selectAllButton;

    public EjbDataSourcesSelectionPanel(EjbDataSourcePropertiesPanel ejbDataSourcePropertiesPanel) {
        this.initComponents();
        this.propsPanel = ejbDataSourcePropertiesPanel;
        this.listScrollPane.setVerticalScrollBarPolicy(20);
        this.datasourceList.setCellRenderer(new CustomListRenderer());
        this.datasourceList.setSelectionMode(0);
        this.datasourceList.addMouseListener(new CustomMouseListener());
        this.datasourceList.addKeyListener(new CustomKeyListener());
        this.selectAllButton.setEnabled(false);
        this.clearAllButton.setEnabled(false);
    }

    public void clear() {
        this.datasourceList.setListData(new Object[0]);
        this.datasourceList.repaint();
        this.propsPanel.clear();
    }

    public void setEjbDataSources(PortableEjbDataSource[] portableEjbDataSourceArray) {
        this.ejbDataSources = portableEjbDataSourceArray;
        if (portableEjbDataSourceArray != null && portableEjbDataSourceArray.length > 0) {
            this.propsPanel.setDataSourceProperties(portableEjbDataSourceArray[0].getEjbGroup());
            this.datasourceList.setListData(portableEjbDataSourceArray);
            this.datasourceList.setSelectedIndex(0);
            this.selectAllButton.setEnabled(true);
            this.clearAllButton.setEnabled(true);
        }
    }

    public void repaintList() {
        this.datasourceList.repaint();
    }

    private void initComponents() {
        this.listScrollPane = new JScrollPane();
        this.datasourceList = new JList();
        this.buttonPanel = new JPanel();
        this.selectAllButton = new JButton();
        this.clearAllButton = new JButton();
        this.datasourceLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.listScrollPane.setBorder(null);
        this.listScrollPane.setMinimumSize(new Dimension(200, 130));
        this.datasourceList.setSelectionMode(0);
        this.datasourceList.setMaximumSize(null);
        this.datasourceList.setMinimumSize(new Dimension(500, 500));
        this.datasourceList.setPreferredSize(null);
        this.datasourceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EjbDataSourcesSelectionPanel.this.datasourceListValueChanged(listSelectionEvent);
            }
        });
        this.listScrollPane.setViewportView(this.datasourceList);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle");
        this.datasourceList.getAccessibleContext().setAccessibleName(resourceBundle.getString("EJB_GROUPS"));
        this.datasourceList.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("EJB_GROUPS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.listScrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 0, 5, 0));
        this.selectAllButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("SELECT_ALL_BUTTON_MNEMONIC").charAt(0));
        this.selectAllButton.setText(resourceBundle.getString("SELECT_ALL_BUTTON_LABEL"));
        this.selectAllButton.setPreferredSize(null);
        this.selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjbDataSourcesSelectionPanel.this.selectAllButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.selectAllButton);
        this.selectAllButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("SELECT_ALL_BUTTON_DESC"));
        this.clearAllButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("CLEAR_BUTTON_MNEMONIC").charAt(0));
        this.clearAllButton.setText(resourceBundle.getString("CLEAR_BUTTON_LABEL"));
        this.clearAllButton.setPreferredSize(null);
        this.clearAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjbDataSourcesSelectionPanel.this.clearAllButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.clearAllButton);
        this.clearAllButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("CLEAR_BUTTON_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.buttonPanel, gridBagConstraints);
        this.datasourceLabel.setLabelFor(this.datasourceList);
        Mnemonics.setLocalizedText((JLabel)this.datasourceLabel, (String)NbBundle.getMessage(EjbDataSourcesSelectionPanel.class, (String)"EJB_SETS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.datasourceLabel, gridBagConstraints);
        this.datasourceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EjbDataSourcesSelectionPanel.class, (String)"EJB_SETS"));
    }

    private void datasourceListValueChanged(ListSelectionEvent listSelectionEvent) {
        int n = ((JList)listSelectionEvent.getSource()).getSelectedIndex();
        if (n == this.prevSelectedIndex) {
            return;
        }
        if (!this.propsPanel.saveChange()) {
            this.datasourceList.setSelectedIndex(this.prevSelectedIndex);
        } else {
            this.prevSelectedIndex = n;
        }
    }

    private void clearAllButtonActionPerformed(ActionEvent actionEvent) {
        if (this.ejbDataSources != null) {
            for (int i = 0; i < this.ejbDataSources.length; ++i) {
                this.ejbDataSources[i].setIsPortable(false);
            }
            this.datasourceList.repaint();
        }
    }

    private void selectAllButtonActionPerformed(ActionEvent actionEvent) {
        if (this.ejbDataSources != null) {
            for (int i = 0; i < this.ejbDataSources.length; ++i) {
                this.ejbDataSources[i].setIsPortable(true);
            }
            this.datasourceList.repaint();
        }
    }

    private static class CustomKeyListener
    extends KeyAdapter {
        private CustomKeyListener() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            JList jList;
            int n;
            if (keyEvent.getKeyCode() == 32 && (n = (jList = (JList)keyEvent.getSource()).getSelectedIndex()) != -1) {
                PortableEjbDataSource portableEjbDataSource;
                portableEjbDataSource.setIsPortable(!(portableEjbDataSource = (PortableEjbDataSource)jList.getModel().getElementAt(n)).isPortable());
                jList.repaint();
            }
        }
    }

    class CustomMouseListener
    extends MouseAdapter {
        CustomMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            JList jList = (JList)mouseEvent.getSource();
            int n = jList.getSelectedIndex();
            if (n < 0) {
                return;
            }
            Object e = jList.getModel().getElementAt(n);
            if (mouseEvent.getX() < 20) {
                PortableEjbDataSource portableEjbDataSource = (PortableEjbDataSource)e;
                if (portableEjbDataSource.isPortable()) {
                    portableEjbDataSource.setIsPortable(false);
                } else {
                    portableEjbDataSource.setIsPortable(true);
                }
                jList.repaint();
            }
            EjbDataSourcesSelectionPanel.this.propsPanel.setDataSourceProperties(((PortableEjbDataSource)e).getEjbGroup());
        }
    }

    class CustomListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public CustomListRenderer() {
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setText(((PortableEjbDataSource)object).getName());
            if (((PortableEjbDataSource)object).isPortable()) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
            return this;
        }
    }
}

