/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.load;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbInfo;
import org.netbeans.modules.visualweb.ejb.load.EjbLoadException;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StdDeploymentDescriptorParser
extends DefaultHandler {
    private static final String HOME_TAG = "home";
    private static final String REMOTE_TAG = "remote";
    private static final String EJB_NAME_TAG = "ejb-name";
    private static final String SESSION_TAG = "session";
    private static final String EJB_SESSION_TYPE_TAG = "session-type";
    private static final String BEAN_ID_ATTR = "id";
    private String xmlFileName;
    private String beanId;
    private String homeName;
    private String remoteName;
    private String ejbName;
    private String sessionType;
    private String currentTag;
    private String data;
    private Collection sessionBeans = new ArrayList();
    private Set skippedEjbs = new HashSet();

    public StdDeploymentDescriptorParser(String string) {
        this.xmlFileName = string;
    }

    public Collection parse() throws EjbLoadException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(this.xmlFileName, (DefaultHandler)this);
            return this.sessionBeans;
        }
        catch (IOException iOException) {
            String string = "Error occured when trying to parse the standard EJB deployment descriptor. Cannot read file " + this.xmlFileName;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.EjbJarXmlParser").log(16, string);
            iOException.printStackTrace();
            throw new EjbLoadException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "Error occured when trying to parse the standard EJB deployment descriptor file " + this.xmlFileName;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.EjbJarXmlParser").log(16, string);
            parserConfigurationException.printStackTrace();
            String string2 = NbBundle.getMessage(StdDeploymentDescriptorParser.class, (String)"CANNOT_PARSE_STD_DD");
            throw new EjbLoadException(1, string2);
        }
        catch (SAXException sAXException) {
            String string = "Error occured when trying to parse the standard EJB deployment descriptor file " + this.xmlFileName;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.EjbJarXmlParser").log(16, string);
            sAXException.printStackTrace();
            String string3 = NbBundle.getMessage(StdDeploymentDescriptorParser.class, (String)"CANNOT_PARSE_STD_DD");
            throw new EjbLoadException(1, string3);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.currentTag = string3;
        if (string3.equalsIgnoreCase(SESSION_TAG)) {
            this.beanId = attributes.getValue(BEAN_ID_ATTR);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.currentTag != null) {
            this.setData();
        }
        if (string3.equals(SESSION_TAG) && this.homeName != null && this.remoteName != null && this.ejbName != null && this.sessionType != null) {
            EjbInfo ejbInfo = new EjbInfo();
            ejbInfo.setHomeInterfaceName(this.homeName);
            ejbInfo.setCompInterfaceName(this.remoteName);
            ejbInfo.setEjbName(this.ejbName);
            ejbInfo.setBeanId(this.beanId);
            if (this.sessionType.equalsIgnoreCase("Stateless")) {
                ejbInfo.setBeanType(1);
            } else {
                ejbInfo.setBeanType(2);
            }
            if (this.hasPackage(ejbInfo)) {
                this.sessionBeans.add(ejbInfo);
            } else {
                ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load").log(16, "EJB has been skipped because there is no package defined for its home or/and remote interface: " + ejbInfo.getCompInterfaceName());
                this.skippedEjbs.add(ejbInfo.getCompInterfaceName());
            }
            this.homeName = null;
            this.remoteName = null;
            this.ejbName = null;
        }
        this.currentTag = null;
        this.data = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.data = this.data == null ? new String(cArray, n, n2) : this.data + new String(cArray, n, n2);
    }

    private void setData() {
        if (this.data != null) {
            this.data = this.data.trim();
        }
        if (this.currentTag.equalsIgnoreCase(HOME_TAG)) {
            this.homeName = this.data;
        } else if (this.currentTag.equalsIgnoreCase(REMOTE_TAG)) {
            this.remoteName = this.data;
        } else if (this.currentTag.equalsIgnoreCase(EJB_NAME_TAG)) {
            this.ejbName = this.data;
        } else if (this.currentTag.equalsIgnoreCase(EJB_SESSION_TYPE_TAG)) {
            this.sessionType = this.data;
        }
    }

    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new StringReader(""));
    }

    public Collection getSkippedEjbs() {
        return this.skippedEjbs;
    }

    private boolean hasPackage(EjbInfo ejbInfo) {
        return ejbInfo.getCompInterfaceName().indexOf(46) != -1 && ejbInfo.getHomeInterfaceName().indexOf(46) != -1;
    }
}

