/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.load;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodParam;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodReturn;
import org.netbeans.modules.visualweb.ejb.load.EjbLoadException;
import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EjbDataSourceXmlParser
extends DefaultHandler {
    private String xmlFileName;
    private EjbGroup curEjbGroup;
    private MethodInfo curMethodInfo;
    private MethodParam curMethodParam;
    private EjbInfo curEjbInfo;
    private String currentTag;
    private String data;
    private Collection allEjbGroups;
    private static String bundledPeRmiIiopPort = EjbDataSourceXmlParser.getBundledPeRmiIiopPort();
    private static File sampleEjbDir = InstalledFileLocator.getDefault().locate("samples/ejb", null, false);

    public EjbDataSourceXmlParser(String string) {
        this.xmlFileName = string;
        this.allEjbGroups = new HashSet();
    }

    public Collection parse() throws EjbLoadException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            File file = new File(this.xmlFileName);
            sAXParser.parse(file, (DefaultHandler)this);
        }
        catch (IOException iOException) {
            String string = "Error occured when trying to parse the standard deployment descriptor file. Cannot read file " + this.xmlFileName;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.EjbDataSourceXmlParser").log(65536, string);
            iOException.printStackTrace();
            throw new EjbLoadException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "Error occured when trying to parse the ejb data source file " + this.xmlFileName;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.EjbDataSourceXmlParser").log(65536, string);
            parserConfigurationException.printStackTrace();
            throw new EjbLoadException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            String string = "Error occured when trying to parse the ejb data source file " + this.xmlFileName;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.EjbDataSourceXmlParser").log(65536, string);
            sAXException.printStackTrace();
            throw new EjbLoadException(sAXException.getMessage());
        }
        return this.allEjbGroups;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.currentTag = string3;
        if (this.currentTag.equalsIgnoreCase("ejb-group")) {
            this.curEjbGroup = new EjbGroup();
        } else if (this.currentTag.equalsIgnoreCase("stateless-session")) {
            this.curEjbInfo = new EjbInfo();
            this.curEjbInfo.setBeanType(1);
        } else if (this.currentTag.equalsIgnoreCase("stateful-session")) {
            this.curEjbInfo = new EjbInfo();
            this.curEjbInfo.setBeanType(2);
        } else if (this.currentTag.equalsIgnoreCase("method")) {
            this.curMethodInfo = new MethodInfo();
            this.curMethodInfo.setIsBusinessMethod(true);
        } else if (this.currentTag.equalsIgnoreCase("create-method")) {
            this.curMethodInfo = new MethodInfo();
            this.curMethodInfo.setIsBusinessMethod(false);
        } else if (this.currentTag.equalsIgnoreCase("return-type")) {
            String string4 = attributes.getValue("element-type");
            String string5 = attributes.getValue("is-collection");
            MethodReturn methodReturn = new MethodReturn();
            if (string5 != null) {
                methodReturn.setIsCollection(new Boolean(string5));
            }
            methodReturn.setElemClassName(string4);
            this.curMethodInfo.setReturnType(methodReturn);
        } else if (this.currentTag.equalsIgnoreCase("parameter")) {
            this.curMethodParam = new MethodParam();
            String string6 = attributes.getValue("name");
            if (string6 == null) {
                int n = 0;
                if (this.curMethodInfo.getParameters() != null) {
                    n = this.curMethodInfo.getParameters().size() - 1;
                }
                string6 = "arg" + n;
            }
            this.curMethodParam.setName(string6);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.currentTag != null) {
            this.setData();
        }
        if (string3.equals("stateless-session") || string3.equals("stateful-session")) {
            this.curEjbGroup.addSessionBean(this.curEjbInfo);
        } else if (string3.equalsIgnoreCase("method") || string3.equalsIgnoreCase("create-method")) {
            this.curEjbInfo.addMethod(this.curMethodInfo);
        } else if (string3.equalsIgnoreCase("parameter")) {
            this.curMethodInfo.addParameter(this.curMethodParam);
        } else if (string3.equalsIgnoreCase("ejb-group")) {
            this.allEjbGroups.add(this.curEjbGroup);
            this.curEjbGroup = null;
        }
        this.currentTag = null;
        this.data = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.data = this.data == null ? new String(cArray, n, n2) : this.data + new String(cArray, n, n2);
    }

    private void setData() {
        if (this.data != null) {
            this.data = this.data.trim();
        }
        if (this.currentTag.equalsIgnoreCase("group-name")) {
            this.curEjbGroup.setName(this.data);
        } else if (this.currentTag.equalsIgnoreCase("container")) {
            this.curEjbGroup.setAppServerVendor(this.data);
        } else if (this.currentTag.equalsIgnoreCase("server-host")) {
            this.curEjbGroup.setServerHost(this.data);
        } else if (this.currentTag.equalsIgnoreCase("iiop-port")) {
            this.curEjbGroup.setIIOPPort(this.resolveIiopPort(this.data));
        } else if (this.currentTag.equalsIgnoreCase("container")) {
            this.curEjbGroup.setAppServerVendor(this.data);
        } else if (this.currentTag.equalsIgnoreCase("client-jar")) {
            this.curEjbGroup.addClientJarFile(this.resolveJarFileName(this.data));
        } else if (this.currentTag.equalsIgnoreCase("bean-wrapper-jar")) {
            this.curEjbGroup.setClientWrapperBeanJar(this.resolveJarFileName(this.data));
        } else if (this.currentTag.equalsIgnoreCase("design_time_jar")) {
            this.curEjbGroup.setDesignInfoJar(this.resolveJarFileName(this.data));
        } else if (this.currentTag.equalsIgnoreCase("additional-deployment-descriptors")) {
            this.curEjbGroup.setDDLocationFile(this.resolveJarFileName(this.data));
        } else if (this.currentTag.equalsIgnoreCase("jndi-name")) {
            this.curEjbInfo.setJNDIName(this.data);
        } else if (this.currentTag.equalsIgnoreCase("ejb-name")) {
            this.curEjbInfo.setEjbName(this.data);
        } else if (this.currentTag.equalsIgnoreCase("home")) {
            this.curEjbInfo.setHomeInterfaceName(this.data);
        } else if (this.currentTag.equalsIgnoreCase("remote")) {
            this.curEjbInfo.setCompInterfaceName(this.data);
        } else if (this.currentTag.equalsIgnoreCase("web-ejb-ref")) {
            this.curEjbInfo.setWebEjbRef(this.data);
        } else if (this.currentTag.equalsIgnoreCase("wrapper-bean")) {
            this.curEjbInfo.setBeanWrapperName(this.data);
        } else if (this.currentTag.equalsIgnoreCase("wrapper-bean-info")) {
            this.curEjbInfo.setBeanInfoWrapperName(this.data);
        } else if (this.currentTag.equalsIgnoreCase("method-name")) {
            this.curMethodInfo.setName(this.data);
        } else if (this.currentTag.equalsIgnoreCase("return-type")) {
            this.curMethodInfo.getReturnType().setClassName(this.data);
        } else if (this.currentTag.equalsIgnoreCase("parameter")) {
            this.curMethodParam.setType(this.data);
        } else if (this.currentTag.equalsIgnoreCase("exception")) {
            this.curMethodInfo.addException(this.data);
        } else if (this.currentTag.equalsIgnoreCase("dataprovider")) {
            this.curMethodInfo.setDataProvider(this.data);
        }
    }

    private int resolveIiopPort(String string) {
        int n = 23700;
        if (string.indexOf("{bundle_pe_iiop_port}") != -1) {
            String string2 = EjbDataSourceXmlParser.getBundledPeRmiIiopPort();
            if (string2 != null) {
                return Integer.parseInt(string2);
            }
        } else {
            n = Integer.parseInt(string);
        }
        return n;
    }

    private static String getBundledPeRmiIiopPort() {
        File file = InstalledFileLocator.getDefault().locate("config/com-sun-rave-install.properties", null, true);
        try {
            if (file != null || file.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                return properties.getProperty("iiop1Port");
            }
            return null;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.EjbDataSourceXmlParser").log(1, "Error accessing com-sun-rave-install.properties");
            return null;
        }
    }

    private String resolveJarFileName(String string) {
        if (string.indexOf("{samples/ejb}") != -1) {
            string = sampleEjbDir.getAbsolutePath() + string.substring(string.indexOf(125) + 1);
        }
        string = string.replace('/', File.separatorChar);
        string = string.replace('\\', File.separatorChar);
        return string;
    }
}

