/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;

public class EjbInfo
implements Cloneable,
Comparable {
    public static final int STATELESS_SESSION_BEAN = 1;
    public static final int STATEFUL_SESSION_BEAN = 2;
    public static final int ENTITY_BEAN = 3;
    public static final int MESSAGE_DRIVEN_BEAN = 4;
    private int beanType;
    private String jndiName;
    private String ejbName;
    private String beanId;
    private String homeInterfaceName;
    private String compInterfaceName;
    private String webEjbRef;
    private String beanWrapperName;
    private String beanInfoWrapperName;
    private ArrayList methodInfos = new ArrayList();

    public EjbInfo(String string, String string2, String string3, String string4) {
        this.beanType = 1;
        this.jndiName = string;
        this.ejbName = string2;
        this.homeInterfaceName = string3;
        this.compInterfaceName = string4;
    }

    public EjbInfo() {
    }

    public void setBeanType(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("Invalid EJB type: " + n);
        }
        this.beanType = n;
    }

    public void setBeanId(String string) {
        this.beanId = string;
    }

    public void setEjbName(String string) {
        this.ejbName = string;
    }

    public void setJNDIName(String string) {
        this.jndiName = string;
    }

    public void setHomeInterfaceName(String string) {
        this.homeInterfaceName = string;
    }

    public void setCompInterfaceName(String string) {
        this.compInterfaceName = string;
    }

    public void setMethods(ArrayList arrayList) {
        this.methodInfos = arrayList;
    }

    public void addMethod(MethodInfo methodInfo) {
        if (this.methodInfos == null) {
            this.methodInfos = new ArrayList();
        }
        this.methodInfos.add(methodInfo);
    }

    public void setWebEjbRef(String string) {
        this.webEjbRef = string;
    }

    public void setBeanWrapperName(String string) {
        this.beanWrapperName = string;
    }

    public void setBeanInfoWrapperName(String string) {
        this.beanInfoWrapperName = string;
    }

    public boolean isStatelessSessionBean() {
        return this.beanType == 1;
    }

    public int getBeanType() {
        return this.beanType;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public String getHomeInterfaceName() {
        return this.homeInterfaceName;
    }

    public String getCompInterfaceName() {
        return this.compInterfaceName;
    }

    public String getWebEjbRef() {
        return this.webEjbRef;
    }

    public ArrayList getMethods() {
        ArrayList arrayList = new ArrayList(this.methodInfos);
        Collections.sort(arrayList);
        return arrayList;
    }

    public boolean hasAnyMethodWithCollectionReturn() {
        for (MethodInfo methodInfo : this.methodInfos) {
            if (!methodInfo.getReturnType().isCollection()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyConfigurableMethod() {
        for (MethodInfo methodInfo : this.methodInfos) {
            if (!methodInfo.isMethodConfigurable()) continue;
            return true;
        }
        return false;
    }

    public String getBeanTypeName() {
        switch (this.beanType) {
            case 1: 
            case 2: {
                return "Session";
            }
            case 3: {
                return "Entity";
            }
            case 4: {
                return "Message Driven Bean";
            }
        }
        return "Session";
    }

    public String getBeanWrapperName() {
        return this.beanWrapperName;
    }

    public String getBeanInfoWrapperName() {
        return this.beanInfoWrapperName;
    }

    public boolean canBeAutoInit() {
        int n = 0;
        boolean bl = false;
        for (MethodInfo methodInfo : this.methodInfos) {
            if (methodInfo.isBusinessMethod()) continue;
            ++n;
            if (!methodInfo.hasNoParameters()) continue;
            bl = true;
        }
        return n == 1 && bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Type: " + this.getBeanType() + "\n");
        stringBuffer.append("JNDI name: " + this.getJNDIName() + "\n");
        stringBuffer.append("EJB name: " + this.getEjbName() + "\n");
        stringBuffer.append("EJB name: " + this.getBeanId() + "\n");
        stringBuffer.append("Home Interface: " + this.getHomeInterfaceName() + "\n");
        stringBuffer.append("Component Interface: " + this.getCompInterfaceName() + "\n");
        stringBuffer.append("Web EJB Ref: " + this.getWebEjbRef() + "\n");
        stringBuffer.append("Wrapper Bean Name: " + this.getBeanWrapperName() + "\n");
        stringBuffer.append("Wrapper Bean Info Name: " + this.getBeanInfoWrapperName() + "\n");
        if (this.getMethods() != null) {
            stringBuffer.append("Num of methods: " + this.getMethods().size() + "\n");
            stringBuffer.append(this.getMethods().toString());
        }
        return stringBuffer.toString();
    }

    public Collection getMethodNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MethodInfo methodInfo : this.methodInfos) {
            arrayList.add(methodInfo.getName());
        }
        return arrayList;
    }

    public MethodInfo getMethod(String string) {
        for (MethodInfo methodInfo : this.methodInfos) {
            if (!methodInfo.getName().equals(string)) continue;
            return methodInfo;
        }
        return null;
    }

    public Object clone() {
        try {
            EjbInfo ejbInfo = (EjbInfo)super.clone();
            if (this.methodInfos != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Iterator iterator = this.methodInfos.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(((MethodInfo)iterator.next()).clone());
                }
                ejbInfo.setMethods(arrayList);
            }
            return ejbInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof EjbInfo)) {
            return 0;
        }
        String string = ((EjbInfo)object).getJNDIName();
        if (this.getJNDIName() == null || string == null) {
            return 0;
        }
        return this.getJNDIName().compareTo(string);
    }
}

