/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.actions;

import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.load.EjbLoader;
import org.netbeans.modules.visualweb.ejb.load.EjbLoaderHelper;
import org.netbeans.modules.visualweb.ejb.nodes.EjbGroupNode;
import org.netbeans.modules.visualweb.ejb.nodes.EjbLibReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RefreshEjbGroupAction
extends NodeAction {
    protected boolean enable(Node[] nodeArray) {
        return EjbLoaderHelper.isEnableAction();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(RefreshEjbGroupAction.class, (String)"REFRESH");
    }

    protected void performAction(Node[] nodeArray) {
        if (nodeArray != null && nodeArray.length > 0) {
            Node node = null;
            node = nodeArray[0] instanceof FilterNode ? (Node)nodeArray[0].getCookie(EjbGroupNode.class) : nodeArray[0];
            EjbGroup ejbGroup = ((EjbGroupNode)node).getEjbGroup();
            this.refresh(ejbGroup);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private void refresh(EjbGroup ejbGroup) {
        try {
            EjbGroup ejbGroup2 = (EjbGroup)ejbGroup.clone();
            EjbLoader ejbLoader = new EjbLoader(ejbGroup2);
            if (ejbLoader.reload()) {
                EjbGroup ejbGroup3 = ejbLoader.getEjbGroup();
                ejbGroup.setSessionBeans(ejbGroup3.getSessionBeans());
                ejbGroup.setEntityBeans(ejbGroup3.getEntityBeans());
                ejbGroup.setMDBs(ejbGroup3.getMDBs());
                EjbDataModel.getInstance().refreshEjbGroup(ejbGroup);
            }
            EjbLibReferenceHelper.updateEjbGroupForProjects(OpenProjects.getDefault().getOpenProjects(), ejbGroup);
        }
        catch (Exception exception) {
            String string = NbBundle.getMessage(RefreshEjbGroupAction.class, (String)"FAILED_TO_LOAD_EJBS", (Object)ejbGroup.getName());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }
}

