/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.props.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Callable;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.props.PropertyVetoError;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;

public class NodePropertyCustomizer
extends JPanel
implements PropertyChangeListener,
HelpCtx.Provider {
    private PropertyEnv myPropertyEnv;
    private BpelNode myParentNode;
    private CustomNodeEditor myEditor;
    private boolean subscribed = true;
    private Dialog myDialog;

    public NodePropertyCustomizer(PropertyEnv propertyEnv) {
        this.init(propertyEnv);
        this.setLayout(new BorderLayout());
        BpelNode bpelNode = this.getParentBpelNode();
        assert (bpelNode != null) : "Impossible to retrieve the node";
        Component component = bpelNode.getCustomizer();
        assert (component instanceof CustomNodeEditor);
        this.myEditor = (CustomNodeEditor)component;
        this.add(component, "Center");
        ValidStateManager validStateManager = this.myEditor.getValidStateManager(true);
        validStateManager.addValidStateListener(new ValidStateManager.ValidStateListener(){

            public void stateChanged(ValidStateManager validStateManager, boolean bl) {
                if (NodePropertyCustomizer.this.myPropertyEnv != null) {
                    if (bl) {
                        NodePropertyCustomizer.this.myPropertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
                    } else {
                        NodePropertyCustomizer.this.myPropertyEnv.setState(PropertyEnv.STATE_INVALID);
                    }
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (NodePropertyCustomizer.this.myDialog == null) {
                    Container container = ancestorEvent.getAncestor();
                    NodePropertyCustomizer.this.myDialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, NodePropertyCustomizer.this);
                    if (NodePropertyCustomizer.this.myDialog != null) {
                        NodePropertyCustomizer.this.myDialog.addWindowListener(new WindowAdapter(){

                            public void windowClosed(WindowEvent windowEvent) {
                                NodePropertyCustomizer.this.processWindowClose();
                            }

                            public void windowClosing(WindowEvent windowEvent) {
                                NodePropertyCustomizer.this.processWindowClose();
                            }
                        });
                    }
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    public BpelNode getParentBpelNode() {
        Object object;
        Object[] objectArray;
        if (this.myParentNode == null && (objectArray = this.myPropertyEnv.getBeans()) != null && objectArray.length != 0 && (object = objectArray[0]) != null && object instanceof BpelNode) {
            this.myParentNode = (BpelNode)((Object)object);
        }
        return this.myParentNode;
    }

    public synchronized void init(PropertyEnv propertyEnv) {
        assert (propertyEnv != null) : "Wrong params";
        if (this.myPropertyEnv == propertyEnv) {
            return;
        }
        if (this.myPropertyEnv != null) {
            this.myPropertyEnv.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.myPropertyEnv = propertyEnv;
        this.myPropertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
        this.myPropertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
            boolean bl;
            try {
                bl = this.processOkButton();
            }
            catch (PropertyVetoError propertyVetoError) {
                bl = false;
                PropertyVetoError.defaultProcessing(propertyVetoError);
            }
            if (!bl) {
                this.myPropertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOkButton() {
        boolean bl;
        block7: {
            bl = false;
            try {
                Object object = this.myEditor.getEditedObject();
                if (object instanceof BpelEntity) {
                    BpelModel bpelModel = ((BpelEntity)object).getBpelModel();
                    bl = (Boolean)bpelModel.invoke((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return NodePropertyCustomizer.this.processOkButtonImpl(NodePropertyCustomizer.this.myEditor);
                        }
                    }, (Object)this);
                    break block7;
                }
                if (object instanceof WSDLComponent) {
                    WSDLModel wSDLModel = ((WSDLComponent)object).getModel();
                    wSDLModel.startTransaction();
                    try {
                        bl = this.processOkButtonImpl(this.myEditor);
                        break block7;
                    }
                    finally {
                        wSDLModel.endTransaction();
                    }
                }
                bl = this.processOkButtonImpl(this.myEditor);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOkButtonImpl(CustomNodeEditor customNodeEditor) {
        boolean bl = false;
        customNodeEditor.unsubscribeListeners();
        this.subscribed = false;
        try {
            bl = customNodeEditor.doValidateAndSave();
        }
        catch (Exception exception) {
            bl = false;
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        finally {
            if (!bl) {
                customNodeEditor.subscribeListeners();
                this.subscribed = true;
            }
        }
        return bl;
    }

    public void processWindowClose() {
        if (this.subscribed) {
            this.myEditor.unsubscribeListeners();
            this.subscribed = false;
        }
        this.myEditor.afterClose();
    }

    public HelpCtx getHelpCtx() {
        return this.myEditor.getHelpCtx();
    }
}

