/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.importchooser;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.xml.xpath.ext.schema.ExNamespaceContext;

public class NameGenerator {
    private static final String PREFIX_PREFIX = "ns";
    private static NameGenerator INSTANCE = new NameGenerator();

    private NameGenerator() {
    }

    public static NameGenerator getInstance() {
        return INSTANCE;
    }

    public String generateNamespacePrefix(String string, BpelModel bpelModel) {
        return this.generateNamespacePrefix(string, bpelModel, 0);
    }

    public String generateNamespacePrefix(String string, BpelModel bpelModel, int n) {
        String string2 = string == null ? PREFIX_PREFIX : string;
        String string3 = string2 + n;
        while (NameGenerator.isPrefixExist(string3, bpelModel)) {
            string3 = string2 + ++n;
        }
        return string3;
    }

    public static boolean isPrefixExist(String string, BpelModel bpelModel) {
        return NameGenerator.getNamespaceURI(string, bpelModel) != null;
    }

    public static String getNamespacePrefix(String string, BpelModel bpelModel) {
        if (bpelModel != null && string != null) {
            return NameGenerator.getNamespacePrefix(string, (BpelEntity)bpelModel.getProcess());
        }
        return null;
    }

    public static String getNamespacePrefix(String string, BpelEntity bpelEntity) {
        String string2;
        ExNamespaceContext exNamespaceContext;
        if (bpelEntity != null && string != null && (exNamespaceContext = bpelEntity.getNamespaceContext()) != null && (string2 = exNamespaceContext.getPrefix(string)) != null && string2.length() > 0) {
            return string2;
        }
        return null;
    }

    public static String getNamespaceURI(String string, BpelModel bpelModel) {
        if (bpelModel != null && string != null) {
            ExNamespaceContext exNamespaceContext;
            Process process = bpelModel.getProcess();
            ExNamespaceContext exNamespaceContext2 = exNamespaceContext = process != null ? process.getNamespaceContext() : null;
            if (exNamespaceContext != null) {
                return exNamespaceContext.getNamespaceURI(string);
            }
        }
        return null;
    }
}

