/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors.nodes.factory;

import org.netbeans.modules.bpel.editors.api.Constants;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.support.ImportHelper;
import org.netbeans.modules.bpel.nodes.CategoryFolderNode;
import org.netbeans.modules.bpel.nodes.children.AllImportsChildren;
import org.netbeans.modules.bpel.nodes.children.MessagePartsChildren;
import org.netbeans.modules.bpel.nodes.children.PrimitiveTypeChildren;
import org.netbeans.modules.bpel.nodes.children.SchemaCategoriesChildren;
import org.netbeans.modules.bpel.nodes.children.SchemaImportsChildren;
import org.netbeans.modules.bpel.nodes.children.WsdlImportsChildren;
import org.netbeans.modules.bpel.nodes.children.WsdlTypesChildren;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.axinodes.AxiomChildren;
import org.netbeans.modules.soa.ui.axinodes.AxiomTreeNodeFactory;
import org.netbeans.modules.soa.ui.axinodes.AxiomUtils;
import org.netbeans.modules.soa.ui.nodes.NodeFactory;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeChooserNodeFactory
implements NodeFactory<NodeType> {
    private NodeFactory myDelegate;
    private AxiomTreeNodeFactory axiomTreeNodeFactory;

    public TypeChooserNodeFactory(NodeFactory nodeFactory) {
        this.myDelegate = nodeFactory;
        this.axiomTreeNodeFactory = new AxiomTreeNodeFactory();
    }

    public Node createNode(NodeType nodeType, Object object, Children children, Lookup lookup) {
        return this.myDelegate.createNode((Object)nodeType, object, children, lookup);
    }

    public Node createNode(NodeType nodeType, Object object, Lookup lookup) {
        Object object2 = null;
        Object object3 = null;
        NodeFactory nodeFactory = (NodeFactory)lookup.lookup(NodeFactory.class);
        if (!(nodeFactory instanceof TypeChooserNodeFactory)) {
            lookup = new ExtendedLookup(lookup, new Object[]{this});
        }
        switch (nodeType) {
            case PROCESS: {
                assert (object instanceof Process);
                Constants.StereotypeFilter stereotypeFilter = (Constants.StereotypeFilter)lookup.lookup(Constants.StereotypeFilter.class);
                if (stereotypeFilter != null && stereotypeFilter.isSingleStereotype()) {
                    Constants.VariableStereotype variableStereotype = stereotypeFilter.getAllowedStereotypes()[0];
                    switch (variableStereotype) {
                        case GLOBAL_SIMPLE_TYPE: 
                        case GLOBAL_COMPLEX_TYPE: 
                        case GLOBAL_TYPE: 
                        case GLOBAL_ELEMENT: {
                            object2 = new SchemaImportsChildren((Process)object, lookup);
                            break;
                        }
                        case MESSAGE: {
                            object2 = new WsdlImportsChildren((Process)object, lookup);
                            break;
                        }
                        case PRIMITIVE_TYPE: {
                            object2 = new PrimitiveTypeChildren(lookup);
                            object3 = new CategoryFolderNode(NodeType.PRIMITIVE_TYPE, (Children)object2, lookup);
                            return object3;
                        }
                        default: {
                            object2 = Children.LEAF;
                            break;
                        }
                    }
                } else {
                    object2 = new AllImportsChildren((Process)object, lookup);
                }
                object3 = this.myDelegate.createNode((Object)nodeType, object, (Children)object2, lookup);
                return object3;
            }
            case IMPORT: 
            case IMPORT_SCHEMA: 
            case IMPORT_WSDL: {
                assert (object instanceof Import);
                Import import_ = (Import)object;
                String string = import_.getImportType();
                Constants.StandardImportType standardImportType = Constants.StandardImportType.forName(string);
                switch (standardImportType) {
                    case IMPORT_WSDL: {
                        object2 = new WsdlTypesChildren(import_, lookup);
                        object3 = this.myDelegate.createNode((Object)nodeType, object, (Children)object2, lookup);
                        break;
                    }
                    case IMPORT_SCHEMA: {
                        SchemaModel schemaModel = ImportHelper.getSchemaModel((Import)import_, (boolean)true);
                        if (schemaModel != null) {
                            object2 = new SchemaCategoriesChildren(schemaModel, lookup);
                            object3 = this.myDelegate.createNode((Object)nodeType, object, (Children)object2, lookup);
                            break;
                        }
                        object3 = this.myDelegate.createNode((Object)nodeType, object, lookup);
                        break;
                    }
                    case IMPORT_UNKNOWN: {
                        object3 = this.myDelegate.createNode((Object)nodeType, object, lookup);
                    }
                }
                return object3;
            }
            case WSDL_FILE: {
                assert (object instanceof WSDLModel);
                WSDLModel wSDLModel = (WSDLModel)object;
                object2 = new WsdlTypesChildren(wSDLModel, lookup);
                object3 = this.myDelegate.createNode((Object)nodeType, object, (Children)object2, lookup);
                return object3;
            }
            case SCHEMA_FILE: {
                assert (object instanceof SchemaModel);
                SchemaModel schemaModel = (SchemaModel)object;
                object2 = new SchemaCategoriesChildren(schemaModel, lookup);
                object3 = this.myDelegate.createNode((Object)nodeType, object, (Children)object2, lookup);
                return object3;
            }
            case EMBEDDED_SCHEMA: {
                assert (object instanceof Schema);
                SchemaModel schemaModel = ((Schema)object).getModel();
                object2 = new SchemaCategoriesChildren(schemaModel, lookup);
                object3 = this.myDelegate.createNode((Object)nodeType, object, (Children)object2, lookup);
                return object3;
            }
            case MESSAGE_TYPE: {
                assert (object instanceof Message);
                object2 = new MessagePartsChildren((Message)object, lookup);
                object3 = this.myDelegate.createNode((Object)nodeType, object, (Children)object2, lookup);
                return object3;
            }
            case MESSAGE_PART: {
                assert (object instanceof Part);
                lookup = new ExtendedLookup(lookup, new Object[]{this.axiomTreeNodeFactory});
                SchemaComponent schemaComponent = AxiomUtils.getPartType((Part)((Part)object));
                object2 = new AxiomChildren(schemaComponent, lookup);
                object3 = this.myDelegate.createNode((Object)nodeType, object, (Children)object2, lookup);
                return object3;
            }
            case GLOBAL_COMPLEX_TYPE: 
            case GLOBAL_ELEMENT: {
                assert (object instanceof SchemaComponent);
                lookup = new ExtendedLookup(lookup, new Object[]{this.axiomTreeNodeFactory});
                object2 = new AxiomChildren((SchemaComponent)object, lookup);
                object3 = this.myDelegate.createNode((Object)nodeType, object, (Children)object2, lookup);
                return object3;
            }
        }
        object3 = this.myDelegate.createNode((Object)nodeType, object, lookup);
        return object3;
    }
}

