/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors.controls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectListTableModel<T>
extends AbstractTableModel {
    static final long serialVersionUID = 1L;
    private TableColumnModel columnModel;
    private ArrayList<T> myList;

    public ObjectListTableModel(TableColumnModel tableColumnModel) {
        this.columnModel = tableColumnModel;
        this.myList = new ArrayList();
    }

    public abstract void reload();

    @Override
    public int getRowCount() {
        return this.myList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public T getRowObject(int n) {
        return this.myList.get(n);
    }

    public Class<? extends Object> getColumnClass(int n) {
        return String.class;
    }

    public void addRow(T t) {
        this.insertRow(this.myList.size(), t);
    }

    public void insertRow(int n, T t) {
        if (n < 0 || n > this.myList.size()) {
            return;
        }
        this.myList.add(n, t);
        this.fireTableRowsInserted(n, n);
    }

    public void deleteRow(T t) {
        int n = this.myList.indexOf(t);
        if (n != -1) {
            this.myList.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void deleteRow(int n) {
        if (n < 0 || n >= this.myList.size()) {
            return;
        }
        this.myList.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void updateRow(int n) {
        if (n < 0 || n >= this.myList.size()) {
            return;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public Iterator<T> getRowIterator() {
        return this.myList.iterator();
    }

    public int indexOf(T t) {
        return this.myList.indexOf(t);
    }

    public List<T> getRowsList() {
        return this.myList;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        TableCellEditor tableCellEditor;
        TableColumn tableColumn = this.columnModel.getColumn(n2);
        return tableColumn != null && (tableCellEditor = tableColumn.getCellEditor()) != null;
    }
}

