/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

import java.text.MessageFormat;
import java.util.Collection;
import org.netbeans.modules.bpel.properties.editors.TypesCompatibilityValidator;
import org.netbeans.modules.bpel.properties.editors.WizardUtils;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.ValidationUtil;

class TypesCompatibilityValidatorImpl
implements TypesCompatibilityValidator {
    private SchemaComponent sourceSchemaComponent;
    private SchemaComponent targetSchemaComponent;
    private boolean isSourceBuiltInType;
    private boolean isTargetBuiltInType;
    private String resolvedTypeName;
    private TypesCompatibilityValidator.TypesCompatibilityResult resultTypesCompatibility = TypesCompatibilityValidator.TypesCompatibilityResult.BASE_TYPES_UNEQUAL;

    public TypesCompatibilityValidatorImpl(SchemaComponent schemaComponent, SchemaComponent schemaComponent2) {
        this.sourceSchemaComponent = schemaComponent;
        this.targetSchemaComponent = schemaComponent2;
        this.isSourceBuiltInType = WizardUtils.isBuiltInType(schemaComponent);
        this.isTargetBuiltInType = WizardUtils.isBuiltInType(schemaComponent2);
    }

    public String getResolvedTypeName() {
        return this.resolvedTypeName;
    }

    public GlobalSimpleType getResolvedType() {
        if (this.resolvedTypeName == null) {
            return null;
        }
        Collection collection = this.sourceSchemaComponent.getModel().getSchema().getSimpleTypes();
        GlobalSimpleType globalSimpleType = ValidationUtil.findGlobalSimpleType((String)this.resolvedTypeName, (Collection)collection);
        if (globalSimpleType != null) {
            return globalSimpleType;
        }
        globalSimpleType = ValidationUtil.findGlobalSimpleType((String)this.resolvedTypeName, (Collection)ValidationUtil.BUILT_IN_SIMPLE_TYPES);
        if (globalSimpleType != null) {
            return globalSimpleType;
        }
        collection = this.targetSchemaComponent.getModel().getSchema().getSimpleTypes();
        globalSimpleType = ValidationUtil.findGlobalSimpleType((String)this.resolvedTypeName, (Collection)collection);
        return globalSimpleType;
    }

    public TypesCompatibilityValidator.TypesCompatibilityResult getTypesCompatibilityResult() {
        return this.resultTypesCompatibility;
    }

    public void checkSchemaComponentTypesCompatibility() {
        this.resolvedTypeName = null;
        if (!this.builtInTypesExist()) {
            return;
        }
        this.resultTypesCompatibility = TypesCompatibilityValidator.TypesCompatibilityResult.BASE_TYPES_UNEQUAL;
        this.resolvedTypeName = this.checkBuiltInSimpleTypeCompatibility();
        if (this.resolvedTypeName != null || this.isSourceBuiltInType && this.isTargetBuiltInType) {
            return;
        }
        if (this.isSourceBuiltInType && !this.isTargetBuiltInType) {
            this.checkBuiltInTypeAndSchemaComponentType(this.sourceSchemaComponent, this.targetSchemaComponent);
        } else if (!this.isSourceBuiltInType && this.isTargetBuiltInType) {
            this.checkBuiltInTypeAndSchemaComponentType(this.targetSchemaComponent, this.sourceSchemaComponent);
        } else {
            this.checkSchemaComponentTypeAndSchemaComponentType();
        }
    }

    private boolean builtInTypesExist() {
        if (!this.isSourceBuiltInType && ValidationUtil.getBuiltInSimpleType((SchemaComponent)this.sourceSchemaComponent) == null) {
            this.resultTypesCompatibility = TypesCompatibilityValidator.TypesCompatibilityResult.SOURCE_BASE_TYPE_UNKNOWN;
            return false;
        }
        if (!this.isTargetBuiltInType && ValidationUtil.getBuiltInSimpleType((SchemaComponent)this.targetSchemaComponent) == null) {
            this.resultTypesCompatibility = TypesCompatibilityValidator.TypesCompatibilityResult.TARGET_BASE_TYPE_UNKNOWN;
            return false;
        }
        return true;
    }

    private String checkBuiltInSimpleTypeCompatibility() {
        this.resultTypesCompatibility = TypesCompatibilityValidator.TypesCompatibilityResult.BASE_TYPES_UNEQUAL;
        if (!this.isSourceBuiltInType || !this.isTargetBuiltInType) {
            return null;
        }
        return this.checkBuiltInSimpleTypeCompatibility(this.sourceSchemaComponent, this.targetSchemaComponent);
    }

    private String checkBuiltInSimpleTypeCompatibility(SchemaComponent schemaComponent, SchemaComponent schemaComponent2) {
        String string;
        this.resultTypesCompatibility = TypesCompatibilityValidator.TypesCompatibilityResult.BASE_TYPES_UNEQUAL;
        String string2 = this.getSchemaComponentTypeName(schemaComponent);
        if (string2.equals(string = this.getSchemaComponentTypeName(schemaComponent2))) {
            this.resultTypesCompatibility = TypesCompatibilityValidator.TypesCompatibilityResult.TYPES_EQUAL;
            return string2;
        }
        return null;
    }

    private void checkBuiltInTypeAndSchemaComponentType(SchemaComponent schemaComponent, SchemaComponent schemaComponent2) {
        GlobalSimpleType globalSimpleType = ValidationUtil.getBuiltInSimpleType((SchemaComponent)schemaComponent2);
        if (globalSimpleType == null) {
            this.resolvedTypeName = null;
            this.resultTypesCompatibility = TypesCompatibilityValidator.TypesCompatibilityResult.BASE_TYPES_UNEQUAL;
            return;
        }
        this.resolvedTypeName = this.checkBuiltInSimpleTypeCompatibility(schemaComponent, (SchemaComponent)globalSimpleType);
        this.resultTypesCompatibility = this.resolvedTypeName != null ? TypesCompatibilityValidator.TypesCompatibilityResult.BASE_TYPES_EQUAL : TypesCompatibilityValidator.TypesCompatibilityResult.BASE_TYPES_UNEQUAL;
    }

    private void checkSchemaComponentTypeAndSchemaComponentType() {
        String string;
        this.resultTypesCompatibility = TypesCompatibilityValidator.TypesCompatibilityResult.BASE_TYPES_UNEQUAL;
        String string2 = this.getSchemaComponentTypeName(this.sourceSchemaComponent);
        if (string2.equals(string = this.getSchemaComponentTypeName(this.targetSchemaComponent))) {
            this.resultTypesCompatibility = TypesCompatibilityValidator.TypesCompatibilityResult.TYPES_EQUAL;
            this.resolvedTypeName = string2;
        } else {
            GlobalSimpleType globalSimpleType = ValidationUtil.getBuiltInSimpleType((SchemaComponent)this.sourceSchemaComponent);
            this.checkBuiltInTypeAndSchemaComponentType((SchemaComponent)globalSimpleType, this.targetSchemaComponent);
        }
    }

    private String getSchemaComponentTypeName(SchemaComponent schemaComponent) {
        return ValidationUtil.ignoreNamespace((String)WizardUtils.getSchemaComponentTypeName(schemaComponent));
    }

    private String getWarningMsgDifferentTypes() {
        String string = WizardUtils.getSchemaComponentName(this.sourceSchemaComponent);
        String string2 = WizardUtils.getSchemaComponentName(this.targetSchemaComponent);
        return MessageFormat.format(MSG_PATTERN_DIFFERENT_TYPES, string, string2);
    }

    private String getWarningMsgUnknownType() {
        String string = WizardUtils.getSchemaComponentName(this.resultTypesCompatibility == TypesCompatibilityValidator.TypesCompatibilityResult.SOURCE_BASE_TYPE_UNKNOWN ? this.sourceSchemaComponent : this.targetSchemaComponent);
        String string2 = WizardUtils.getSchemaComponentTypeName(this.resultTypesCompatibility == TypesCompatibilityValidator.TypesCompatibilityResult.SOURCE_BASE_TYPE_UNKNOWN ? this.sourceSchemaComponent : this.targetSchemaComponent);
        return MessageFormat.format(MSG_PATTERN_UNKNOWN_BASE_TYPE, string, string2);
    }

    private String getWarningMsgOnlyBaseTypeEqual() {
        String string = WizardUtils.getSchemaComponentName(this.sourceSchemaComponent);
        String string2 = WizardUtils.getSchemaComponentName(this.targetSchemaComponent);
        return MessageFormat.format(MSG_PATTERN_ONLY_BASE_TYPES_EQUAL, this.resolvedTypeName, string, string2);
    }

    public String getWarningMessage() {
        if (this.resultTypesCompatibility == TypesCompatibilityValidator.TypesCompatibilityResult.SOURCE_BASE_TYPE_UNKNOWN || this.resultTypesCompatibility == TypesCompatibilityValidator.TypesCompatibilityResult.TARGET_BASE_TYPE_UNKNOWN) {
            return this.getWarningMsgUnknownType();
        }
        if (this.resultTypesCompatibility == TypesCompatibilityValidator.TypesCompatibilityResult.BASE_TYPES_UNEQUAL) {
            return this.getWarningMsgDifferentTypes();
        }
        if (this.resultTypesCompatibility == TypesCompatibilityValidator.TypesCompatibilityResult.BASE_TYPES_EQUAL) {
            return this.getWarningMsgOnlyBaseTypeEqual();
        }
        return null;
    }
}

