/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.bpel.editors.api.nodes.RefactoringNodeFactory;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.support.BpelModelVisitor;
import org.netbeans.modules.bpel.nodes.refactoring.RefactoringBpelModelVisitor;
import org.netbeans.modules.bpel.nodes.refactoring.RefactoringNodeCreator;
import org.netbeans.modules.bpel.nodes.refactoring.UnknownUsageNodeCreator;
import org.netbeans.modules.bpel.nodes.refactoring.UsageContextNodeCreator;
import org.netbeans.modules.bpel.nodes.refactoring.UsageDetailNodeCreator;
import org.netbeans.modules.bpel.nodes.refactoring.UsageNodeType;
import org.netbeans.modules.bpel.nodes.refactoring.UsageObjectNodeCreator;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.BPELExtensibilityComponent;
import org.netbeans.modules.xml.xam.Component;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactoringNodeFactoryImpl
implements RefactoringNodeFactory {
    private static AtomicReference<RefactoringNodeFactory> FACTORY_INSTANCE = new AtomicReference();
    private static Map<UsageNodeType, RefactoringNodeCreator> TYPE_CREATOR_MAP = new HashMap<UsageNodeType, RefactoringNodeCreator>();
    private static Map<Class<? extends BpelEntity>, Boolean> USAGE_DETAIL_MAP;

    public Node createNode(Component component) {
        Node node = null;
        UsageNodeType usageNodeType = null;
        if (component instanceof BpelEntity) {
            usageNodeType = (UsageNodeType)((Object)((BpelEntity)component).getCookie(UsageNodeType.class));
        }
        if ((node = this.createNode(usageNodeType = usageNodeType != null ? usageNodeType : UsageNodeType.USAGE_OBJECT, component)) == null) {
            node = this.createNode(UsageNodeType.USAGE_UNKNOWN, component);
        }
        assert (node != null);
        return node;
    }

    public List<Component> getPathFromRoot(Component component) {
        assert (component != null);
        if (component instanceof BPELExtensibilityComponent) {
            return this.getPathFromRoot((BPELExtensibilityComponent)component);
        }
        if (component instanceof BpelEntity) {
            ArrayList<Component> arrayList = new ArrayList<Component>();
            RefactoringBpelModelVisitor refactoringBpelModelVisitor = new RefactoringBpelModelVisitor(arrayList);
            ((BpelEntity)component).accept((BpelModelVisitor)refactoringBpelModelVisitor);
            if (!arrayList.equals(Collections.EMPTY_LIST)) {
                return arrayList;
            }
            BpelEntity bpelEntity = (BpelEntity)component;
            if (this.isUsageDetailEntity(bpelEntity)) {
                bpelEntity.setCookie(UsageNodeType.class, (Object)UsageNodeType.USAGE_DETAIL);
                return this.getPathFromRoot(bpelEntity, true);
            }
            bpelEntity.setCookie(UsageNodeType.class, (Object)UsageNodeType.USAGE_OBJECT);
            return this.getPathFromRoot(bpelEntity, false);
        }
        return this.getDefaultPathFromRoot(component);
    }

    private Node createNode(UsageNodeType usageNodeType, Object object) {
        Node node = null;
        RefactoringNodeCreator refactoringNodeCreator = TYPE_CREATOR_MAP.get((Object)usageNodeType);
        if (refactoringNodeCreator != null && refactoringNodeCreator.isSupported(usageNodeType)) {
            node = refactoringNodeCreator.create(usageNodeType, object);
        }
        return node;
    }

    private List<Component> getPathFromRoot(BpelEntity bpelEntity, boolean bl) {
        int n;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        BpelEntity bpelEntity2 = bpelEntity;
        arrayList.add((Component)bpelEntity2);
        int n2 = 0;
        int n3 = n = bl ? 2 : 1;
        while (bpelEntity2.getParent() != null && n2 < n) {
            bpelEntity2 = bpelEntity2.getParent();
            bpelEntity2.setCookie(UsageNodeType.class, (Object)(++n2 == 1 && bl ? UsageNodeType.USAGE_OBJECT : UsageNodeType.USAGE_CONTEXT));
            arrayList.add(0, (Component)bpelEntity2);
        }
        return arrayList;
    }

    private List<Component> getPathFromRoot(BPELExtensibilityComponent bPELExtensibilityComponent) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        BPELExtensibilityComponent bPELExtensibilityComponent2 = bPELExtensibilityComponent;
        arrayList.add((Component)bPELExtensibilityComponent2);
        boolean bl = false;
        while (bPELExtensibilityComponent2.getParent() instanceof BPELExtensibilityComponent) {
            bPELExtensibilityComponent2 = (BPELExtensibilityComponent)bPELExtensibilityComponent2.getParent();
            arrayList.add(0, (Component)bPELExtensibilityComponent2);
        }
        return arrayList;
    }

    private List<Component> getDefaultPathFromRoot(Component component) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Component component2 = component;
        arrayList.add(component2);
        boolean bl = false;
        while (component2.getParent() != null) {
            component2 = component2.getParent();
            arrayList.add(0, component2);
        }
        return arrayList;
    }

    private boolean isUsageDetailEntity(BpelEntity bpelEntity) {
        assert (bpelEntity != null);
        boolean bl = false;
        if (bpelEntity.getParent() == null) {
            return bl;
        }
        BpelContainer bpelContainer = bpelEntity.getParent().getParent();
        if (bpelContainer == null) {
            return bl;
        }
        bl = USAGE_DETAIL_MAP.get(bpelContainer.getElementType()) != null && USAGE_DETAIL_MAP.get(bpelContainer.getElementType()) != false;
        return bl;
    }

    static {
        TYPE_CREATOR_MAP.put(UsageNodeType.USAGE_CONTEXT, new UsageContextNodeCreator());
        TYPE_CREATOR_MAP.put(UsageNodeType.USAGE_OBJECT, new UsageObjectNodeCreator());
        TYPE_CREATOR_MAP.put(UsageNodeType.USAGE_DETAIL, new UsageDetailNodeCreator());
        TYPE_CREATOR_MAP.put(UsageNodeType.USAGE_UNKNOWN, new UnknownUsageNodeCreator());
        USAGE_DETAIL_MAP = new HashMap<Class<? extends BpelEntity>, Boolean>();
        USAGE_DETAIL_MAP.put(Assign.class, true);
    }
}

