/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.refactoring;

import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.utils.Util;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.nodes.refactoring.RefactoringNodeCreator;
import org.netbeans.modules.bpel.nodes.refactoring.UsageNodeType;
import org.netbeans.modules.bpel.properties.PropertyNodeFactory;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.BPELExtensibilityComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PropertyAlias;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Query;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.Component;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public abstract class RefactoringNodeCreatorAbstract
implements RefactoringNodeCreator {
    protected Node getInternalNode(UsageNodeType usageNodeType, Object object) {
        if (!this.isSupported(usageNodeType)) {
            return null;
        }
        PropertyNodeFactory propertyNodeFactory = PropertyNodeFactory.getInstance();
        Node node = null;
        NodeType nodeType = null;
        if (object instanceof BPELExtensibilityComponent) {
            nodeType = this.getBpelExtensionElementNodeType((BPELExtensibilityComponent)object);
        } else if (object instanceof BpelEntity) {
            nodeType = Util.getBasicNodeType((Component)((BpelEntity)object));
            if (nodeType == NodeType.VARIABLE_CONTAINER || nodeType == NodeType.VARIABLE_CONTAINER || nodeType == NodeType.CORRELATION_SET_CONTAINER || nodeType == NodeType.MESSAGE_EXCHANGE_CONTAINER) {
                object = ((BpelEntity)object).getParent();
            }
            if (nodeType == null || nodeType == NodeType.UNKNOWN_TYPE) {
                nodeType = NodeType.DEFAULT_BPEL_ENTITY_NODE;
            }
        }
        if (nodeType != null) {
            node = propertyNodeFactory.createNode(nodeType, object, Children.LEAF, Lookup.getDefault());
        }
        return node;
    }

    private NodeType getBpelExtensionElementNodeType(BPELExtensibilityComponent bPELExtensibilityComponent) {
        if (bPELExtensibilityComponent instanceof PropertyAlias) {
            return NodeType.CORRELATION_PROPERTY_ALIAS;
        }
        if (bPELExtensibilityComponent instanceof PartnerLinkType) {
            return NodeType.PARTNER_LINK_TYPE;
        }
        if (bPELExtensibilityComponent instanceof CorrelationProperty) {
            return NodeType.CORRELATION_PROPERTY;
        }
        if (bPELExtensibilityComponent instanceof Role) {
            return NodeType.PARTNER_ROLE;
        }
        if (bPELExtensibilityComponent instanceof Query) {
            return NodeType.QUERY;
        }
        return NodeType.UNKNOWN_TYPE;
    }
}

