/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes;

import java.awt.Component;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.nodes.actions.ActionType;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.CorrelationContainer;
import org.netbeans.modules.bpel.model.api.FromPart;
import org.netbeans.modules.bpel.model.api.FromPartContainer;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.ImportRegistrationHelper;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.editors.OnEventCustomEditor;
import org.netbeans.modules.bpel.properties.props.CustomEditorProperty;
import org.netbeans.modules.bpel.properties.props.PropertyUtils;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.nodes.InstanceRef;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnEventNode
extends BpelNode<OnEvent> {
    public OnEventNode(OnEvent onEvent, Lookup lookup) {
        super(onEvent, lookup);
    }

    public OnEventNode(OnEvent onEvent, Children children, Lookup lookup) {
        super(onEvent, children, lookup);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ON_EVENT;
    }

    @Override
    protected boolean isEventRequreUpdate(ChangeEvent changeEvent) {
        if (super.isEventRequreUpdate(changeEvent)) {
            return true;
        }
        BpelEntity bpelEntity = changeEvent.getParent();
        if (bpelEntity == null) {
            return false;
        }
        Object t = this.getReference();
        return t != null && t == bpelEntity.getParent() && bpelEntity.getElementType() == CorrelationContainer.class;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (this.getReference() == null) {
            return sheet;
        }
        Sheet.Set set = this.getPropertySet(sheet, Constants.PropertiesGroups.MESSAGE_SET);
        Sheet.Set set2 = this.getPropertySet(sheet, Constants.PropertiesGroups.MAIN_SET);
        CustomEditorProperty customEditorProperty = new CustomEditorProperty(this);
        set.put((Node.Property)customEditorProperty);
        Node.Property property = PropertyUtils.registerAttributeProperty(this, set, "partnerLink", PropertyType.PARTNER_LINK, "getPartnerLink", "setPartnerLink", null);
        property.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
        property.setValue("canEditAsText", (Object)Boolean.FALSE);
        property = PropertyUtils.registerAttributeProperty(this, set, "portType", PropertyType.PORT_TYPE, "getPortType", "setPortType", "removePortType");
        property.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
        property.setValue("canEditAsText", (Object)Boolean.FALSE);
        InstanceRef instanceRef = new InstanceRef(){

            public Object getReference() {
                return OnEventNode.this.getReference();
            }

            public Object getAlternativeReference() {
                return OnEventNode.this;
            }
        };
        property = PropertyUtils.registerAttributeProperty(instanceRef, set, "operation", PropertyType.OPERATION, "getOperation", "setOperationLocal", null);
        property.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
        property.setValue("canEditAsText", (Object)Boolean.FALSE);
        property = PropertyUtils.registerAttributeProperty(instanceRef, set, "variable", PropertyType.EVENT_VARIABLE_NAME, "getVariable", "setVariableLocal", "removeVariableLocal");
        property.setValue("canEditAsText", (Object)Boolean.TRUE);
        property = PropertyUtils.registerAttributeProperty(instanceRef, set, "messageType", PropertyType.VARIABLE_TYPE_QNAME, "getVariableTypeQName", null, null);
        property.setValue("canEditAsText", (Object)Boolean.FALSE);
        PropertyUtils.registerProperty(this, set2, PropertyType.DOCUMENTATION, "getDocumentation", "setDocumentation", "removeDocumentation");
        return sheet;
    }

    @Override
    public Component getCustomizer(CustomNodeEditor.EditingMode editingMode) {
        return new OnEventCustomEditor(this, editingMode);
    }

    @Override
    protected ActionType[] getActionsArray() {
        return new ActionType[]{ActionType.ADD_FROM_PALETTE, ActionType.SEPARATOR, ActionType.GO_TO, ActionType.SEPARATOR, ActionType.TOGGLE_BREAKPOINT, ActionType.SEPARATOR, ActionType.SHOW_POPERTY_EDITOR, ActionType.SEPARATOR, ActionType.DEFINE_CORRELATION, ActionType.SEPARATOR, ActionType.REMOVE, ActionType.SEPARATOR, ActionType.PROPERTIES};
    }

    public void setOperationLocal(final WSDLReference<Operation> wSDLReference) throws Exception {
        final OnEvent onEvent = (OnEvent)this.getReference();
        if (onEvent != null) {
            onEvent.getBpelModel().invoke(new Callable(){

                public Object call() throws Exception {
                    onEvent.setOperation(wSDLReference);
                    OnEventNode.updateVarTypeAttribute(onEvent);
                    return null;
                }
            }, (Object)this);
        }
    }

    public void setVariableLocal(final String string) throws Exception {
        if (string == null || string.length() == 0) {
            this.removeVariableLocal();
            return;
        }
        final OnEvent onEvent = (OnEvent)this.getReference();
        if (onEvent != null) {
            onEvent.getBpelModel().invoke(new Callable(){

                public Object call() throws Exception {
                    FromPart[] fromPartArray;
                    onEvent.setVariable(string);
                    FromPartContainer fromPartContainer = onEvent.getFromPartContaner();
                    FromPart[] fromPartArray2 = fromPartArray = fromPartContainer == null ? null : fromPartContainer.getFromParts();
                    if (fromPartArray != null) {
                        for (int i = 0; i < fromPartArray.length; ++i) {
                            fromPartContainer.removeFromPart(i);
                        }
                    }
                    OnEventNode.updateVarTypeAttribute(onEvent);
                    return null;
                }
            }, (Object)this);
        }
    }

    public void removeVariableLocal() throws Exception {
        final OnEvent onEvent = (OnEvent)this.getReference();
        if (onEvent != null) {
            onEvent.getBpelModel().invoke(new Callable(){

                public Object call() throws Exception {
                    onEvent.removeVariable();
                    onEvent.removeMessageType();
                    onEvent.removeElement();
                    return null;
                }
            }, (Object)this);
        }
    }

    public static void updateVarTypeAttribute(OnEvent onEvent) {
        String string = onEvent.getVariable();
        if (string != null && string.length() != 0) {
            Message message;
            NamedComponentReference namedComponentReference;
            Input input;
            Operation operation;
            WSDLReference wSDLReference = onEvent.getOperation();
            if (wSDLReference != null && (operation = (Operation)wSDLReference.get()) != null && (input = operation.getInput()) != null && (namedComponentReference = input.getMessage()) != null && (message = (Message)namedComponentReference.get()) != null) {
                OnEventNode.addTypeAttributes(onEvent, message);
            }
        } else {
            onEvent.removeMessageType();
            onEvent.removeElement();
        }
    }

    private static void addTypeAttributes(OnEvent onEvent, Message message) {
        GlobalElement globalElement = null;
        Object object = null;
        Message message2 = null;
        WSDLReference wSDLReference = onEvent.getMessageType();
        if (wSDLReference != null) {
            message2 = (Message)wSDLReference.get();
        }
        if (message2 == null && object == null || message2 != null && object != null) {
            if (globalElement != null) {
                OnEventNode.setElementType(onEvent, globalElement);
            } else if (message != null) {
                OnEventNode.setMessageType(onEvent, message);
            }
        } else if (message2 == null && object != null) {
            if (globalElement != null) {
                if (!object.equals(globalElement)) {
                    OnEventNode.setElementType(onEvent, globalElement);
                }
            } else if (message != null) {
                OnEventNode.setMessageType(onEvent, message);
            }
        } else if (message2 != null && object == null) {
            if (message != null) {
                if (!message2.equals(message)) {
                    OnEventNode.setMessageType(onEvent, message);
                }
            } else if (globalElement != null) {
                OnEventNode.setElementType(onEvent, globalElement);
            }
        }
    }

    private static void setMessageType(OnEvent onEvent, Message message) {
        WSDLReference wSDLReference = onEvent.createWSDLReference((ReferenceableWSDLComponent)message, Message.class);
        onEvent.setMessageType(wSDLReference);
        onEvent.removeElement();
    }

    private static void setElementType(OnEvent onEvent, GlobalElement globalElement) {
        SchemaReference schemaReference = onEvent.createSchemaReference((ReferenceableSchemaComponent)globalElement, GlobalElement.class);
        onEvent.setElement(schemaReference);
        onEvent.removeMessageType();
        SchemaModel schemaModel = globalElement.getModel();
        if (schemaModel != null) {
            new ImportRegistrationHelper(onEvent.getBpelModel()).addImport((Model)schemaModel);
        }
    }

    public QName getVariableTypeQName() {
        QName qName = null;
        OnEvent onEvent = (OnEvent)this.getReference();
        if (onEvent != null) {
            WSDLReference wSDLReference = onEvent.getMessageType();
            if (wSDLReference != null && (qName = wSDLReference.getQName()) != null) {
                return qName;
            }
            SchemaReference schemaReference = onEvent.getElement();
            if (schemaReference != null && (qName = schemaReference.getQName()) != null) {
                return qName;
            }
        }
        return null;
    }

    @Override
    protected void updateComplexProperties(ChangeEvent changeEvent) {
        String string;
        BpelEntity bpelEntity;
        if (changeEvent instanceof PropertyUpdateEvent && (bpelEntity = changeEvent.getParent()) != null && bpelEntity.equals(this.getReference()) && "messageType".equals(string = changeEvent.getName())) {
            this.updateProperty(PropertyType.MESSAGE_TYPE);
        }
    }

    @Override
    public String getHelpId() {
        return "org.netbeans.modules.bpel.properties.editors.OnEventCustomEditor";
    }
}

