/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes;

import java.util.concurrent.Callable;
import org.netbeans.modules.bpel.editors.api.BpelEditorConstants;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.nodes.actions.ActionType;
import org.netbeans.modules.bpel.model.api.BPELElementsBuilder;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.DeadlineExpression;
import org.netbeans.modules.bpel.model.api.For;
import org.netbeans.modules.bpel.model.api.OnAlarmEvent;
import org.netbeans.modules.bpel.model.api.RepeatEvery;
import org.netbeans.modules.bpel.model.api.TimeEvent;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.props.PropertyUtils;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnAlarmEventNode
extends BpelNode<OnAlarmEvent> {
    public OnAlarmEventNode(OnAlarmEvent onAlarmEvent, Lookup lookup) {
        super(onAlarmEvent, lookup);
    }

    public OnAlarmEventNode(OnAlarmEvent onAlarmEvent, Children children, Lookup lookup) {
        super(onAlarmEvent, children, lookup);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ALARM_EVENT_HANDLER;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (this.getReference() == null) {
            return sheet;
        }
        Sheet.Set set = this.getPropertySet(sheet, Constants.PropertiesGroups.MAIN_SET);
        PropertyUtils.registerCalculatedProperty((Object)this, set, PropertyType.ALARM_EVENT_TYPE, "getAlarmEventType", "setAlarmEventType");
        PropertyUtils.registerElementProperty(this, null, set, For.class, PropertyType.FOR_EXPRESSION, "getTimeEvent", "setTimeEvent", null);
        PropertyUtils.registerElementProperty(this, null, set, DeadlineExpression.class, PropertyType.UNTIL_EXPRESSION, "getTimeEvent", "setTimeEvent", null);
        PropertyUtils.registerElementProperty(this, null, set, RepeatEvery.class, PropertyType.REPEAT_EVERY_EXPRESSION, "getRepeatEvery", "setRepeatEvery", "removeRepeatEvery");
        this.updateAlarmEventTypeState(null, sheet.toArray());
        PropertyUtils.registerProperty(this, set, PropertyType.DOCUMENTATION, "getDocumentation", "setDocumentation", "removeDocumentation");
        return sheet;
    }

    public BpelEditorConstants.AlarmEventType getAlarmEventType() {
        OnAlarmEvent onAlarmEvent = (OnAlarmEvent)this.getReference();
        if (onAlarmEvent == null) {
            return null;
        }
        TimeEvent timeEvent = onAlarmEvent.getTimeEvent();
        RepeatEvery repeatEvery = onAlarmEvent.getRepeatEvery();
        BpelEditorConstants.AlarmEventType alarmEventType = BpelEditorConstants.AlarmEventType.INVALID;
        if (timeEvent == null && repeatEvery == null) {
            alarmEventType = BpelEditorConstants.AlarmEventType.NOT_ASSIGNED;
        } else if (timeEvent == null && repeatEvery != null) {
            alarmEventType = BpelEditorConstants.AlarmEventType.REPEAT_TIME;
        } else if (timeEvent != null && repeatEvery == null) {
            if (timeEvent instanceof For) {
                alarmEventType = BpelEditorConstants.AlarmEventType.FOR_TIME;
            } else if (timeEvent instanceof DeadlineExpression) {
                alarmEventType = BpelEditorConstants.AlarmEventType.UNTIL_TIME;
            }
        } else if (timeEvent != null && repeatEvery != null) {
            if (timeEvent instanceof For) {
                alarmEventType = BpelEditorConstants.AlarmEventType.FOR_REPEAT_TIME;
            } else if (timeEvent instanceof DeadlineExpression) {
                alarmEventType = BpelEditorConstants.AlarmEventType.UNTIL_REPEAT_TIME;
            }
        }
        return alarmEventType;
    }

    public void setAlarmEventType(BpelEditorConstants.AlarmEventType alarmEventType) throws Exception {
        BpelEditorConstants.AlarmEventType alarmEventType2 = this.getAlarmEventType();
        if (alarmEventType == alarmEventType2) {
            return;
        }
        final OnAlarmEvent onAlarmEvent = (OnAlarmEvent)this.getReference();
        if (onAlarmEvent == null) {
            return;
        }
        BpelModel bpelModel = onAlarmEvent.getBpelModel();
        final BPELElementsBuilder bPELElementsBuilder = bpelModel.getBuilder();
        switch (alarmEventType) {
            case REPEAT_TIME: {
                bpelModel.invoke(new Callable(){

                    public Object call() throws Exception {
                        if (onAlarmEvent.getRepeatEvery() == null) {
                            onAlarmEvent.setRepeatEvery(bPELElementsBuilder.createRepeatEvery());
                        }
                        onAlarmEvent.removeTimeEvent();
                        return null;
                    }
                }, (Object)this);
                break;
            }
            case FOR_TIME: {
                bpelModel.invoke(new Callable(){

                    public Object call() throws Exception {
                        onAlarmEvent.removeRepeatEvery();
                        TimeEvent timeEvent = onAlarmEvent.getTimeEvent();
                        if (timeEvent == null || !(timeEvent instanceof For)) {
                            onAlarmEvent.setTimeEvent((TimeEvent)bPELElementsBuilder.createFor());
                        }
                        return null;
                    }
                }, (Object)this);
                break;
            }
            case UNTIL_TIME: {
                bpelModel.invoke(new Callable(){

                    public Object call() throws Exception {
                        onAlarmEvent.removeRepeatEvery();
                        TimeEvent timeEvent = onAlarmEvent.getTimeEvent();
                        if (timeEvent == null || !(timeEvent instanceof DeadlineExpression)) {
                            onAlarmEvent.setTimeEvent((TimeEvent)bPELElementsBuilder.createUntil());
                        }
                        return null;
                    }
                }, (Object)this);
                break;
            }
            case FOR_REPEAT_TIME: {
                bpelModel.invoke(new Callable(){

                    public Object call() throws Exception {
                        TimeEvent timeEvent = onAlarmEvent.getTimeEvent();
                        if (timeEvent == null || !(timeEvent instanceof For)) {
                            onAlarmEvent.setTimeEvent((TimeEvent)bPELElementsBuilder.createFor());
                        }
                        if (onAlarmEvent.getRepeatEvery() == null) {
                            onAlarmEvent.setRepeatEvery(bPELElementsBuilder.createRepeatEvery());
                        }
                        return null;
                    }
                }, (Object)this);
                break;
            }
            case UNTIL_REPEAT_TIME: {
                bpelModel.invoke(new Callable(){

                    public Object call() throws Exception {
                        TimeEvent timeEvent = onAlarmEvent.getTimeEvent();
                        if (timeEvent == null || !(timeEvent instanceof DeadlineExpression)) {
                            onAlarmEvent.setTimeEvent((TimeEvent)bPELElementsBuilder.createUntil());
                        }
                        if (onAlarmEvent.getRepeatEvery() == null) {
                            onAlarmEvent.setRepeatEvery(bPELElementsBuilder.createRepeatEvery());
                        }
                        return null;
                    }
                }, (Object)this);
                break;
            }
        }
        this.updateAlarmEventTypeState(this.getAlarmEventType(), this.getPropertySets());
    }

    public void updateAlarmEventTypeState(BpelEditorConstants.AlarmEventType alarmEventType, Node.PropertySet[] propertySetArray) {
        if (alarmEventType == null) {
            alarmEventType = this.getAlarmEventType();
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        switch (alarmEventType) {
            case REPEAT_TIME: {
                bl = true;
                bl2 = true;
                bl3 = false;
                break;
            }
            case FOR_TIME: {
                bl = false;
                bl2 = true;
                bl3 = true;
                break;
            }
            case UNTIL_TIME: {
                bl = true;
                bl2 = false;
                bl3 = true;
                break;
            }
            case FOR_REPEAT_TIME: {
                bl = false;
                bl2 = true;
                bl3 = false;
                break;
            }
            case UNTIL_REPEAT_TIME: {
                bl = true;
                bl2 = false;
                bl3 = false;
                break;
            }
            case NOT_ASSIGNED: 
            case INVALID: {
                bl = true;
                bl2 = true;
                bl3 = true;
            }
        }
        Node.Property property = PropertyUtils.lookForPropertyByType(propertySetArray, PropertyType.FOR_EXPRESSION);
        if (property != null) {
            property.setHidden(bl);
        }
        if ((property = PropertyUtils.lookForPropertyByType(propertySetArray, PropertyType.UNTIL_EXPRESSION)) != null) {
            property.setHidden(bl2);
        }
        if ((property = PropertyUtils.lookForPropertyByType(propertySetArray, PropertyType.REPEAT_EVERY_EXPRESSION)) != null) {
            property.setHidden(bl3);
        }
        this.firePropertySetsChange(null, null);
    }

    @Override
    protected ActionType[] getActionsArray() {
        return new ActionType[]{ActionType.ADD_FROM_PALETTE, ActionType.SEPARATOR, ActionType.GO_TO, ActionType.SEPARATOR, ActionType.TOGGLE_BREAKPOINT, ActionType.SEPARATOR, ActionType.REMOVE, ActionType.SEPARATOR, ActionType.PROPERTIES};
    }

    @Override
    public String getHelpId() {
        return "orch_elements_event_handler_onalarm";
    }
}

