/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.nodes.actions.ActionType;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.bpel.properties.props.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportNode
extends BpelNode<Import> {
    public ImportNode(Import import_, Children children, Lookup lookup) {
        super(import_, children, lookup);
    }

    public ImportNode(Import import_, Lookup lookup) {
        super(import_, lookup);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.IMPORT;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = this.getPropertySet(sheet, Constants.PropertiesGroups.MAIN_SET);
        PropertyUtils.registerAttributeProperty(this, set, "importType", PropertyType.IMPORT_TYPE, "getImportType", "setImportType", null);
        PropertyUtils.registerAttributeProperty(this, set, "namespace", PropertyType.IMPORT_NAMESPACE, "getNamespace", "setNamespace", "removeNamespace");
        PropertyUtils.registerAttributeProperty(this, set, "location", PropertyType.IMPORT_LOCATION, "getLocation", "setLocation", "removeLocation");
        PropertyUtils.registerProperty(this, set, PropertyType.DOCUMENTATION, "getDocumentation", "setDocumentation", "removeDocumentation");
        return sheet;
    }

    @Override
    public String getNameImpl() {
        Import import_ = (Import)this.getReference();
        if (import_ == null) {
            return super.getNameImpl();
        }
        String string = this.getRelativePath(import_);
        if (string != null && string.length() > 0) {
            return string;
        }
        String string2 = import_.getLocation();
        if (string2 != null && string2.length() > 0) {
            return ResolverUtility.decodeLocation(string2);
        }
        String string3 = import_.getNamespace();
        if (string3 != null && string3.length() > 0) {
            return string3;
        }
        return "Unqualified";
    }

    @Override
    public Component getCustomizer() {
        return null;
    }

    @Override
    protected ActionType[] getActionsArray() {
        return new ActionType[]{ActionType.GO_TO_SOURCE, ActionType.SEPARATOR, ActionType.REMOVE, ActionType.SEPARATOR, ActionType.PROPERTIES};
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public boolean canCut() {
        return false;
    }

    public Transferable drag() throws IOException {
        return this.clipboardCopy();
    }

    @Override
    public Transferable clipboardCut() throws IOException {
        DataObject dataObject = this.getDataObject();
        if (dataObject != null) {
            Node node = dataObject.getNodeDelegate();
            return node != null ? node.clipboardCut() : null;
        }
        return null;
    }

    @Override
    public Transferable clipboardCopy() throws IOException {
        DataObject dataObject = this.getDataObject();
        if (dataObject != null) {
            Node node = dataObject.getNodeDelegate();
            return node != null ? node.clipboardCopy() : null;
        }
        return null;
    }

    private String getRelativePath(Import import_) {
        assert (import_ != null);
        FileObject fileObject = ResolverUtility.getImportedFileObject(import_);
        Project project = Utils.safeGetProject((BpelModel)import_.getBpelModel());
        return ResolverUtility.safeGetRelativePath(fileObject, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataObject getDataObject() {
        Import import_ = (Import)this.getReference();
        FileObject fileObject = null;
        Import import_2 = import_;
        synchronized (import_2) {
            if (import_ == null) {
                return null;
            }
            fileObject = ResolverUtility.getImportedFileObject(import_);
        }
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        try {
            import_2 = DataObject.find((FileObject)fileObject);
            return import_2;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }
}

