/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes;

import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.nodes.actions.ActionType;
import org.netbeans.modules.bpel.editors.api.utils.Util;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.FromChild;
import org.netbeans.modules.bpel.model.api.Literal;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.Query;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityRemoveEvent;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.Roles;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.DecorationProvider;
import org.netbeans.modules.bpel.nodes.validation.ValidationProxyListener;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.bpel.properties.props.PropertyUtils;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyNode
extends BpelNode<Copy> {
    public CopyNode(Copy copy, Lookup lookup) {
        super(copy, lookup);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.COPY;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (this.getReference() == null) {
            return sheet;
        }
        Sheet.Set set = this.getPropertySet(sheet, Constants.PropertiesGroups.MAIN_SET);
        PropertyUtils.registerElementProperty(this, null, set, From.class, PropertyType.COPY_FROM, "getFrom", null, null);
        PropertyUtils.registerElementProperty(this, null, set, To.class, PropertyType.COPY_TO, "getTo", null, null);
        PropertyUtils.registerProperty(this, set, PropertyType.DOCUMENTATION, "getDocumentation", "setDocumentation", "removeDocumentation");
        return sheet;
    }

    @Override
    protected boolean isEventRequreUpdate(ChangeEvent changeEvent) {
        assert (changeEvent != null);
        boolean bl = false;
        bl = super.isEventRequreUpdate(changeEvent);
        if (bl) {
            return bl;
        }
        BpelEntity bpelEntity = changeEvent.getParent();
        if (bpelEntity == null) {
            return false;
        }
        Copy copy = (Copy)this.getReference();
        return copy != null && copy == bpelEntity.getParent() && (bpelEntity.getElementType() == From.class || bpelEntity.getElementType() == To.class);
    }

    @Override
    protected boolean isRequireNameUpdate(ChangeEvent changeEvent) {
        assert (changeEvent != null);
        if (super.isRequireNameUpdate(changeEvent)) {
            return true;
        }
        BpelEntity bpelEntity = changeEvent.getParent();
        Copy copy = (Copy)this.getReference();
        if (bpelEntity == null || copy == null || copy != bpelEntity) {
            return false;
        }
        return changeEvent instanceof EntityRemoveEvent || changeEvent instanceof EntityInsertEvent;
    }

    @Override
    protected Validator.ResultType getValidationStatus(ValidationProxyListener validationProxyListener) {
        Validator.ResultType resultType = super.getValidationStatus(validationProxyListener);
        if (resultType != null) {
            return resultType;
        }
        Copy copy = (Copy)this.getReference();
        From from = copy.getFrom();
        To to = copy.getTo();
        Validator.ResultType resultType2 = validationProxyListener.getValidationStatusForElement(from);
        Validator.ResultType resultType3 = validationProxyListener.getValidationStatusForElement(to);
        resultType = ValidationProxyListener.getPriorytestType(resultType2, resultType3);
        return resultType;
    }

    @Override
    protected boolean isValidationAnnotatedEntity(Component component) {
        To to;
        From from;
        boolean bl = super.isValidationAnnotatedEntity(component);
        if (bl) {
            return true;
        }
        Copy copy = (Copy)this.getReference();
        From from2 = from = copy == null ? null : copy.getFrom();
        if (from != null && from.equals(component)) {
            return true;
        }
        To to2 = to = copy == null ? null : copy.getTo();
        return to != null && to.equals(component);
    }

    @Override
    protected boolean isComplexValidationStatus() {
        return true;
    }

    public static String serializeFrom(From from) {
        String string;
        BpelReference bpelReference;
        Object object;
        if (from == null) {
            return null;
        }
        String string2 = from.getContent();
        if (string2 != null && string2.length() != 0) {
            return string2;
        }
        FromChild fromChild = from.getFromChild();
        if (fromChild != null && fromChild instanceof Literal && (object = (bpelReference = (Literal)fromChild).getContent()) != null && ((String)object).length() != 0) {
            return bpelReference.getContent();
        }
        bpelReference = from.getVariable();
        object = from.getPartnerLink();
        StringBuilder stringBuilder = new StringBuilder(200);
        if (bpelReference != null) {
            String string3 = ResolverUtility.getNameByRef((Reference)bpelReference);
            if (string3 != null) {
                String string4;
                String string5;
                stringBuilder.append(string3);
                WSDLReference wSDLReference = from.getProperty();
                if (wSDLReference != null && (string5 = ResolverUtility.getNameByRef((Reference)wSDLReference)) != null && string5.length() != 0) {
                    stringBuilder.append("/").append(string5);
                }
                if ((string5 = from.getPart()) != null && (string4 = ResolverUtility.getNameByRef((Reference)string5)) != null && string4.length() != 0) {
                    stringBuilder.append(".").append(string4);
                }
                if (fromChild != null && fromChild instanceof Query && (string4 = ((Query)fromChild).getContent()) != null && string4.length() != 0) {
                    stringBuilder.append("/").append(string4);
                }
            }
        } else if (object != null && (string = ResolverUtility.getNameByRef((Reference)object)) != null) {
            Roles roles = from.getEndpointReference();
            if (roles == null) {
                stringBuilder.append(string);
            } else {
                PartnerLinkContainer partnerLinkContainer;
                PartnerLink partnerLink = (PartnerLink)object.get();
                if (partnerLink == null && (partnerLinkContainer = from.getBpelModel().getProcess().getPartnerLinkContainer()) != null) {
                    PartnerLink[] partnerLinkArray;
                    for (PartnerLink partnerLink2 : partnerLinkArray = partnerLinkContainer.getPartnerLinks()) {
                        if (partnerLink2 == null || !string.equals(partnerLink2.getName())) continue;
                        partnerLink = partnerLink2;
                        break;
                    }
                }
                if (partnerLink != null) {
                    switch (roles) {
                        case MY_ROLE: {
                            stringBuilder.append(string).append("/").append((Object)PropertyType.MY_ROLE);
                            break;
                        }
                        case PARTNER_ROLE: {
                            stringBuilder.append(string).append("/").append((Object)PropertyType.PARTNER_ROLE);
                        }
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String serializeTo(To to) {
        String string;
        if (to == null) {
            return null;
        }
        String string2 = to.getContent();
        if (string2 != null && string2.length() != 0) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        BpelReference bpelReference = to.getVariable();
        BpelReference bpelReference2 = to.getPartnerLink();
        if (bpelReference != null) {
            String string3 = ResolverUtility.getNameByRef((Reference)bpelReference);
            if (string3 != null) {
                String string4;
                String string5;
                String string6;
                stringBuilder.append(string3);
                WSDLReference wSDLReference = to.getProperty();
                if (wSDLReference != null && (string6 = ResolverUtility.getNameByRef((Reference)wSDLReference)) != null && string6.length() != 0) {
                    stringBuilder.append("/").append(string6);
                }
                if ((string6 = to.getPart()) != null && (string5 = ResolverUtility.getNameByRef((Reference)string6)) != null && string5.length() != 0) {
                    stringBuilder.append(".").append(string5);
                }
                if ((string5 = to.getQuery()) != null && (string4 = string5.getContent()) != null && string4.length() != 0) {
                    stringBuilder.append(string4);
                }
            }
        } else if (bpelReference2 != null && (string = ResolverUtility.getNameByRef((Reference)bpelReference2)) != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getImplHtmlDisplayName() {
        Copy copy = (Copy)this.getReference();
        if (copy == null) {
            return super.getImplHtmlDisplayName();
        }
        String string = null;
        String string2 = null;
        From from = copy.getFrom();
        To to = copy.getTo();
        if (from == null || to == null) {
            return "";
        }
        string = DecorationProvider.Util.getFromLabel(from);
        string2 = DecorationProvider.Util.getToLabel(to);
        if (string == null && string2 == null) {
            return "";
        }
        string = string == null ? "" : string;
        string2 = string2 == null ? "" : string2;
        return Util.getCorrectedHtmlRenderedString((String)NbBundle.getMessage(CopyNode.class, (String)"LBL_Copy", (Object)string2, (Object)string));
    }

    @Override
    protected ActionType[] getActionsArray() {
        return new ActionType[]{ActionType.GO_TO_SOURCE, ActionType.SEPARATOR, ActionType.MOVE_COPY_UP, ActionType.MOVE_COPY_DOWN, ActionType.SEPARATOR, ActionType.TOGGLE_BREAKPOINT, ActionType.SEPARATOR, ActionType.REMOVE, ActionType.SEPARATOR, ActionType.PROPERTIES};
    }
}

