/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.diagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.diagram.DiagramDecorator;
import org.netbeans.modules.bpel.diagram.DiagramElementImpl;
import org.netbeans.modules.bpel.editors.api.diagram.Diagram;
import org.netbeans.modules.bpel.editors.api.diagram.DiagramElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiagramImpl
implements Diagram {
    private DesignView myView;

    public DiagramImpl(DesignView designView) {
        this.myView = designView;
    }

    public JComponent getComponent() {
        return this.myView;
    }

    public List<DiagramElement> getElements(boolean bl) {
        DiagramModel diagramModel = this.myView.getModel();
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        this.travel(this.getRoot(diagramModel, bl), arrayList, "");
        return arrayList;
    }

    private void travel(Pattern pattern, List<DiagramElement> list, String string) {
        if (pattern == null) {
            return;
        }
        this.travel(pattern.getElements(), list, string);
        if (pattern instanceof CompositePattern) {
            CompositePattern compositePattern = (CompositePattern)pattern;
            this.travel(compositePattern.getBorder(), list, string);
            List<Pattern> list2 = compositePattern.getNestedPatterns();
            for (Pattern pattern2 : list2) {
                this.travel(pattern2, list, string + "  ");
            }
        }
    }

    private void travel(Collection<VisualElement> collection, List<DiagramElement> list, String string) {
        for (VisualElement visualElement : collection) {
            this.travel(visualElement, list, string);
        }
    }

    private void travel(VisualElement visualElement, List<DiagramElement> list, String string) {
        if (visualElement != null) {
            list.add(new DiagramElementImpl(visualElement));
        }
    }

    private Pattern getRoot(DiagramModel diagramModel, boolean bl) {
        if (bl) {
            return diagramModel.getView().getSelectionModel().getSelectedPattern();
        }
        return diagramModel.getRootPattern();
    }

    public void clearHighlighting() {
        DiagramDecorator.getDecorator(this.myView).clearHighlighting();
    }
}

