/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.selection;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.netbeans.modules.bpel.design.geometry.FEllipse;
import org.netbeans.modules.bpel.design.geometry.FPath;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.geometry.FShape;
import org.netbeans.modules.bpel.design.geometry.FStroke;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;

public abstract class PlaceHolder {
    private Pattern ownerPattern;
    private Pattern draggedPattern;
    private boolean mouseHover;
    private FPath path;
    private FShape shape;
    private static final FShape INNER_SHAPE = new FEllipse(-5.0, -5.0, 10.0, 10.0);
    private static final FShape SHAPE = new FEllipse(20.0);
    private static final Color OUTER_FILL = new Color(16579317);
    private static final Color OUTER_STROKE_COLOR = new Color(0xFF9900);
    private static final Color INNER_FILL = new Color(0xFFFFFF);
    private static final Color INNER_FILL_MOUSE_HOVER = new Color(0xFF9900);
    private static final Color INNER_STROKE_COLOR = new Color(0xB3B3B3);
    private static final FStroke OUTER_STROKE = new FStroke(1.0, 3.0);
    private static final FStroke INNER_STROKE = new FStroke(1.0);

    public PlaceHolder(Pattern pattern, Pattern pattern2, double d, double d2) {
        this(pattern, pattern2, d, d2, null);
    }

    public PlaceHolder(Pattern pattern, Pattern pattern2, FPoint fPoint) {
        this(pattern, pattern2, fPoint.x, fPoint.y, null);
    }

    public PlaceHolder(Pattern pattern, Pattern pattern2, FPath fPath) {
        this(pattern, pattern2, fPath.point(0.5), fPath);
    }

    public PlaceHolder(Pattern pattern, Pattern pattern2, FPoint fPoint, FPath fPath) {
        this(pattern, pattern2, fPoint.x, fPoint.y, fPath);
    }

    public PlaceHolder(Pattern pattern, Pattern pattern2, double d, double d2, FPath fPath) {
        this.ownerPattern = pattern;
        this.draggedPattern = pattern2;
        this.shape = SHAPE.moveCenter(d, d2);
        this.path = fPath;
    }

    public boolean contains(double d, double d2) {
        return this.shape.contains(d, d2);
    }

    public Pattern getDraggedPattern() {
        return this.draggedPattern;
    }

    public Pattern getOwnerPattern() {
        return this.ownerPattern;
    }

    public boolean isMouseHover() {
        return this.mouseHover;
    }

    public void dragEnter() {
        this.mouseHover = true;
    }

    public void dragExit() {
        this.mouseHover = false;
    }

    public abstract void drop();

    public void paint(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setPaint(OUTER_FILL);
        graphics2D.fill(this.shape);
        graphics2D.setStroke(OUTER_STROKE.createStroke(graphics2D));
        graphics2D.setPaint(OUTER_STROKE_COLOR);
        graphics2D.draw(this.shape);
        FPoint fPoint = this.shape.getNormalizedCenter(graphics2D);
        graphics2D.translate(fPoint.x, fPoint.y);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setPaint(this.isMouseHover() ? INNER_FILL_MOUSE_HOVER : INNER_FILL);
        graphics2D.fill(INNER_SHAPE);
        graphics2D.setPaint(INNER_STROKE_COLOR);
        graphics2D.setStroke(INNER_STROKE.createStroke(graphics2D));
        graphics2D.draw(INNER_SHAPE);
        graphics2D.translate(-fPoint.x, -fPoint.y);
    }

    public FShape getShape() {
        return this.shape;
    }
}

