/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.selection;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.decoration.components.LinkToolButton;
import org.netbeans.modules.bpel.design.geometry.FPath;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.elements.InvokeOperationElement;
import org.netbeans.modules.bpel.design.model.elements.OperationElement;
import org.netbeans.modules.bpel.design.model.elements.ReceiveOperationElement;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.PartnerlinkPattern;
import org.netbeans.modules.bpel.design.selection.DnDTool;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.OperationReference;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkReference;
import org.netbeans.modules.bpel.model.api.PortTypeReference;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.references.ReferenceCollection;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;

public class FlowlinkTool
implements DnDTool {
    private VisualElement startElement;
    private VisualElement endElement;
    private static final int INPUT = 1;
    private static final int OUTPUT = 2;
    private static final int INPUT_OUTOUT = 3;
    private DesignView designView;
    private int currentX;
    private int currentY;
    private DiagramView currentView;
    private LinkToolButton button;
    private static final Shape END_MARKER_SHAPE = new Ellipse2D.Float(-2.0f, -2.0f, 4.0f, 4.0f);
    private static final Color ACCEPT_FILL_COLOR = new Color(40960);
    private static final Color ACCEPT_STROKE_COLOR = new Color(0x20A020);
    private static final Color DECLINE_FILL_COLOR = new Color(0xA00000);
    private static final Color DECLINE_STROKE_COLOR = new Color(0xA02020);
    private static final Color COLOR = new Color(15108908);

    public FlowlinkTool(DesignView designView) {
        this.designView = designView;
    }

    public DesignView getDesignView() {
        return this.designView;
    }

    public void init(LinkToolButton linkToolButton) {
        this.button = linkToolButton;
        linkToolButton.setVisible(false);
        VisualElement visualElement = linkToolButton.getPattern().getFirstElement();
        if (visualElement == null || !this.isOperation(visualElement) && !this.isTask(visualElement)) {
            return;
        }
        this.startElement = visualElement;
        this.getDesignView().getDecorationManager().decorationChanged();
    }

    public void move(FPoint fPoint) {
        if (!this.isActive()) {
            return;
        }
        Point point = this.getDesignView().getOverlayView().getMousePosition();
        if (point != null) {
            this.currentView = this.getDesignView().getView(point);
            this.currentX = point.x;
            this.currentY = point.y;
            FPoint fPoint2 = this.currentView.convertPointFromParent(point);
            VisualElement visualElement = this.currentView.findElement(fPoint2.x, fPoint2.y);
            this.endElement = visualElement != null && this.isValidLinkTo(visualElement) ? visualElement : null;
            this.getDesignView().repaint();
        }
    }

    public boolean isValidLocation() {
        return this.endElement != null;
    }

    public void drop(FPoint fPoint) {
        this.drop(fPoint.x, fPoint.y);
    }

    public void drop(double d, double d2) {
        if (!this.isActive()) {
            return;
        }
        this.move(null);
        if (this.endElement != null && this.isValidLinkTo(this.endElement)) {
            VisualElement visualElement;
            VisualElement visualElement2 = visualElement = this.isOperation(this.startElement) ? this.startElement : this.endElement;
            if (visualElement != null) {
                Operation operation;
                VisualElement visualElement3 = this.isOperation(this.startElement) ? this.endElement : this.startElement;
                PartnerlinkPattern partnerlinkPattern = (PartnerlinkPattern)visualElement.getPattern();
                BpelEntity bpelEntity = visualElement3.getPattern().getOMReference();
                BpelReference bpelReference = ((ReferenceCollection)bpelEntity).createReference((BpelReferenceable)((PartnerLink)partnerlinkPattern.getOMReference()), PartnerLink.class);
                if (bpelReference != null) {
                    ((PartnerLinkReference)bpelEntity).setPartnerLink(bpelReference);
                }
                if ((operation = partnerlinkPattern.getOperation(visualElement)) != null) {
                    PortType portType;
                    WSDLReference wSDLReference = ((ReferenceCollection)bpelEntity).createWSDLReference((ReferenceableWSDLComponent)operation, Operation.class);
                    if (wSDLReference != null) {
                        ((OperationReference)bpelEntity).setOperation(wSDLReference);
                    }
                    if ((portType = (PortType)operation.getParent()) != null) {
                        WSDLReference wSDLReference2 = ((ReferenceCollection)bpelEntity).createWSDLReference((ReferenceableWSDLComponent)portType, PortType.class);
                        if (wSDLReference2 != null) {
                            ((PortTypeReference)bpelEntity).setPortType(wSDLReference2);
                        } else {
                            ((PortTypeReference)bpelEntity).removePortType();
                        }
                    }
                }
            }
        }
        this.clear();
    }

    public void clear() {
        this.startElement = null;
        this.endElement = null;
        if (this.button != null) {
            this.button.setVisible(true);
            this.button = null;
        }
        this.getDesignView().repaint();
    }

    public boolean isActive() {
        return this.startElement != null;
    }

    private boolean isValidLinkTo(VisualElement visualElement) {
        if (visualElement == null) {
            return false;
        }
        if (visualElement == this.startElement) {
            return false;
        }
        if (this.isOperation(visualElement) && this.isTask(this.startElement) || this.isOperation(this.startElement) && this.isTask(visualElement)) {
            return (this.getDirections(visualElement) | this.getDirections(this.startElement)) == 3;
        }
        return false;
    }

    private int getDirections(VisualElement visualElement) {
        BpelEntity bpelEntity = visualElement.getPattern().getOMReference();
        if (visualElement instanceof ReceiveOperationElement) {
            return 1;
        }
        if (visualElement instanceof InvokeOperationElement) {
            return 3;
        }
        if (this.isTask(bpelEntity)) {
            if (bpelEntity instanceof Reply) {
                return 2;
            }
            if (bpelEntity instanceof Invoke) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private boolean isOperation(VisualElement visualElement) {
        return visualElement instanceof OperationElement;
    }

    private boolean isSendTask(VisualElement visualElement) {
        BpelEntity bpelEntity = visualElement.getPattern().getOMReference();
        return bpelEntity instanceof Invoke || bpelEntity instanceof Reply;
    }

    private boolean isTask(VisualElement visualElement) {
        return this.isTask(visualElement.getPattern().getOMReference());
    }

    private boolean isTask(BpelEntity bpelEntity) {
        return bpelEntity instanceof OperationReference && bpelEntity instanceof PartnerLinkReference && bpelEntity instanceof PortTypeReference;
    }

    public void paint(Graphics2D graphics2D) {
        Object object;
        if (!this.isActive()) {
            return;
        }
        if (this.currentView != null) {
            FPath fPath;
            object = this.getDesignView().getProcessView().convertPointToParent(new FPoint(this.startElement.getCenterX(), this.startElement.getCenterY()));
            Point point = new Point(this.currentX, this.currentY);
            if (this.isValidLocation()) {
                point = this.currentView.convertPointToParent(new FPoint(this.endElement.getCenterX(), this.endElement.getCenterY()));
            }
            if ((fPath = this.createPath(((Point)object).x, ((Point)object).y, point.x, point.y, !this.isForwardDirection())) != null) {
                Connection.paintConnection(graphics2D, fPath, true, true, false, true, this.isValidLocation() ? null : Color.RED);
            }
        }
        object = (Graphics2D)graphics2D.create();
        ((Graphics2D)object).translate(this.currentX, this.currentY);
        ((Graphics2D)object).translate(-this.button.getWidth() / 2, -this.button.getHeight() / 2);
        this.button.paint((Graphics)object);
        ((Graphics)object).dispose();
    }

    private boolean isForwardDirection() {
        BpelEntity bpelEntity = this.startElement.getPattern().getOMReference();
        if (bpelEntity == null) {
            return true;
        }
        if (bpelEntity instanceof OnMessage || bpelEntity instanceof OnEvent || bpelEntity instanceof Receive) {
            return false;
        }
        if (bpelEntity instanceof Invoke || bpelEntity instanceof Reply) {
            return true;
        }
        return true;
    }

    private FPath createPath(double d, double d2, double d3, double d4, boolean bl) {
        boolean bl2;
        if (bl) {
            double d5 = d;
            d = d3;
            d3 = d5;
            d5 = d2;
            d2 = d4;
            d4 = d5;
        }
        boolean bl3 = d != d3;
        boolean bl4 = bl2 = d2 != d4;
        if (bl3 && bl2) {
            double d6 = (d + d3) / 2.0;
            return new FPath(d, d2, d6, d2, d6, d4, d3, d4).round(2.0);
        }
        if (bl3 || bl2) {
            return new FPath(d, d2, d3, d4);
        }
        return null;
    }

    public Point getPosition() {
        return this.designView.convertDiagramToScreen(new FPoint(this.currentX, this.currentY));
    }
}

