/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.patterns;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.layout.LayoutManager;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.elements.ContentElement;
import org.netbeans.modules.bpel.design.model.elements.PlaceHolderElement;
import org.netbeans.modules.bpel.design.model.elements.SubprocessBorder;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.CompensationHandler;
import org.netbeans.modules.bpel.model.api.CompensationHandlerHolder;
import org.netbeans.modules.bpel.model.api.EventHandlers;
import org.netbeans.modules.bpel.model.api.ExtendableActivity;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.TerminationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopePattern
extends CompositePattern {
    private PlaceHolderElement placeHolder;
    private VisualElement startEvent;
    private VisualElement endEvent;
    private VisualElement compensateBadge;
    private VisualElement eventsBadge;
    private VisualElement faultBadge;
    private VisualElement terminationBadge;
    private Connection startConnection = new Connection(this);
    private Connection endConnection = new Connection(this);
    private Connection eventsConnection;
    private Connection faultConnection;
    private Connection compConnection;
    private Connection terminationConnection;

    public ScopePattern(DiagramModel diagramModel) {
        super(diagramModel);
    }

    @Override
    public VisualElement getFirstElement() {
        return this.getBorder();
    }

    @Override
    public VisualElement getLastElement() {
        return this.getBorder();
    }

    public Pattern getActivityPattern() {
        ExtendableActivity extendableActivity = ((Scope)this.getOMReference()).getActivity();
        if (extendableActivity == null) {
            return null;
        }
        return this.getNestedPattern((BpelEntity)extendableActivity);
    }

    public Pattern getCompensationHandlerPattern() {
        CompensationHandler compensationHandler = ((CompensationHandlerHolder)this.getOMReference()).getCompensationHandler();
        return compensationHandler != null ? this.getNestedPattern((BpelEntity)compensationHandler) : null;
    }

    public Pattern getEventHandlersPattern() {
        EventHandlers eventHandlers = ((Scope)this.getOMReference()).getEventHandlers();
        return eventHandlers != null ? this.getNestedPattern((BpelEntity)eventHandlers) : null;
    }

    public Pattern getFaultHandlersPattern() {
        FaultHandlers faultHandlers = ((Scope)this.getOMReference()).getFaultHandlers();
        return faultHandlers != null ? this.getNestedPattern((BpelEntity)faultHandlers) : null;
    }

    public Pattern getTerminationHandlerPattern() {
        TerminationHandler terminationHandler = ((Scope)this.getOMReference()).getTerminationHandler();
        return terminationHandler != null ? this.getNestedPattern((BpelEntity)terminationHandler) : null;
    }

    @Override
    protected void createElementsImpl() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.setBorder(new SubprocessBorder());
        this.getBorder().setLabelText(this.getDefaultName());
        this.registerTextElement(this.getBorder());
        this.startEvent = ContentElement.createStartEvent();
        this.startEvent.setLabelText("");
        this.endEvent = ContentElement.createEndEvent();
        this.endEvent.setLabelText("");
        this.placeHolder = new PlaceHolderElement();
        this.compensateBadge = ContentElement.createCompensateBadge();
        this.eventsBadge = ContentElement.createEventBadge();
        this.faultBadge = ContentElement.createFaultBadge();
        this.terminationBadge = ContentElement.createTerminationBadge();
        this.appendElement(this.placeHolder);
        this.appendElement(this.startEvent);
        this.appendElement(this.endEvent);
        Scope scope = (Scope)this.getOMReference();
        Activity activity = (Activity)scope.getActivity();
        if (activity != null) {
            object4 = this.getModel().createPattern((BpelEntity)activity);
            ((Pattern)object4).setParent(this);
        }
        if ((object4 = scope.getCompensationHandler()) != null) {
            object3 = this.getModel().createPattern((BpelEntity)object4);
            ((Pattern)object3).setParent(this);
        }
        if ((object3 = scope.getEventHandlers()) != null) {
            object2 = this.getModel().createPattern((BpelEntity)object3);
            ((Pattern)object2).setParent(this);
        }
        if ((object2 = scope.getFaultHandlers()) != null) {
            object = this.getModel().createPattern((BpelEntity)object2);
            ((Pattern)object).setParent(this);
        }
        if ((object = scope.getTerminationHandler()) != null) {
            Pattern pattern = this.getModel().createPattern((BpelEntity)object);
            pattern.setParent(this);
        }
    }

    @Override
    public void onAppendPattern(Pattern pattern) {
        BpelEntity bpelEntity = pattern.getOMReference();
        if (bpelEntity instanceof CompensationHandler) {
            this.appendElement(this.compensateBadge);
        } else if (bpelEntity instanceof EventHandlers) {
            this.appendElement(this.eventsBadge);
        } else if (bpelEntity instanceof FaultHandlers) {
            this.appendElement(this.faultBadge);
        } else if (bpelEntity instanceof TerminationHandler) {
            this.appendElement(this.terminationBadge);
        } else {
            this.removeElement(this.placeHolder);
        }
    }

    @Override
    public void onRemovePattern(Pattern pattern) {
        Scope scope = (Scope)this.getOMReference();
        if (this.compensateBadge.hasPattern() && scope.getCompensationHandler() == null) {
            this.removeElement(this.compensateBadge);
        } else if (this.eventsBadge.hasPattern() && scope.getEventHandlers() == null) {
            this.removeElement(this.eventsBadge);
        } else if (this.faultBadge.hasPattern() && scope.getFaultHandlers() == null) {
            this.removeElement(this.faultBadge);
        } else if (this.terminationBadge.hasPattern() && scope.getTerminationHandler() == null) {
            this.removeElement(this.terminationBadge);
        } else {
            this.appendElement(this.placeHolder);
        }
    }

    @Override
    public FBounds layoutPattern(LayoutManager layoutManager) {
        FBounds fBounds;
        ArrayList<FBounds> arrayList = new ArrayList<FBounds>();
        Pattern pattern = this.getActivityPattern();
        if (pattern == null) {
            this.placeHolder.setCenter(0.0, 0.0);
            arrayList.add(this.placeHolder.getBounds());
        } else {
            FPoint fPoint = layoutManager.getOriginOffset(pattern);
            arrayList.add(layoutManager.setPatternPosition(pattern, -fPoint.x, 0.0));
        }
        double d = this.startEvent.getHeight();
        double d2 = this.endEvent.getHeight();
        FBounds fBounds2 = new FBounds(arrayList);
        this.startEvent.setCenter(0.0, (double)(fBounds2.y - 18.0f) - d / 2.0);
        arrayList.add(this.startEvent.getBounds());
        this.endEvent.setCenter(0.0, (double)(fBounds2.height + 18.0f) + d2 / 2.0);
        arrayList.add(this.endEvent.getBounds());
        this.getBorder().setClientRectangle(new FBounds(arrayList));
        FBounds fBounds3 = this.getBorder().getBounds();
        this.setOrigin(fBounds3.getCenter().x, 0.0);
        Pattern pattern2 = this.getEventHandlersPattern();
        Pattern pattern3 = this.getCompensationHandlerPattern();
        Pattern pattern4 = this.getTerminationHandlerPattern();
        Pattern pattern5 = this.getFaultHandlersPattern();
        int n = 0;
        if (pattern2 != null) {
            ++n;
        }
        if (pattern3 != null) {
            ++n;
        }
        if (pattern4 != null) {
            ++n;
        }
        if (pattern5 != null) {
            ++n;
        }
        double d3 = fBounds3.y + this.getBorder().getInsets().top + 8.0f;
        double d4 = fBounds3.x + fBounds3.width + 12.0f;
        double d5 = fBounds3.x - 12.0f;
        double d6 = d3 + (double)(18.0f * (float)n);
        double d7 = 0.0;
        int n2 = 1;
        if (pattern2 != null) {
            this.eventsBadge.setCenter(fBounds3.x + fBounds3.width, d3 + (double)((float)(n - n2) * 18.0f));
            layoutManager.setPatternPosition(pattern2, d4, d6);
            fBounds = pattern2.getBounds();
            d4 += (double)(fBounds.width + 12.0f);
            d7 = Math.max(d7, (double)fBounds.height);
            ++n2;
        }
        if (pattern3 != null) {
            this.compensateBadge.setCenter(fBounds3.x + fBounds3.width, d3 + (double)((float)(n - n2) * 18.0f));
            layoutManager.setPatternPosition(pattern3, d4, d6);
            fBounds = pattern3.getBounds();
            d4 += (double)(fBounds.width + 12.0f);
            d7 = Math.max(d7, (double)fBounds.height);
            ++n2;
        }
        if (pattern4 != null) {
            this.terminationBadge.setCenter(fBounds3.x + fBounds3.width, d3 + (double)((float)(n - n2) * 18.0f));
            layoutManager.setPatternPosition(pattern4, d4, d6);
            fBounds = pattern4.getBounds();
            d4 += (double)(fBounds.width + 12.0f);
            d7 = Math.max(d7, (double)fBounds.height);
            ++n2;
        }
        if (pattern5 != null) {
            this.faultBadge.setCenter(fBounds3.x + fBounds3.width, d3 + (double)((float)(n - n2) * 18.0f));
            layoutManager.setPatternPosition(pattern5, d4, d6);
            fBounds = pattern5.getBounds();
            d4 += (double)(fBounds.width + 12.0f);
            d7 = Math.max(d7, (double)fBounds.height);
        }
        return null;
    }

    @Override
    public void createPlaceholders(Pattern pattern, Collection<PlaceHolder> collection) {
        if (pattern == this) {
            return;
        }
        if (this.isNestedIn(pattern)) {
            return;
        }
        if (!(pattern.getOMReference() instanceof Activity)) {
            return;
        }
        if (this.placeHolder.getPattern() != null) {
            collection.add(new InnerPlaceHolder(pattern));
        }
    }

    @Override
    public String getDefaultName() {
        return "Scope";
    }

    @Override
    public void reconnectElements() {
        Pattern pattern = this.getActivityPattern();
        if (pattern != null) {
            this.startConnection.connect(this.startEvent, Direction.BOTTOM, pattern.getFirstElement(), Direction.TOP);
            this.endConnection.connect(pattern.getLastElement(), Direction.BOTTOM, this.endEvent, Direction.TOP);
        } else {
            this.startConnection.connect(this.startEvent, Direction.BOTTOM, this.placeHolder, Direction.TOP);
            this.endConnection.connect(this.placeHolder, Direction.BOTTOM, this.endEvent, Direction.TOP);
        }
        Pattern pattern2 = this.getCompensationHandlerPattern();
        if (pattern2 != null) {
            if (this.compConnection == null) {
                this.compConnection = new Connection(this);
            }
            this.compConnection.connect(this.compensateBadge, Direction.RIGHT, pattern2.getFirstElement(), Direction.TOP);
        } else if (this.compConnection != null) {
            this.compConnection.remove();
            this.compConnection = null;
        }
        Pattern pattern3 = this.getTerminationHandlerPattern();
        if (pattern3 != null) {
            if (this.terminationConnection == null) {
                this.terminationConnection = new Connection(this);
            }
            this.terminationConnection.connect(this.terminationBadge, Direction.RIGHT, pattern3.getFirstElement(), Direction.TOP);
        } else if (this.terminationConnection != null) {
            this.terminationConnection.remove();
            this.terminationConnection = null;
        }
        Pattern pattern4 = this.getEventHandlersPattern();
        if (pattern4 != null) {
            if (this.eventsConnection == null) {
                this.eventsConnection = new Connection(this);
            }
            this.eventsConnection.connect(this.eventsBadge, Direction.RIGHT, pattern4.getFirstElement(), Direction.TOP);
        } else if (this.eventsConnection != null) {
            this.eventsConnection.remove();
            this.eventsConnection = null;
        }
        Pattern pattern5 = this.getFaultHandlersPattern();
        if (pattern5 != null) {
            if (this.faultConnection == null) {
                this.faultConnection = new Connection(this);
            }
            this.faultConnection.connect(this.faultBadge, Direction.RIGHT, pattern5.getFirstElement(), Direction.TOP);
        } else if (this.faultConnection != null) {
            this.faultConnection.remove();
            this.faultConnection = null;
        }
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SCOPE;
    }

    @Override
    public Area createSelection() {
        Area area = new Area(this.getBorder().getShape());
        if (this.compensateBadge.getPattern() != null) {
            area.add(new Area(this.compensateBadge.getShape()));
        }
        if (this.eventsBadge.getPattern() != null) {
            area.add(new Area(this.eventsBadge.getShape()));
        }
        if (this.faultBadge.getPattern() != null) {
            area.add(new Area(this.faultBadge.getShape()));
        }
        if (this.terminationBadge.getPattern() != null) {
            area.add(new Area(this.terminationBadge.getShape()));
        }
        area.subtract(new Area(this.startEvent.getShape()));
        area.subtract(new Area(this.endEvent.getShape()));
        return area;
    }

    class InnerPlaceHolder
    extends PlaceHolder {
        public InnerPlaceHolder(Pattern pattern) {
            super((Pattern)ScopePattern.this, pattern, ScopePattern.this.placeHolder.getCenterX(), ScopePattern.this.placeHolder.getCenterY());
        }

        public void drop() {
            ((Scope)ScopePattern.this.getOMReference()).setActivity((ExtendableActivity)((Activity)this.getDraggedPattern().getOMReference()));
        }
    }
}

