/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.patterns;

import java.util.Collection;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.layout.LayoutManager;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.PartnerLinkHelper;
import org.netbeans.modules.bpel.design.model.PartnerRole;
import org.netbeans.modules.bpel.design.model.elements.InvokeOperationElement;
import org.netbeans.modules.bpel.design.model.elements.OperationElement;
import org.netbeans.modules.bpel.design.model.elements.ProcessBorder;
import org.netbeans.modules.bpel.design.model.elements.ReceiveOperationElement;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.nodes.synchronizer.ModelSynchronizer;
import org.netbeans.modules.bpel.nodes.synchronizer.SynchronisationListener;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerlinkPattern
extends CompositePattern
implements SynchronisationListener {
    private PartnerRole type;
    private ModelSynchronizer synchronizer;
    private boolean isCollapsed = false;

    public PartnerlinkPattern(DiagramModel diagramModel) {
        this(diagramModel, false);
    }

    public PartnerlinkPattern(DiagramModel diagramModel, boolean bl) {
        super(diagramModel);
        this.isCollapsed = bl;
        this.synchronizer = new ModelSynchronizer(this);
    }

    public PartnerRole getType() {
        if (this.type == null) {
            this.type = PartnerLinkHelper.getPartnerlinkRole((PartnerLink)this.getOMReference());
        }
        return this.type;
    }

    @Override
    public VisualElement getFirstElement() {
        return null;
    }

    @Override
    public VisualElement getLastElement() {
        return null;
    }

    @Override
    public boolean isDraggable() {
        return true;
    }

    @Override
    protected void onAppendPattern(Pattern pattern) {
    }

    @Override
    protected void onRemovePattern(Pattern pattern) {
    }

    @Override
    public DiagramView getView() {
        return this.getType() == PartnerRole.CONSUMER ? this.getModel().getView().getConsumersView() : this.getModel().getView().getProvidersView();
    }

    public Operation getOperation(VisualElement visualElement) {
        String string = visualElement.getText();
        PartnerLink partnerLink = (PartnerLink)this.getOMReference();
        if (partnerLink.getPartnerLinkType() == null) {
            return null;
        }
        PartnerLinkType partnerLinkType = (PartnerLinkType)partnerLink.getPartnerLinkType().get();
        if (partnerLinkType == null) {
            return null;
        }
        Operation operation = this.findOperationInRole(partnerLinkType.getRole1(), string);
        return operation != null ? operation : this.findOperationInRole(partnerLinkType.getRole2(), string);
    }

    public VisualElement getElement(WSDLReference<Operation> wSDLReference) {
        if (this.isCollapsed) {
            return this.getBorder();
        }
        String string = wSDLReference.getRefString();
        for (VisualElement visualElement : this.getElements()) {
            if (!string.equals(visualElement.getText())) continue;
            return visualElement;
        }
        return null;
    }

    @Override
    public void setParent(CompositePattern compositePattern) {
        super.setParent(compositePattern);
        if (compositePattern == null) {
            this.synchronizer.unsubscribe();
        }
    }

    @Override
    public FBounds layoutPattern(LayoutManager layoutManager) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (VisualElement visualElement : this.getElements()) {
            visualElement.setLocation(-visualElement.getWidth() / 2.0, d);
            d += visualElement.getHeight() + 18.0;
            d3 = Math.max(d3, visualElement.getWidth());
        }
        double d4 = d - 18.0;
        d3 = Math.max(d3, 40.0);
        d4 = Math.max(d4, 28.0);
        double d5 = -d3 / 2.0;
        this.getBorder().setClientRectangle(d5, d2, d3, d4);
        return this.getBorder().getBounds();
    }

    public void reloadOperations() {
        PartnerLinkType partnerLinkType;
        PartnerLink partnerLink = (PartnerLink)this.getOMReference();
        if (partnerLink == null) {
            return;
        }
        this.getBorder().setLabelText(partnerLink.getName());
        this.removeAllElements();
        if (partnerLink.getPartnerLinkType() == null) {
            return;
        }
        if (partnerLink.isInDocumentModel() && (partnerLinkType = (PartnerLinkType)partnerLink.getPartnerLinkType().get()) != null) {
            this.synchronizer.subscribe((Model)partnerLinkType.getModel());
            this.processPortType(partnerLinkType.getRole1(), (WSDLReference<Role>)partnerLink.getMyRole(), (WSDLReference<Role>)partnerLink.getPartnerRole());
            this.processPortType(partnerLinkType.getRole2(), (WSDLReference<Role>)partnerLink.getMyRole(), (WSDLReference<Role>)partnerLink.getPartnerRole());
        }
    }

    @Override
    protected void createElementsImpl() {
        PartnerLink partnerLink = (PartnerLink)this.getOMReference();
        this.setBorder(new ProcessBorder());
        if (!this.isCollapsed) {
            this.reloadOperations();
        }
        this.registerTextElement(this.getBorder());
    }

    private void processPortType(Role role, WSDLReference<Role> wSDLReference, WSDLReference<Role> wSDLReference2) {
        if (role == null) {
            return;
        }
        String string = role.getName();
        if (string == null) {
            return;
        }
        boolean bl = false;
        if (wSDLReference != null) {
            bl = wSDLReference.references((Referenceable)role);
        } else if (wSDLReference2 != null) {
            bl = !wSDLReference2.references((Referenceable)role);
        } else {
            return;
        }
        NamedComponentReference namedComponentReference = role.getPortType();
        if (namedComponentReference == null) {
            return;
        }
        PortType portType = (PortType)namedComponentReference.get();
        if (portType == null) {
            return;
        }
        for (Operation operation : portType.getOperations()) {
            OperationElement operationElement = bl ? new InvokeOperationElement() : new ReceiveOperationElement();
            operationElement.setLabelText(operation.getName());
            this.appendElement(operationElement);
        }
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.PARTNER_LINK;
    }

    private Operation findOperationInRole(Role role, String string) {
        if (role == null) {
            return null;
        }
        if (role.getPortType() == null) {
            return null;
        }
        PortType portType = (PortType)role.getPortType().get();
        Collection collection = portType.getOperations();
        for (Operation operation : collection) {
            if (!string.equals(operation.getName())) continue;
            return operation;
        }
        return null;
    }

    private void updatePartnerLinkType() {
        if (this.getModel().getView() == null || this.getParent() == null) {
            return;
        }
        try {
            this.reloadOperations();
            this.getModel().getView().diagramChanged();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(4096, (Throwable)exception);
        }
    }

    @Override
    public void componentUpdated(Component component) {
        this.updatePartnerLinkType();
    }

    @Override
    public void childrenUpdated(Component component) {
        this.updatePartnerLinkType();
    }
}

