/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.patterns;

import java.awt.geom.Area;
import java.util.Collection;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.layout.LayoutManager;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.PartnerLinkHelper;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.elements.ContentElement;
import org.netbeans.modules.bpel.design.model.elements.GroupBorder;
import org.netbeans.modules.bpel.design.model.elements.PlaceHolderElement;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ExtendableActivity;
import org.netbeans.modules.bpel.model.api.OnMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnMessagePattern
extends CompositePattern {
    private VisualElement messageEvent;
    private Connection connection;
    private PlaceHolderElement placeHolder;

    public OnMessagePattern(DiagramModel diagramModel) {
        super(diagramModel);
    }

    @Override
    public VisualElement getFirstElement() {
        return this.messageEvent;
    }

    @Override
    public VisualElement getLastElement() {
        if (this.getNestedPatterns().isEmpty()) {
            return this.placeHolder;
        }
        return this.getNestedPattern().getLastElement();
    }

    @Override
    protected void createElementsImpl() {
        this.setBorder(new GroupBorder());
        this.getBorder().setText(this.getDefaultName());
        this.messageEvent = ContentElement.createMessageEvent();
        this.messageEvent.setLabelText("Message");
        this.appendElement(this.messageEvent);
        this.placeHolder = new PlaceHolderElement();
        this.appendElement(this.placeHolder);
        ExtendableActivity extendableActivity = ((OnMessage)this.getOMReference()).getActivity();
        if (extendableActivity != null) {
            Pattern pattern = this.getModel().createPattern((BpelEntity)extendableActivity);
            pattern.setParent(this);
        }
    }

    @Override
    public FBounds layoutPattern(LayoutManager layoutManager) {
        double d;
        double d2 = this.messageEvent.getHeight() + 12.0;
        double d3 = this.messageEvent.getWidth();
        if (this.getNestedPatterns().isEmpty()) {
            d3 = Math.max(d3, this.placeHolder.getWidth());
            this.placeHolder.setCenter(0.0, (d2 += this.placeHolder.getHeight()) / 2.0 - this.placeHolder.getHeight() / 2.0);
            d = 0.0;
        } else {
            Pattern pattern = this.getNestedPattern();
            FBounds fBounds = pattern.getBounds();
            d = -fBounds.width / 2.0f + layoutManager.getOriginOffset((Pattern)pattern).x;
            d3 = Math.max(d3, (double)fBounds.width);
            layoutManager.setPatternPosition(pattern, -fBounds.width / 2.0f, (d2 += (double)fBounds.height) / 2.0 - (double)fBounds.height);
        }
        this.messageEvent.setCenter(d, -d2 / 2.0 + this.messageEvent.getHeight() / 2.0);
        this.getBorder().setClientRectangle(-d3 / 2.0, -d2 / 2.0, d3, d2);
        return this.getBorder().getBounds();
    }

    @Override
    public void createPlaceholders(Pattern pattern, Collection<PlaceHolder> collection) {
        if (!(pattern.getOMReference() instanceof Activity)) {
            return;
        }
        if (this.placeHolder.getPattern() != null) {
            collection.add(new InnerPlaceHolder(pattern));
        }
    }

    @Override
    public void onAppendPattern(Pattern pattern) {
        this.removeElement(this.placeHolder);
    }

    @Override
    protected void onRemovePattern(Pattern pattern) {
        this.appendElement(this.placeHolder);
    }

    @Override
    public String getDefaultName() {
        return "OnMessage";
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MESSAGE_HANDLER;
    }

    @Override
    public void reconnectElements() {
        if (this.connection == null) {
            this.connection = new Connection(this);
        }
        if (this.getNestedPatterns().isEmpty()) {
            this.connection.connect(this.messageEvent, Direction.BOTTOM, this.placeHolder, Direction.TOP);
        } else {
            this.connection.connect(this.messageEvent, Direction.BOTTOM, this.getNestedPattern().getFirstElement(), Direction.TOP);
        }
        this.clearConnectionsExcept(this.connection);
        new PartnerLinkHelper(this.getModel()).updateMessageFlowLinks(this);
    }

    @Override
    public Area createSelection() {
        Area area = new Area(this.getBorder().getShape());
        area.subtract(new Area(this.messageEvent.getShape()));
        return area;
    }

    class InnerPlaceHolder
    extends PlaceHolder {
        public InnerPlaceHolder(Pattern pattern) {
            super((Pattern)OnMessagePattern.this, pattern, OnMessagePattern.this.placeHolder.getCenterX(), OnMessagePattern.this.placeHolder.getCenterY());
        }

        public void drop() {
            Pattern pattern = this.getDraggedPattern();
            ((OnMessage)OnMessagePattern.this.getOMReference()).setActivity((ExtendableActivity)((Activity)pattern.getOMReference()));
        }
    }
}

