/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.patterns;

import java.awt.geom.Area;
import java.util.Collection;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.layout.LayoutManager;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.elements.ContentElement;
import org.netbeans.modules.bpel.design.model.elements.GroupBorder;
import org.netbeans.modules.bpel.design.model.elements.PlaceHolderElement;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.ExtendableActivity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElseIfPattern
extends CompositePattern {
    private VisualElement gateway;
    private PlaceHolderElement placeHolder;
    private Connection connection;

    public ElseIfPattern(DiagramModel diagramModel) {
        super(diagramModel);
    }

    @Override
    protected void onAppendPattern(Pattern pattern) {
        this.removeElement(this.placeHolder);
    }

    @Override
    protected void onRemovePattern(Pattern pattern) {
        this.appendElement(this.placeHolder);
    }

    @Override
    public VisualElement getFirstElement() {
        return this.gateway;
    }

    @Override
    public VisualElement getLastElement() {
        Pattern pattern = this.getNestedPattern();
        return pattern != null ? pattern.getLastElement() : this.placeHolder;
    }

    @Override
    public void reconnectElements() {
        Pattern pattern = this.getNestedPattern();
        VisualElement visualElement = pattern == null ? this.placeHolder : pattern.getFirstElement();
        this.connection.connect(this.gateway, Direction.BOTTOM, visualElement, Direction.TOP);
    }

    @Override
    public FBounds layoutPattern(LayoutManager layoutManager) {
        Pattern pattern = this.getNestedPattern();
        double d = -this.gateway.getWidth() / 2.0;
        double d2 = -this.gateway.getHeight() / 2.0;
        this.gateway.setLocation(d, d2);
        double d3 = d + this.gateway.getHeight() + 18.0;
        double d4 = this.gateway.getWidth() / 2.0;
        if (pattern != null) {
            FBounds fBounds = pattern.getBounds();
            FPoint fPoint = layoutManager.getOriginOffset(pattern);
            layoutManager.setPatternPosition(pattern, -fPoint.x, d3);
            d3 += (double)fBounds.height;
            d = Math.min(d, (double)(-fPoint.x));
            d4 = Math.max(d4, (double)(fBounds.width - fPoint.x));
        } else {
            double d5 = this.placeHolder.getWidth();
            double d6 = this.placeHolder.getHeight();
            this.placeHolder.setLocation(-d5 / 2.0, d3);
            d3 += d6;
            d = Math.min(d, -d5 / 2.0);
            d4 = Math.max(d4, d5 / 2.0);
        }
        this.getBorder().setClientRectangle(d, d2, d4 - d, d3 - d2);
        return this.getBorder().getBounds();
    }

    @Override
    public Area createSelection() {
        Area area = new Area(this.getBorder().getShape());
        area.subtract(new Area(this.gateway.getShape()));
        return area;
    }

    @Override
    protected void createElementsImpl() {
        this.setBorder(new GroupBorder());
        this.getBorder().setText(this.getDefaultName());
        this.gateway = ContentElement.createElseIfGateway();
        this.placeHolder = new PlaceHolderElement();
        this.appendElement(this.gateway);
        this.appendElement(this.placeHolder);
        this.connection = new Connection(this);
        ExtendableActivity extendableActivity = ((ElseIf)this.getOMReference()).getActivity();
        if (extendableActivity != null) {
            this.getModel().createPattern((BpelEntity)extendableActivity).setParent(this);
        }
    }

    @Override
    public String getDefaultName() {
        return "ElseIf";
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ELSE_IF;
    }

    @Override
    public boolean isCollapsable() {
        return true;
    }

    @Override
    public void createPlaceholders(Pattern pattern, Collection<PlaceHolder> collection) {
        if (!(pattern.getOMReference() instanceof Activity)) {
            return;
        }
        if (((ElseIf)this.getOMReference()).getActivity() != null) {
            return;
        }
        collection.add(new InnerPlaceHolder(pattern));
    }

    class InnerPlaceHolder
    extends PlaceHolder {
        public InnerPlaceHolder(Pattern pattern) {
            super((Pattern)ElseIfPattern.this, pattern, ElseIfPattern.this.placeHolder.getCenterX(), ElseIfPattern.this.placeHolder.getCenterY());
        }

        public void drop() {
            ((ElseIf)ElseIfPattern.this.getOMReference()).setActivity((ExtendableActivity)((Activity)this.getDraggedPattern().getOMReference()));
        }
    }
}

