/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.geometry;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Triangle
implements Shape {
    private double[] coords = new double[8];
    private double minX = Double.NaN;
    private double minY = 0.0;
    private double maxX = 0.0;
    private double maxY = 0.0;

    public Triangle(double d, double d2, double d3, double d4, double d5, double d6) {
        this.coords[0] = d;
        this.coords[1] = d2;
        this.coords[2] = d3;
        this.coords[3] = d4;
        this.coords[4] = d5;
        this.coords[5] = d6;
        this.coords[6] = d;
        this.coords[7] = d2;
    }

    private final void calculateBounds() {
        if (this.minX != this.minX) {
            this.maxX = this.minX = this.coords[0];
            this.maxY = this.minY = this.coords[1];
            for (int i = 2; i < 6; i += 2) {
                double d = this.coords[i];
                double d2 = this.coords[i + 1];
                if (d < this.minX) {
                    this.minX = d;
                }
                if (d2 < this.minY) {
                    this.minY = d2;
                }
                if (this.maxX < d) {
                    this.maxX = d;
                }
                if (!(this.maxY < d2)) continue;
                this.maxY = d2;
            }
        }
    }

    public Rectangle getBounds() {
        this.calculateBounds();
        int n = (int)Math.floor(this.minX);
        int n2 = (int)Math.floor(this.minY);
        return new Rectangle(n, n2, (int)Math.ceil(this.maxX) - n, (int)Math.ceil(this.maxY) - n2);
    }

    public Rectangle2D getBounds2D() {
        this.calculateBounds();
        return new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    public boolean contains(double d, double d2) {
        this.calculateBounds();
        if (d < this.minX || this.maxX < d) {
            return false;
        }
        if (d2 < this.minY || this.maxY < d2) {
            return false;
        }
        double d3 = this.coords[0];
        double d4 = this.coords[1];
        d -= d3;
        d2 -= d4;
        double d5 = this.coords[2] - d3;
        double d6 = this.coords[3] - d4;
        double d7 = this.coords[4] - d3;
        double d8 = this.coords[5] - d4;
        double d9 = d5 * d5 + d6 * d6;
        double d10 = d7 * d7 + d6 * d8;
        double d11 = d7 * d5 + d8 * d6;
        double d12 = d * d5 + d2 * d6;
        double d13 = d * d7 + d2 * d8;
        double d14 = d9 * d10 - d11 * d11;
        double d15 = -(d11 * d13 - d10 * d12) / d14;
        double d16 = (d9 * d13 - d11 * d12) / d14;
        double d17 = d15 + d16;
        return 0.0 <= d15 && d15 <= 1.0 && 0.0 <= d16 && d16 <= 1.0 && d17 <= 1.0;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        this.calculateBounds();
        double d5 = Math.min(d, d + d3);
        double d6 = Math.min(d2, d2 + d4);
        double d7 = d5 + Math.abs(d3);
        double d8 = d6 + Math.abs(d4);
        return Math.max(d5, this.minX) <= Math.min(d7, this.maxX) && Math.max(d6, this.minY) <= Math.min(d8, this.maxY);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) && this.contains(d + d3, d2) && this.contains(d2, d2 + d4) && this.contains(d + d3, d2 + d4);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new TrianglePathIterator(affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new TrianglePathIterator(affineTransform);
    }

    private class TrianglePathIterator
    implements PathIterator {
        private int index = 0;
        private AffineTransform at;

        public TrianglePathIterator(AffineTransform affineTransform) {
            this.at = affineTransform;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.index > 8;
        }

        public void next() {
            this.index += 2;
        }

        public int currentSegment(float[] fArray) {
            if (this.index >= 8) {
                return 4;
            }
            fArray[0] = (float)Triangle.this.coords[this.index];
            fArray[1] = (float)Triangle.this.coords[this.index + 1];
            if (this.at != null) {
                this.at.transform(fArray, 0, fArray, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        public int currentSegment(double[] dArray) {
            if (this.index >= 8) {
                return 4;
            }
            dArray[0] = Triangle.this.coords[this.index];
            dArray[1] = Triangle.this.coords[this.index + 1];
            if (this.at != null) {
                this.at.transform(dArray, 0, dArray, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

