/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.netbeans.modules.bpel.design.geometry.FIntersector;
import org.netbeans.modules.bpel.design.geometry.FShape;

public class FRectangle
extends FShape {
    public final float radius;
    private static final double V = 1.0 - 4.0 * (Math.sqrt(2.0) - 1.0) / 3.0;
    private static final int[] TYPE = new int[]{0, 1, 3, 1, 3, 1, 3, 1, 3};
    private static final double[][] K = new double[][]{{0.0, 0.0, 1.0, 0.0}, {1.0, 0.0, -1.0, 0.0}, {1.0, 0.0, -V, 0.0, 1.0, 0.0, 0.0, V, 1.0, 0.0, 0.0, 1.0}, {1.0, 1.0, 0.0, -1.0}, {1.0, 1.0, 0.0, -V, 1.0, 1.0, -V, 0.0, 1.0, 1.0, -1.0, 0.0}, {0.0, 1.0, 1.0, 0.0}, {0.0, 1.0, V, 0.0, 0.0, 1.0, 0.0, -V, 0.0, 1.0, 0.0, -1.0}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, V, 0.0, 0.0, V, 0.0, 0.0, 0.0, 1.0, 0.0}};

    public FRectangle(double d, double d2) {
        this(0.0, 0.0, d, d2, 0.0);
    }

    public FRectangle(double d, double d2, double d3) {
        this(0.0, 0.0, d, d2, d3);
    }

    public FRectangle(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, 0.0);
    }

    public FRectangle(double d, double d2, double d3, double d4, double d5) {
        super(d, d2, d3, d4);
        this.radius = (float)d5;
    }

    public FRectangle enlarge(double d) {
        double d2 = d * 2.0;
        return new FRectangle((double)this.x - d, (double)this.y - d, (double)this.width + d2, (double)this.height + d2, (double)this.radius + d);
    }

    public FRectangle reshape(double d, double d2, double d3, double d4) {
        return new FRectangle((float)d, (float)d2, (float)d3, (float)d4, this.radius);
    }

    public double getRadius() {
        double d = this.radius;
        if (d < 0.0) {
            return 0.0;
        }
        double d2 = (double)this.height / 2.0;
        double d3 = (double)this.width / 2.0;
        return d2 < d3 ? (d < d2 ? d : d2) : (d < d3 ? d : d3);
    }

    public FRectangle radius(double d) {
        return new FRectangle(this.x, this.y, this.width, this.height, d);
    }

    public boolean intersect(FIntersector fIntersector) {
        fIntersector.intersectByRoundRectangle(this.x, this.y, this.width, this.height, this.radius);
        return fIntersector.ok();
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        if (this.width == 0.0f) {
            return this.height == 0.0f ? new FShape.EmptyPathIterator(this) : new FShape.LinePathIterator(this, affineTransform);
        }
        if (this.height == 0.0f) {
            return new FShape.LinePathIterator(this, affineTransform);
        }
        if (this.getRadius() == 0.0) {
            return new RectanglePathIterator(affineTransform);
        }
        return new RoundRectanglePathItarator(affineTransform);
    }

    public boolean contains(double d, double d2) {
        if (!super.contains(d, d2)) {
            return false;
        }
        double d3 = this.getRadius();
        if (d3 == 0.0) {
            return true;
        }
        double d4 = d3 * d3;
        double d5 = (double)this.x + d3 - d;
        double d6 = (double)(this.x + this.width) - d3 - d;
        double d7 = (double)this.y + d3 - d2;
        double d8 = (double)(this.y + this.height) - d3 - d2;
        if (d5 <= 0.0 && 0.0 <= d6) {
            return true;
        }
        if (d7 <= 0.0 && 0.0 <= d8) {
            return true;
        }
        double d9 = d5 * d5;
        double d10 = d7 * d7;
        double d11 = d6 * d6;
        double d12 = d8 * d8;
        if (d9 + d10 <= d4) {
            return true;
        }
        if (d9 + d12 <= d4) {
            return true;
        }
        if (d11 + d10 <= d4) {
            return true;
        }
        return d11 + d12 <= d4;
    }

    private class RectanglePathIterator
    implements PathIterator {
        private AffineTransform at;
        private int index = 0;

        public RectanglePathIterator(AffineTransform affineTransform) {
            this.at = affineTransform;
        }

        public int currentSegment(double[] dArray) {
            int n;
            if (this.index == 0) {
                dArray[0] = FRectangle.this.x;
                dArray[1] = FRectangle.this.y;
                n = 0;
            } else if (this.index == 1) {
                dArray[0] = FRectangle.this.x + FRectangle.this.width;
                dArray[1] = FRectangle.this.y;
                n = 1;
            } else if (this.index == 2) {
                dArray[0] = FRectangle.this.x + FRectangle.this.width;
                dArray[1] = FRectangle.this.y + FRectangle.this.height;
                n = 1;
            } else if (this.index == 3) {
                dArray[0] = FRectangle.this.x;
                dArray[1] = FRectangle.this.y + FRectangle.this.height;
                n = 1;
            } else if (this.index == 4) {
                dArray[0] = FRectangle.this.x;
                dArray[1] = FRectangle.this.y;
                n = 1;
            } else {
                return 4;
            }
            if (this.at != null) {
                this.at.transform(dArray, 0, dArray, 0, 1);
            }
            return n;
        }

        public int currentSegment(float[] fArray) {
            int n;
            if (this.index == 0) {
                fArray[0] = FRectangle.this.x;
                fArray[1] = FRectangle.this.y;
                n = 0;
            } else if (this.index == 1) {
                fArray[0] = FRectangle.this.x + FRectangle.this.width;
                fArray[1] = FRectangle.this.y;
                n = 1;
            } else if (this.index == 2) {
                fArray[0] = FRectangle.this.x + FRectangle.this.width;
                fArray[1] = FRectangle.this.y + FRectangle.this.height;
                n = 1;
            } else if (this.index == 3) {
                fArray[0] = FRectangle.this.x;
                fArray[1] = FRectangle.this.y + FRectangle.this.height;
                n = 1;
            } else if (this.index == 4) {
                fArray[0] = FRectangle.this.x;
                fArray[1] = FRectangle.this.y;
                n = 1;
            } else {
                return 4;
            }
            if (this.at != null) {
                this.at.transform(fArray, 0, fArray, 0, 1);
            }
            return n;
        }

        public boolean isDone() {
            return this.index >= 6;
        }

        public int getWindingRule() {
            return 1;
        }

        public void next() {
            ++this.index;
        }
    }

    private class RoundRectanglePathItarator
    implements PathIterator {
        private AffineTransform at;
        private int index = 0;
        private float radius;
        private boolean skipHorizontalLines;
        private boolean skipVerticalLines;

        public RoundRectanglePathItarator(AffineTransform affineTransform) {
            double d = FRectangle.this.getRadius();
            this.radius = (float)d;
            this.at = affineTransform;
            this.skipHorizontalLines = d >= (double)FRectangle.this.width / 2.0;
            this.skipVerticalLines = d >= (double)FRectangle.this.height / 2.0;
        }

        public int currentSegment(double[] dArray) {
            if (this.index >= TYPE.length) {
                return 4;
            }
            int n = TYPE[this.index];
            double[] dArray2 = K[this.index];
            dArray[0] = (double)FRectangle.this.x + dArray2[0] * (double)FRectangle.this.width + dArray2[2] * (double)this.radius;
            dArray[1] = (double)FRectangle.this.y + dArray2[1] * (double)FRectangle.this.height + dArray2[3] * (double)this.radius;
            if (n == 3) {
                dArray[2] = (double)FRectangle.this.x + dArray2[4] * (double)FRectangle.this.width + dArray2[6] * (double)this.radius;
                dArray[3] = (double)FRectangle.this.y + dArray2[5] * (double)FRectangle.this.height + dArray2[7] * (double)this.radius;
                dArray[4] = (double)FRectangle.this.x + dArray2[8] * (double)FRectangle.this.width + dArray2[10] * (double)this.radius;
                dArray[5] = (double)FRectangle.this.y + dArray2[9] * (double)FRectangle.this.height + dArray2[11] * (double)this.radius;
                if (this.at != null) {
                    this.at.transform(dArray, 0, dArray, 0, 3);
                }
            } else if (this.at != null) {
                this.at.transform(dArray, 0, dArray, 0, 1);
            }
            return n;
        }

        public int currentSegment(float[] fArray) {
            if (this.index >= TYPE.length) {
                return 4;
            }
            int n = TYPE[this.index];
            double[] dArray = K[this.index];
            fArray[0] = (float)((double)FRectangle.this.x + dArray[0] * (double)FRectangle.this.width + dArray[2] * (double)this.radius);
            fArray[1] = (float)((double)FRectangle.this.y + dArray[1] * (double)FRectangle.this.height + dArray[3] * (double)this.radius);
            if (n == 3) {
                fArray[2] = (float)((double)FRectangle.this.x + dArray[4] * (double)FRectangle.this.width + dArray[6] * (double)this.radius);
                fArray[3] = (float)((double)FRectangle.this.y + dArray[5] * (double)FRectangle.this.height + dArray[7] * (double)this.radius);
                fArray[4] = (float)((double)FRectangle.this.x + dArray[8] * (double)FRectangle.this.width + dArray[10] * (double)this.radius);
                fArray[5] = (float)((double)FRectangle.this.y + dArray[9] * (double)FRectangle.this.height + dArray[11] * (double)this.radius);
                if (this.at != null) {
                    this.at.transform(fArray, 0, fArray, 0, 3);
                }
            } else if (this.at != null) {
                this.at.transform(fArray, 0, fArray, 0, 1);
            }
            return n;
        }

        public void next() {
            if (this.index == 0 || this.index == 4) {
                this.index = this.skipHorizontalLines ? (this.index += 2) : ++this.index;
                return;
            }
            if (this.index == 2 || this.index == 6) {
                this.index = this.skipVerticalLines ? (this.index += 2) : ++this.index;
                return;
            }
            ++this.index;
        }

        public boolean isDone() {
            return this.index > TYPE.length;
        }

        public int getWindingRule() {
            return 1;
        }
    }
}

