/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.geometry;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.netbeans.modules.bpel.design.geometry.FCoords;
import org.netbeans.modules.bpel.design.geometry.FIntersector;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.geometry.FShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FPath
implements Shape {
    private FPoint[] points;
    private int[] types;
    private int pointOffset;
    private int pointCount;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private static final int MAX_GROW = 10;
    private static final int INITIAL_SIZE = 10;

    public FPath(double d, double d2, double d3, double d4) {
        this.points = new FPoint[]{new FPoint(d, d2), new FPoint(d3, d4)};
        this.types = new int[]{0, 1};
        this.pointOffset = 0;
        this.pointCount = 2;
        this.ok();
    }

    public FPath(double d, double d2, double d3, double d4, double d5, double d6) {
        this.points = new FPoint[]{new FPoint(d, d2), new FPoint(d3, d4), new FPoint(d5, d6)};
        this.types = new int[]{0, 1, 1};
        this.pointOffset = 0;
        this.pointCount = 3;
        this.ok();
    }

    public FPath(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.points = new FPoint[]{new FPoint(d, d2), new FPoint(d3, d4), new FPoint(d5, d6), new FPoint(d7, d8)};
        this.types = new int[]{0, 1, 1, 1};
        this.pointOffset = 0;
        this.pointCount = 4;
        this.ok();
    }

    private FPath() {
        this.points = new FPoint[10];
        this.types = new int[10];
        this.pointOffset = 0;
        this.pointCount = 0;
    }

    public FPath(Collection<FPoint> collection) {
        this.pointOffset = 0;
        this.pointCount = collection.size();
        this.points = collection.toArray(new FPoint[this.pointCount]);
        this.types = new int[this.pointCount];
        if (this.pointCount > 0) {
            this.types[0] = 0;
            for (int i = this.pointCount - 1; i >= 1; --i) {
                this.types[i] = 1;
            }
        }
    }

    public FPath(FPoint[] fPointArray) {
        this.pointOffset = 0;
        this.pointCount = fPointArray.length;
        this.points = new FPoint[this.pointCount];
        this.types = new int[this.pointCount];
        if (this.pointCount > 0) {
            System.arraycopy(fPointArray, 0, this.points, 0, this.pointCount);
            this.types[0] = 0;
            for (int i = this.pointCount - 1; i >= 1; --i) {
                this.types[i] = 1;
            }
        }
    }

    private FPath(FPoint[] fPointArray, int[] nArray, int n, int n2) {
        this.types = nArray;
        this.points = fPointArray;
        this.pointOffset = n;
        this.pointCount = n2;
        this.ok();
    }

    public FPath translate(double d, double d2) {
        if ((float)d == 0.0f && (float)d2 == 0.0f) {
            return this;
        }
        FPoint[] fPointArray = new FPoint[this.pointCount];
        int[] nArray = new int[this.pointCount];
        for (int i = 0; i < this.pointCount; ++i) {
            int n = this.pointOffset + i;
            fPointArray[i] = this.points[n].translate(d, d2);
            nArray[i] = this.types[n];
        }
        return new FPath(fPointArray, nArray, 0, this.pointCount);
    }

    public FPath move(double d, double d2) {
        if (this.pointCount == 0) {
            return this;
        }
        FPoint fPoint = this.points[this.pointOffset];
        return this.translate(d - (double)fPoint.x, d2 - (double)fPoint.y);
    }

    public FPath subtract(FShape fShape) {
        if (this.pointCount == 0) {
            return this;
        }
        int n = this.pointOffset;
        int n2 = n + this.pointCount;
        FIntersector fIntersector = null;
        FPoint fPoint = this.points[n];
        int n3 = this.types[n];
        boolean bl = fShape.contains(fPoint);
        FPath fPath = new FPath();
        for (int i = n + 1; i < n2; ++i) {
            FPoint fPoint2 = this.points[i];
            int n4 = this.types[i];
            boolean bl2 = fShape.contains(fPoint2);
            if (n4 == 0) {
                fPath.addSpace(fPoint, fPoint2);
            } else if (bl && bl2) {
                fPath.addSpace(fPoint, fPoint2);
            } else {
                if (fIntersector == null) {
                    fIntersector = new FIntersector();
                }
                fIntersector.setLine(fPoint, fPoint2);
                if (fShape.intersect(fIntersector)) {
                    FPoint fPoint3 = fPoint.point(fIntersector.getT1(), fPoint2);
                    FPoint fPoint4 = fPoint.point(fIntersector.getT2(), fPoint2);
                    if (!fPoint3.equals(fPoint)) {
                        fPath.addLine(fPoint, fPoint3);
                    }
                    fPath.addSpace(fPoint3, fPoint4);
                    if (!fPoint4.equals(fPoint2)) {
                        fPath.addLine(fPoint4, fPoint2);
                    }
                } else {
                    fPath.addLine(fPoint, fPoint2);
                }
            }
            bl = bl2;
            n3 = n4;
            fPoint = fPoint2;
        }
        fPath.ok();
        return fPath;
    }

    public FPath intersect(FShape fShape) {
        if (this.pointCount == 0) {
            return this;
        }
        int n = this.pointOffset;
        int n2 = n + this.pointCount;
        FIntersector fIntersector = null;
        FPoint fPoint = this.points[n];
        int n3 = this.types[n];
        boolean bl = fShape.contains(fPoint);
        FPath fPath = new FPath();
        for (int i = n + 1; i < n2; ++i) {
            FPoint fPoint2 = this.points[i];
            int n4 = this.types[i];
            boolean bl2 = fShape.contains(fPoint2);
            if (n4 == 0) {
                fPath.addSpace(fPoint, fPoint2);
            } else if (bl && bl2) {
                fPath.addLine(fPoint, fPoint2);
            } else {
                if (fIntersector == null) {
                    fIntersector = new FIntersector();
                }
                fIntersector.setLine(fPoint, fPoint2);
                if (fShape.intersect(fIntersector)) {
                    FPoint fPoint3 = fPoint.point(fIntersector.getT1(), fPoint2);
                    FPoint fPoint4 = fPoint.point(fIntersector.getT2(), fPoint2);
                    if (!fPoint3.equals(fPoint)) {
                        fPath.addSpace(fPoint, fPoint3);
                    }
                    fPath.addLine(fPoint3, fPoint4);
                    if (!fPoint4.equals(fPoint2)) {
                        fPath.addSpace(fPoint4, fPoint2);
                    }
                } else {
                    fPath.addSpace(fPoint, fPoint2);
                }
            }
            bl = bl2;
            n3 = n4;
            fPoint = fPoint2;
        }
        fPath.ok();
        return fPath;
    }

    public FPath round(double d) {
        if (d <= 0.0) {
            return this;
        }
        if (this.pointCount <= 2) {
            return this;
        }
        FPath fPath = new FPath();
        int n = this.pointOffset;
        int n2 = n + this.pointCount;
        FPoint fPoint = this.points[n];
        for (int i = n + 1; i < n2; ++i) {
            FPoint fPoint2 = this.points[i];
            int n3 = this.types[i];
            if (n3 == 0) {
                fPath.addSpace(fPoint, fPoint2);
                fPoint = fPoint2;
                continue;
            }
            if (i + 1 == n2) {
                fPath.addLine(fPoint, fPoint2);
                fPoint = fPoint2;
                continue;
            }
            int n4 = this.types[i + 1];
            if (n4 == 0) {
                fPath.addLine(fPoint, fPoint2);
                fPoint = fPoint2;
                continue;
            }
            FPoint fPoint3 = this.points[i - 1];
            FPoint fPoint4 = this.points[i + 1];
            double d2 = fPoint3.distance(fPoint2);
            double d3 = fPoint2.distance(fPoint4);
            if ((float)d2 != 0.0f && (float)d3 != 0.0f) {
                double d4;
                double d5 = (d2 - d) / d2;
                if (d5 < 0.5) {
                    d5 = 0.5;
                }
                if ((d4 = d / d3) > 0.5) {
                    d4 = 0.5;
                }
                FPoint fPoint5 = fPoint3.point(d5, fPoint2);
                FPoint fPoint6 = fPoint2.point(d4, fPoint4);
                fPath.addLine(fPoint, fPoint5);
                fPath.addLine(fPoint5, fPoint6);
                fPoint = fPoint6;
                continue;
            }
            fPath.addLine(fPoint, fPoint2);
            fPoint = fPoint2;
        }
        fPath.ok();
        return fPath;
    }

    private void addSpace(FPoint fPoint, FPoint fPoint2) {
        if (this.pointCount == 0) {
            this.ensureCapacity(1);
            this.points[0] = fPoint2;
            this.types[0] = 0;
            this.pointCount = 1;
        } else if (this.types[this.pointCount - 1] == 0) {
            this.points[this.pointCount - 1] = fPoint2;
        } else {
            this.ensureCapacity(this.pointCount + 1);
            this.points[this.pointCount] = fPoint2;
            this.types[this.pointCount] = 0;
            ++this.pointCount;
        }
    }

    private void addLine(FPoint fPoint, FPoint fPoint2) {
        if (fPoint.equals(fPoint2)) {
            return;
        }
        if (this.pointCount == 0) {
            this.ensureCapacity(2);
            this.points[0] = fPoint;
            this.points[1] = fPoint2;
            this.types[0] = 0;
            this.types[1] = 1;
            this.pointCount = 2;
        } else {
            this.ensureCapacity(this.pointCount + 1);
            this.points[this.pointCount] = fPoint2;
            this.types[this.pointCount] = 1;
            ++this.pointCount;
        }
    }

    private void ensureCapacity(int n) {
        if (n > this.points.length) {
            int n2 = this.points.length * 3 / 2 + 1;
            int n3 = this.points.length + 10;
            if (n2 > n3) {
                n2 = n3;
            }
            if (n2 < n) {
                n2 = n;
            }
            FPoint[] fPointArray = new FPoint[n2];
            int[] nArray = new int[n2];
            System.arraycopy(this.points, 0, fPointArray, 0, this.pointCount);
            System.arraycopy(this.types, 0, nArray, 0, this.pointCount);
            this.points = fPointArray;
            this.types = nArray;
        }
    }

    private void ok() {
        int n;
        int n2 = this.pointOffset;
        for (int i = n = n2 + this.pointCount - 1; i >= n2 && this.types[i] != 1; --i) {
            this.points[i] = null;
            --this.pointCount;
        }
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.NEGATIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        n = n2 + this.pointCount;
        for (int i = n2; i < n; ++i) {
            FPoint fPoint = this.points[i];
            if (fPoint.x < f) {
                f = fPoint.x;
            }
            if (fPoint.x > f3) {
                f3 = fPoint.x;
            }
            if (fPoint.y < f2) {
                f2 = fPoint.y;
            }
            if (!(fPoint.y > f4)) continue;
            f4 = fPoint.y;
        }
        this.minX = f;
        this.minY = f2;
        this.maxX = f3;
        this.maxY = f4;
    }

    public boolean isConnected() {
        if (this.pointCount == 0) {
            return true;
        }
        for (int i = 2; i < this.pointCount; ++i) {
            if (this.types[i] != 0) continue;
            return false;
        }
        return true;
    }

    public double length() {
        if (this.pointCount == 0) {
            return 0.0;
        }
        double d = 0.0;
        int n = this.pointOffset;
        int n2 = n + this.pointCount;
        FPoint fPoint = this.points[n];
        for (int i = n + 1; i < n2; ++i) {
            FPoint fPoint2 = this.points[i];
            if (!fPoint.equals(fPoint2) && this.types[i] == 1) {
                d += fPoint.distance(fPoint2);
            }
            fPoint = fPoint2;
        }
        return d;
    }

    public FCoords coords(double d) {
        d = this.parameterToLength(d);
        int n = this.pointOffset;
        int n2 = n + this.pointCount;
        double d2 = 0.0;
        FPoint fPoint = this.points[n];
        for (int i = n + 1; i < n2; ++i) {
            FPoint fPoint2 = this.points[i];
            if (!fPoint.equals(fPoint2) && this.types[i] == 1) {
                double d3 = fPoint.distance(fPoint2);
                double d4 = d2 + d3;
                if (d2 <= d && d <= d4) {
                    double d5;
                    double d6;
                    d = (d - d2) / d3;
                    double d7 = fPoint2.x - fPoint.x;
                    double d8 = fPoint2.y - fPoint.y;
                    if (d < 0.0) {
                        d6 = fPoint.x;
                        d5 = fPoint.y;
                    } else if (d > 1.0) {
                        d6 = fPoint2.x;
                        d5 = fPoint2.y;
                    } else {
                        d6 = (double)fPoint.x + d * d7;
                        d5 = (double)fPoint.y + d * d8;
                    }
                    return new FCoords(d6, d5, d7 / d3, d8 / d3);
                }
                d2 = d4;
            }
            fPoint = fPoint2;
        }
        return new FCoords(fPoint.x, fPoint.y);
    }

    public FPoint point(double d) {
        d = this.parameterToLength(d);
        int n = this.pointOffset;
        int n2 = n + this.pointCount;
        FPoint fPoint = this.points[n];
        for (int i = n + 1; i < n2; ++i) {
            FPoint fPoint2 = this.points[i];
            if (!fPoint.equals(fPoint2) && this.types[i] == 1) {
                double d2 = fPoint.distance(fPoint2);
                if (d <= d2) {
                    return d == 0.0 ? fPoint : fPoint.point(d / d2, fPoint2);
                }
                d -= d2;
            }
            fPoint = fPoint2;
        }
        return fPoint;
    }

    public FPoint tangent(double d) {
        d = this.parameterToLength(d);
        int n = this.pointOffset;
        int n2 = n + this.pointCount;
        double d2 = 0.0;
        FPoint fPoint = this.points[n];
        for (int i = n + 1; i < n2; ++i) {
            FPoint fPoint2 = this.points[i];
            if (!fPoint.equals(fPoint2) && this.types[i] == 1) {
                double d3 = fPoint.distance(fPoint2);
                double d4 = d2 + d3;
                if (d2 <= d && d <= d4) {
                    return new FPoint((double)(fPoint2.x - fPoint.x) / d3, (double)(fPoint2.y - fPoint.y) / d3);
                }
                d2 = d4;
            }
            fPoint = fPoint2;
        }
        return new FPoint(0.0, 0.0);
    }

    public FPoint normal(double d) {
        return this.tangent(d).rotate90();
    }

    private double parameterToLength(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return this.length();
        }
        return d * this.length();
    }

    @Override
    public boolean contains(Point2D point2D) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return false;
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return false;
    }

    @Override
    public boolean contains(double d, double d2) {
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new PathPathIterator(affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.pointCount == 0) {
            return false;
        }
        if (d3 < 0.0) {
            d += d3;
            d3 = -d3;
        }
        if (d4 < 0.0) {
            d2 += d4;
            d4 = -d4;
        }
        if ((double)this.maxX < d) {
            return false;
        }
        if ((double)this.maxY < d2) {
            return false;
        }
        if (d + d3 < (double)this.minX) {
            return false;
        }
        return !(d2 + d4 < (double)this.minY);
    }

    @Override
    public Rectangle2D getBounds2D() {
        if (this.pointCount == 0) {
            return new Rectangle2D.Float();
        }
        return new Rectangle2D.Float(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    @Override
    public Rectangle getBounds() {
        if (this.pointCount == 0) {
            return new Rectangle();
        }
        int n = (int)Math.floor(this.minX);
        int n2 = (int)Math.floor(this.minY);
        return new Rectangle(n, n2, (int)Math.ceil(this.maxX) - n, (int)Math.ceil(this.maxY) - n2);
    }

    private class PathPathIterator
    implements PathIterator {
        private int index = 0;
        private AffineTransform at;

        public PathPathIterator(AffineTransform affineTransform) {
            this.at = affineTransform;
        }

        public int currentSegment(double[] dArray) {
            FPoint fPoint = FPath.this.points[this.index];
            dArray[0] = fPoint.x;
            dArray[1] = fPoint.y;
            if (this.at != null) {
                this.at.transform(dArray, 0, dArray, 0, 1);
            }
            return FPath.this.types[this.index];
        }

        public int currentSegment(float[] fArray) {
            FPoint fPoint = FPath.this.points[this.index];
            fArray[0] = fPoint.x;
            fArray[1] = fPoint.y;
            if (this.at != null) {
                this.at.transform(fArray, 0, fArray, 0, 1);
            }
            return FPath.this.types[this.index];
        }

        public void next() {
            ++this.index;
        }

        public boolean isDone() {
            return this.index >= FPath.this.pointCount;
        }

        public int getWindingRule() {
            return 1;
        }
    }
}

