/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.geometry;

import org.netbeans.modules.bpel.design.geometry.FPoint;

public class FIntersector {
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private double dx;
    private double dy;
    private double t1;
    private double t2;

    public FIntersector() {
    }

    public FIntersector(double d, double d2, double d3, double d4) {
        this.setLine(d, d2, d3, d4);
    }

    public void setLine(FPoint fPoint, FPoint fPoint2) {
        this.x1 = fPoint.x;
        this.y1 = fPoint.y;
        this.x2 = fPoint2.x;
        this.y2 = fPoint2.y;
        this.dx = this.x2 - this.x1;
        this.dy = this.y2 - this.y1;
        this.t1 = Double.POSITIVE_INFINITY;
        this.t2 = Double.NEGATIVE_INFINITY;
    }

    public void setLine(double d, double d2, double d3, double d4) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
        this.dx = d3 - d;
        this.dy = d4 - d2;
        this.t1 = Double.POSITIVE_INFINITY;
        this.t2 = Double.NEGATIVE_INFINITY;
    }

    public void intersectByRoundRectangle(double d, double d2, double d3, double d4, double d5) {
        double d6 = d3 / 2.0;
        double d7 = d4 / 2.0;
        double d8 = d + d6;
        double d9 = d2 + d7;
        if (d5 >= d6) {
            if (d5 >= d7) {
                this.intersectByCircle(d + d6, d2 + d7, d6 < d7 ? d6 : d7);
            } else {
                d5 = d6;
                double d10 = d2 + d5;
                double d11 = d2 + d4 - d5;
                this.intersectByRectangle(d8, d9, d6, (d11 - d10) / 2.0);
                d8 = d + d5;
                this.intersectByCircle(d8, d10, d5);
                this.intersectByCircle(d8, d11, d5);
            }
        } else if (d5 >= d7) {
            d5 = d7;
            double d12 = d + d5;
            double d13 = d + d3 - d5;
            this.intersectByRectangle(d8, d9, (d13 - d12) / 2.0, d7);
            d9 = d2 + d5;
            this.intersectByCircle(d12, d9, d5);
            this.intersectByCircle(d13, d9, d5);
        } else {
            double d14 = d + d5;
            double d15 = d + d3 - d5;
            double d16 = d2 + d5;
            double d17 = d2 + d4 - d5;
            this.intersectByRectangle(d8, d9, (d15 - d14) / 2.0, d7);
            this.intersectByRectangle(d8, d9, d6, (d17 - d16) / 2.0);
            this.intersectByCircle(d14, d16, d5);
            this.intersectByCircle(d14, d17, d5);
            this.intersectByCircle(d15, d16, d5);
            this.intersectByCircle(d15, d17, d5);
        }
    }

    public void intersectByCircle(double d, double d2, double d3) {
        double d4 = this.x1 - d;
        double d5 = this.y1 - d2;
        double d6 = this.dx;
        double d7 = this.dy;
        double d8 = d3 * d3;
        double d9 = (d6 * d6 + d7 * d7) / d8;
        double d10 = (d4 * d6 + d5 * d7) / d8;
        double d11 = (d4 * d4 + d5 * d5) / d8 - 1.0;
        if ((float)d9 == 0.0f) {
            this.storeT(-d11 / d10);
            return;
        }
        double d12 = d10 * d10 - d9 * d11;
        if ((float)d12 == 0.0f) {
            this.storeT(-d10 / d9);
        } else if (d12 > 0.0) {
            d12 = Math.sqrt(d12);
            this.storeT((-d10 - d12) / d9);
            this.storeT((-d10 + d12) / d9);
        }
    }

    public void intersectByEllipse(double d, double d2, double d3, double d4) {
        if ((float)(d3 - d4) == 0.0f) {
            this.intersectByCircle(d, d2, (d3 + d4) / 2.0);
            return;
        }
        double d5 = this.x1 - d;
        double d6 = this.y1 - d2;
        double d7 = this.dx;
        double d8 = this.dy;
        double d9 = d3 * d3;
        double d10 = d4 * d4;
        double d11 = d7 * d7 / d9 + d8 * d8 / d10;
        double d12 = d7 * d5 / d9 + d8 * d6 / d10;
        double d13 = d5 * d5 / d9 + d6 * d6 / d10 - 1.0;
        if ((float)d11 == 0.0f) {
            this.storeT(-d13 / d12);
            return;
        }
        double d14 = d12 * d12 - d11 * d13;
        if ((float)d14 == 0.0f) {
            this.storeT(-d12 / d11);
        } else if (d14 > 0.0) {
            d14 = Math.sqrt(d14);
            this.storeT((-d12 - d14) / d11);
            this.storeT((-d12 + d14) / d11);
        }
    }

    public void intersectByRoumb(double d, double d2, double d3, double d4) {
        double d5 = this.x1 - d;
        double d6 = d3 * d4;
        double d7 = this.y1 - d2;
        double d8 = this.x2 - this.x1;
        double d9 = this.y2 - this.y1;
        double d10 = (d6 - (d5 * d4 + d7 * d3)) / (d8 * d4 + d9 * d3);
        if (d5 + d10 * d8 >= 0.0 && d7 + d10 * d9 >= 0.0) {
            this.storeT(d10);
        }
        if (d5 + (d10 = (d6 - (-d5 * d4 + d7 * d3)) / (-d8 * d4 + d9 * d3)) * d8 <= 0.0 && d7 + d10 * d9 >= 0.0) {
            this.storeT(d10);
        }
        if (d5 + (d10 = (d6 - (d5 * d4 - d7 * d3)) / (d8 * d4 - d9 * d3)) * d8 >= 0.0 && d7 + d10 * d9 <= 0.0) {
            this.storeT(d10);
        }
        if (d5 + (d10 = (d6 - (-d5 * d4 - d7 * d3)) / (-d8 * d4 - d9 * d3)) * d8 <= 0.0 && d7 + d10 * d9 <= 0.0) {
            this.storeT(d10);
        }
    }

    public void intersectByRectangle(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = this.x1 - d;
        double d7 = this.y1 - d2;
        double d8 = this.x2 - this.x1;
        double d9 = this.y2 - this.y1;
        if ((float)d8 != 0.0f) {
            d5 = (-d3 - d6) / d8;
            if (FIntersector.betweenIn(-d4, d7 + d5 * d9, d4)) {
                this.storeT(d5);
            }
            if (FIntersector.betweenIn(-d4, d7 + (d5 = (d3 - d6) / d8) * d9, d4)) {
                this.storeT(d5);
            }
        }
        if ((float)d9 != 0.0f) {
            d5 = (-d4 - d7) / d9;
            if (FIntersector.betweenIn(-d3, d6 + d5 * d8, d3)) {
                this.storeT(d5);
            }
            if (FIntersector.betweenIn(-d3, d6 + (d5 = (d4 - d7) / d9) * d8, d3)) {
                this.storeT(d5);
            }
        }
    }

    public boolean ok() {
        if (this.t1 < 0.0) {
            this.t1 = 0.0;
        }
        if (this.t2 > 1.0) {
            this.t2 = 1.0;
        }
        return this.t1 <= this.t2;
    }

    public double getT1() {
        return this.t1;
    }

    public double getT2() {
        return this.t2;
    }

    private void storeT(double d) {
        if (d < this.t1) {
            this.t1 = d;
        }
        if (d > this.t2) {
            this.t2 = d;
        }
    }

    private static boolean betweenEx(double d, double d2, double d3) {
        return d <= d3 ? d < d2 && d2 < d3 : d3 < d2 && d2 < d;
    }

    private static boolean betweenIn(double d, double d2, double d3) {
        return d <= d3 ? d <= d2 && d2 <= d3 : d3 <= d2 && d2 <= d;
    }
}

