/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration.providers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.decoration.ComponentsDescriptor;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.DecorationProvider;
import org.netbeans.modules.bpel.design.decoration.Positioner;
import org.netbeans.modules.bpel.design.decoration.components.ContextToolBarButton;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.elements.icons.Icon2D;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollapseExpandDecorationProvider
extends DecorationProvider {
    private final Positioner collapseExpandPositioner = new Positioner(){

        @Override
        public void position(Pattern pattern, Collection<Component> collection, double d) {
            VisualElement visualElement = null;
            if (pattern instanceof CompositePattern) {
                visualElement = ((CompositePattern)pattern).getBorder();
            }
            if (visualElement == null) {
                visualElement = pattern.getFirstElement();
            }
            Component component = collection.iterator().next();
            Dimension dimension = component.getPreferredSize();
            DiagramView diagramView = pattern.getView();
            Point point = diagramView.convertDiagramToScreen(new FPoint(visualElement.getCenterX(), visualElement.getY() + visualElement.getHeight()));
            component.setBounds(point.x - dimension.width / 2, point.y - dimension.height - 2, dimension.width, dimension.height);
        }
    };
    private static final Icon SMALL_EXPAND_ICON;
    private static final Icon NORMAL_EXPAND_ICON;
    private static final Icon NORMAL_COLLAPSE_ICON;

    public CollapseExpandDecorationProvider(DesignView designView) {
        super(designView);
    }

    @Override
    public Decoration getDecoration(BpelEntity bpelEntity) {
        Pattern pattern = this.getDesignView().getModel().getPattern(bpelEntity);
        if (pattern == null) {
            return null;
        }
        if (pattern.getOMReference() == null) {
            return null;
        }
        if (this.isInsideCollapsed(bpelEntity)) {
            return null;
        }
        if (this.isCollapsed(bpelEntity)) {
            ComponentsDescriptor componentsDescriptor = new ComponentsDescriptor();
            componentsDescriptor.add(new ContextToolBarButton(new ExpandAction(pattern, SMALL_EXPAND_ICON), new Color(-1711276033, true)), this.collapseExpandPositioner);
            return new Decoration(componentsDescriptor);
        }
        return null;
    }

    private boolean isCollapsed(BpelEntity bpelEntity) {
        return this.getDesignView().getModel().isCollapsed(bpelEntity);
    }

    public boolean isInsideCollapsed(BpelEntity bpelEntity) {
        for (BpelContainer bpelContainer = bpelEntity.getParent(); bpelContainer != null; bpelContainer = bpelContainer.getParent()) {
            if (!this.isCollapsed((BpelEntity)bpelContainer)) continue;
            return true;
        }
        return false;
    }

    public List<BpelEntity> findCollapsedBpelEntitesInside(BpelEntity bpelEntity, List<BpelEntity> list) {
        if (list == null) {
            list = new ArrayList<BpelEntity>();
        }
        for (BpelEntity bpelEntity2 : bpelEntity.getChildren()) {
            if (this.isCollapsed(bpelEntity2)) {
                list.add(bpelEntity2);
                continue;
            }
            list = this.findCollapsedBpelEntitesInside(bpelEntity2, list);
        }
        return list;
    }

    private boolean isSelected(BpelEntity bpelEntity) {
        UniqueId uniqueId = bpelEntity.getUID();
        UniqueId uniqueId2 = this.getDesignView().getSelectionModel().getSelectedID();
        return uniqueId != null && uniqueId.equals(uniqueId2);
    }

    public Action createCollapseExpandAction(BpelEntity bpelEntity) {
        Pattern pattern = this.getDesignView().getModel().getPattern(bpelEntity);
        if (pattern == null) {
            return null;
        }
        return this.createCollapseExpandAction(pattern);
    }

    public Action createCollapseExpandAction(Pattern pattern) {
        if (this.getDesignView().getModel().isCollapsed(pattern.getOMReference())) {
            return new ExpandAction(pattern);
        }
        if (pattern.isCollapsable()) {
            return new CollapseAction(pattern);
        }
        return null;
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(7, 7, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(new Color(-1996488705, true));
        graphics2D.fillRect(0, 2, 7, 3);
        graphics2D.fillRect(2, 0, 3, 7);
        graphics2D.setPaint(Icon2D.COLOR);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.drawLine(0, 3, 6, 3);
        graphics2D.drawLine(3, 0, 3, 6);
        graphics2D.dispose();
        SMALL_EXPAND_ICON = new ImageIcon(bufferedImage);
        bufferedImage = new BufferedImage(16, 16, 2);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(Icon2D.COLOR);
        graphics2D.fillRect(6, 2, 4, 12);
        graphics2D.fillRect(2, 6, 12, 4);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fillRect(7, 3, 2, 10);
        graphics2D.fillRect(3, 7, 10, 2);
        graphics2D.dispose();
        NORMAL_EXPAND_ICON = new ImageIcon(bufferedImage);
        bufferedImage = new BufferedImage(16, 16, 2);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(Icon2D.COLOR);
        graphics2D.fillRect(2, 6, 12, 4);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fillRect(3, 7, 10, 2);
        graphics2D.dispose();
        NORMAL_COLLAPSE_ICON = new ImageIcon(bufferedImage);
    }

    private class ExpandAction
    extends AbstractAction {
        private Pattern pattern;

        public ExpandAction(Pattern pattern, Icon icon) {
            super(NbBundle.getMessage(CollapseExpandDecorationProvider.class, (String)"LBL_EXPAND_ACTION"), icon);
            this.putValue("ShortDescription", NbBundle.getMessage(CollapseExpandDecorationProvider.class, (String)"TTT_EXPAND_ACTION"));
            this.pattern = pattern;
        }

        public ExpandAction(Pattern pattern) {
            this(pattern, NORMAL_EXPAND_ICON);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.pattern.getModel().setCollapsed(this.pattern.getOMReference(), false);
            CollapseExpandDecorationProvider.this.fireDecorationChanged();
        }
    }

    private class CollapseAction
    extends AbstractAction {
        private Pattern pattern;

        public CollapseAction(Pattern pattern) {
            super(NbBundle.getMessage(CollapseExpandDecorationProvider.class, (String)"LBL_COLLAPSE_ACTION"), NORMAL_COLLAPSE_ICON);
            this.putValue("ShortDescription", NbBundle.getMessage(CollapseExpandDecorationProvider.class, (String)"TTT_COLLAPSE_ACTION"));
            this.pattern = pattern;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.pattern.getModel().setCollapsed(this.pattern.getOMReference(), true);
            CollapseExpandDecorationProvider.this.fireDecorationChanged();
        }
    }
}

