/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration.components;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.components.AbstractGlassPaneButton;
import org.netbeans.modules.bpel.design.decoration.components.ButtonRenderer;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowGlassPaneButton
extends AbstractGlassPaneButton {
    private static Color BACKGROUND = new Color(-855638017, true);
    private static final String ERROR_ICON_PATH = "resources/error.png";
    private static final String ERROR_SLOW_ICON_PATH = "resources/error_explicit.png";
    private static final String WARNING_ICON_PATH = "resources/warning.png";
    private static final String WARNING_SLOW_ICON_PATH = "resources/warning_explicit.png";
    private static final String ADVICE_ICON_PATH = "resources/advice.png";
    private static final String ADVICE_SLOW_ICON_PATH = "resources/advice_explicit.png";
    private static final Icon ERROR_ICON = new ImageIcon(Decoration.class.getResource("resources/error.png"));
    private static final Icon ERROR_SLOW_ICON = new ImageIcon(Decoration.class.getResource("resources/error_explicit.png"));
    private static final Icon WARNING_ICON = new ImageIcon(Decoration.class.getResource("resources/warning.png"));
    private static final Icon WARNING_SLOW_ICON = new ImageIcon(Decoration.class.getResource("resources/warning_explicit.png"));
    private static final Icon ADVICE_ICON = new ImageIcon(Decoration.class.getResource("resources/advice.png"));
    private static final Icon ADVICE_SLOW_ICON = new ImageIcon(Decoration.class.getResource("resources/advice_explicit.png"));

    public ShowGlassPaneButton(List<Validator.ResultItem> list) {
        super(ERROR_ICON);
        this.fillGlassPaneHeader(list);
        this.fillGlassPaneContent(list);
        this.updatePreferredSize();
    }

    public void setResultItems(List<Validator.ResultItem> list) {
        this.getGlassPane().removeHeaders();
        this.getGlassPane().removeHTML();
        this.fillGlassPaneHeader(list);
        this.fillGlassPaneContent(list);
    }

    private void fillGlassPaneHeader(List<Validator.ResultItem> list) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Validator.ResultItem resultItem : list) {
            switch (resultItem.getType()) {
                case ERROR: {
                    ++n;
                    break;
                }
                case WARNING: {
                    ++n2;
                    break;
                }
                case ADVICE: {
                    ++n3;
                }
            }
        }
        if (n > 0) {
            if (n > 1) {
                this.getGlassPane().addHeader(ERROR_ICON, "" + n + " " + NbBundle.getMessage(this.getClass(), (String)"LBL_ShowGlassPaneButton_N_Errors").trim());
            } else {
                this.getGlassPane().addHeader(ERROR_ICON, NbBundle.getMessage(this.getClass(), (String)"LBL_ShowGlassPaneButton_1_Error").trim());
            }
        }
        if (n2 > 0) {
            if (n2 > 1) {
                this.getGlassPane().addHeader(WARNING_ICON, "" + n2 + " " + NbBundle.getMessage(this.getClass(), (String)"LBL_ShowGlassPaneButton_N_Warnings").trim());
            } else {
                this.getGlassPane().addHeader(WARNING_ICON, NbBundle.getMessage(this.getClass(), (String)"LBL_ShowGlassPaneButton_1_Warning").trim());
            }
        }
        if (n3 > 0) {
            if (n3 > 1) {
                this.getGlassPane().addHeader(ADVICE_ICON, "" + n3 + " " + NbBundle.getMessage(this.getClass(), (String)"LBL_ShowGlassPaneButton_N_Advices").trim());
            } else {
                this.getGlassPane().addHeader(ADVICE_ICON, NbBundle.getMessage(this.getClass(), (String)"LBL_ShowGlassPaneButton_1_Advice").trim());
            }
        }
        if (n > 0) {
            this.setMyIcon(ERROR_ICON);
        } else if (n2 > 0) {
            this.setMyIcon(WARNING_ICON);
        } else if (n3 > 0) {
            this.setMyIcon(ADVICE_ICON);
        }
    }

    private void fillGlassPaneContent(List<Validator.ResultItem> list) {
        this.addToGlassPane(list, Validator.ResultType.ERROR);
        this.addToGlassPane(list, Validator.ResultType.ADVICE);
        this.addToGlassPane(list, Validator.ResultType.WARNING);
        this.getGlassPane().updateHTML();
    }

    private void addToGlassPane(List<Validator.ResultItem> list, Validator.ResultType resultType) {
        List<Validator.ResultItem> list2 = this.filterResultItems(list, resultType);
        String string = null;
        String string2 = null;
        switch (resultType) {
            case ERROR: {
                string = ERROR_ICON_PATH;
                string2 = ERROR_SLOW_ICON_PATH;
                break;
            }
            case WARNING: {
                string = WARNING_ICON_PATH;
                string2 = WARNING_SLOW_ICON_PATH;
                break;
            }
            case ADVICE: {
                string = ADVICE_ICON_PATH;
                string2 = ADVICE_SLOW_ICON_PATH;
            }
        }
        for (Validator.ResultItem resultItem : list2) {
            if ("BPELSchemaValidator".equals(resultItem.getValidator().getName())) {
                this.getGlassPane().addListItem(string2, resultItem.getDescription());
                continue;
            }
            this.getGlassPane().addListItem(string, resultItem.getDescription());
        }
    }

    private List<Validator.ResultItem> filterResultItems(List<Validator.ResultItem> list, Validator.ResultType resultType) {
        ArrayList<Validator.ResultItem> arrayList = new ArrayList<Validator.ResultItem>();
        for (Validator.ResultItem resultItem : list) {
            if (resultItem.getType() != resultType) continue;
            arrayList.add(resultItem);
        }
        return arrayList;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        ButtonModel buttonModel = this.getModel();
        if (buttonModel.isPressed()) {
            ButtonRenderer.paintButton(this, graphics, ButtonRenderer.PRESSED_FILL_COLOR, false, ButtonRenderer.PRESSED_BORDER_COLOR, 1.3f, this.getMyIcon());
        } else if (buttonModel.isRollover()) {
            ButtonRenderer.paintButton(this, graphics, ButtonRenderer.ROLLOVER_FILL_COLOR, true, ButtonRenderer.ROLLOVER_BORDER_COLOR, 1.0f, this.getMyIcon());
        } else if (buttonModel.isSelected()) {
            ButtonRenderer.paintButton(this, graphics, BACKGROUND, false, ButtonRenderer.PRESSED_BORDER_COLOR, 1.3f, this.getMyIcon());
        } else {
            ButtonRenderer.paintButton(this, graphics, BACKGROUND, false, null, 1.0f, this.getMyIcon());
        }
    }
}

