/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.NameEditor;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.EntitySelectionModel;

public class MouseHandler
extends MouseAdapter {
    private DiagramView diagramView;

    public MouseHandler(DiagramView diagramView) {
        this.diagramView = diagramView;
        diagramView.addMouseListener(this);
    }

    public DiagramView getDiagramView() {
        return this.diagramView;
    }

    public void cancel() {
        this.getNameEditor().cancelEdit();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.getDiagramView().requestFocus();
        Pattern pattern = this.getDiagramView().findPattern(mouseEvent.getPoint());
        this.getSelectionModel().setSelectedPattern(pattern);
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            Pattern pattern;
            this.getNameEditor().startEdit(mouseEvent.getPoint());
            if (!this.getNameEditor().isActive() && (pattern = this.getSelectionModel().getSelectedPattern()) != null) {
                this.getDiagramView().getDesignView().performDefaultAction(pattern);
            }
        }
    }

    public NameEditor getNameEditor() {
        return this.getDiagramView().getNameEditor();
    }

    public EntitySelectionModel getSelectionModel() {
        return this.getDiagramView().getDesignView().getSelectionModel();
    }

    public boolean maybeShowPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return false;
        }
        Pattern pattern = this.getSelectionModel().getSelectedPattern();
        if (pattern == null) {
            return false;
        }
        JPopupMenu jPopupMenu = pattern.createPopupMenu();
        if (jPopupMenu == null) {
            return false;
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        return true;
    }
}

