/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.actions.DesignModeAction;
import org.netbeans.modules.bpel.design.actions.PasteModeAction;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.model.patterns.ProcessPattern;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.design.selection.PlaceHolderManager;
import org.netbeans.modules.bpel.model.api.BpelEntity;

public class CopyPasteHandler
implements MouseListener {
    private DesignView designView;
    private Pattern copiedPattern;
    private PlaceHolderManager[] managers;
    private PlaceHolder currentPlaceholder;

    public CopyPasteHandler(DesignView designView) {
        this.designView = designView;
        this.managers = new PlaceHolderManager[]{designView.getConsumersView().getPlaceholderManager(), designView.getProcessView().getPlaceholderManager(), designView.getProvidersView().getPlaceholderManager()};
    }

    public void enterPasteMode(Pattern pattern) {
        this.copiedPattern = pattern;
        this.currentPlaceholder = null;
        for (PlaceHolderManager placeHolderManager : this.managers) {
            placeHolderManager.init(pattern);
            placeHolderManager.getDiagramView().addMouseListener(this);
        }
        this.tabNextPlaceholder(true);
    }

    public void exitPasteMode() {
        this.copiedPattern = null;
        this.currentPlaceholder = null;
        for (PlaceHolderManager placeHolderManager : this.managers) {
            placeHolderManager.clear();
            placeHolderManager.getDiagramView().removeMouseListener(this);
        }
    }

    public boolean isActive() {
        return this.copiedPattern != null;
    }

    public CopyAction getCopyAction() {
        return new CopyAction();
    }

    public CutAction getCutAction() {
        return new CutAction();
    }

    public PasteAction getPasteAction() {
        return new PasteAction();
    }

    public void tabNextPlaceholder(boolean bl) {
        PlaceHolder placeHolder;
        ArrayList<PlaceHolder> arrayList = new ArrayList<PlaceHolder>();
        for (PlaceHolderManager placeHolderManager : this.managers) {
            List<PlaceHolder> list = placeHolderManager.getPlaceHolders();
            Collections.sort(list, new Comparator<PlaceHolder>(){

                @Override
                public int compare(PlaceHolder placeHolder, PlaceHolder placeHolder2) {
                    Rectangle rectangle = placeHolder.getShape().getBounds();
                    Rectangle rectangle2 = placeHolder2.getShape().getBounds();
                    return rectangle.x * rectangle.x + rectangle.y * rectangle.y - (rectangle2.x * rectangle2.x + rectangle2.y * rectangle2.y);
                }
            });
            arrayList.addAll(list);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        if (this.currentPlaceholder == null) {
            placeHolder = (PlaceHolder)arrayList.get(bl ? 0 : arrayList.size() - 1);
        } else {
            int n = arrayList.indexOf(this.currentPlaceholder);
            int n2 = n = bl ? n + 1 : n - 1;
            if (n < 0) {
                n = arrayList.size() - 1;
            } else if (n >= arrayList.size()) {
                n = 0;
            }
            placeHolder = (PlaceHolder)arrayList.get(n);
        }
        for (PlaceHolderManager placeHolderManager : this.managers) {
            placeHolderManager.setCurrentPlaceholder(placeHolder);
        }
        this.currentPlaceholder = placeHolder;
        if (this.currentPlaceholder != null) {
            for (PlaceHolderManager placeHolderManager : this.managers) {
                if (!placeHolderManager.getPlaceHolders().contains(this.currentPlaceholder)) continue;
                placeHolderManager.getDiagramView().scrollPlaceholderToView(this.currentPlaceholder);
                break;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() instanceof DiagramView) {
            DiagramView diagramView = (DiagramView)mouseEvent.getComponent();
            List<PlaceHolder> list = diagramView.getPlaceholderManager().getPlaceHolders();
            FPoint fPoint = diagramView.convertScreenToDiagram(new Point(mouseEvent.getX(), mouseEvent.getY()));
            for (PlaceHolder placeHolder : list) {
                if (!placeHolder.contains(fPoint.x, fPoint.y)) continue;
                placeHolder.drop();
                break;
            }
            this.exitPasteMode();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public class CopyAction
    extends DesignModeAction {
        public CopyAction() {
            super(CopyPasteHandler.this.designView);
        }

        public boolean isEnabled() {
            if (!super.isEnabled()) {
                return false;
            }
            Pattern pattern = CopyPasteHandler.this.designView.getSelectionModel().getSelectedPattern();
            return pattern != null && !(pattern instanceof ProcessPattern);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            Pattern pattern = this.getPatternCopy(CopyPasteHandler.this.designView.getSelectionModel().getSelectedPattern());
            CopyPasteHandler.this.enterPasteMode(pattern);
        }

        private Pattern getPatternCopy(Pattern pattern) {
            if (pattern == null) {
                return null;
            }
            Pattern pattern2 = null;
            BpelEntity bpelEntity = pattern.getOMReference();
            if (bpelEntity == null) {
                return null;
            }
            pattern2 = CopyPasteHandler.this.designView.getModel().createPattern(bpelEntity.copy(new HashMap()));
            return pattern2;
        }
    }

    public class CutAction
    extends DesignModeAction {
        public CutAction() {
            super(CopyPasteHandler.this.designView);
        }

        public boolean isEnabled() {
            if (!super.isEnabled()) {
                return false;
            }
            Pattern pattern = CopyPasteHandler.this.designView.getSelectionModel().getSelectedPattern();
            return pattern != null && !(pattern instanceof ProcessPattern);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            CopyPasteHandler.this.enterPasteMode(this.getPatternCopy(CopyPasteHandler.this.designView.getSelectionModel().getSelectedPattern()));
        }

        private Pattern getPatternCopy(Pattern pattern) {
            if (pattern == null) {
                return null;
            }
            Pattern pattern2 = null;
            BpelEntity bpelEntity = pattern.getOMReference();
            if (bpelEntity == null) {
                return null;
            }
            pattern2 = CopyPasteHandler.this.designView.getModel().createPattern(bpelEntity.cut());
            return pattern2;
        }
    }

    class PasteAction
    extends PasteModeAction {
        private static final long serialVersionUID = 1L;

        public PasteAction() {
            super(CopyPasteHandler.this.designView);
        }

        public boolean isEnabled() {
            if (!super.isEnabled()) {
                return false;
            }
            return CopyPasteHandler.this.currentPlaceholder != null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            CopyPasteHandler.this.currentPlaceholder.drop();
            CopyPasteHandler.this.exitPasteMode();
        }
    }
}

