/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.tree;

import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class FolderTreeElement
implements TreeElement {
    private FileObject fo;

    FolderTreeElement(FileObject fileObject) {
        this.fo = fileObject;
    }

    public TreeElement getParent(boolean bl) {
        if (bl) {
            SourceGroup sourceGroup = FolderTreeElement.getSourceGroup(this.fo);
            if (sourceGroup != null) {
                return TreeElementFactory.getTreeElement((Object)sourceGroup);
            }
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)this.fo);
        if (project != null) {
            return TreeElementFactory.getTreeElement((Object)project);
        }
        return null;
    }

    public Icon getIcon() {
        return UiUtils.getElementIcon((ElementKind)ElementKind.PACKAGE, null);
    }

    public String getText(boolean bl) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)this.fo, (String)"classpath/source");
        if (classPath == null) {
            return this.fo.getPath();
        }
        if (FolderTreeElement.getJavaSourceGroup(this.fo) != null) {
            String string = classPath.getResourceName(this.fo).replace('/', '.');
            if ("".equals(string)) {
                return NbBundle.getMessage(UiUtils.class, (String)"LBL_DefaultPackage_PDU");
            }
            return string;
        }
        return this.fo.getPath();
    }

    static SourceGroup getSourceGroup(FileObject fileObject) {
        SourceGroup[] sourceGroupArray;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray2 = sources.getSourceGroups("java");
        SourceGroup[] sourceGroupArray3 = new SourceGroup[sourceGroupArray2.length + (sourceGroupArray = sources.getSourceGroups("xml")).length];
        if (sourceGroupArray3.length < 1) {
            Logger.getLogger(FolderTreeElement.class.getName()).severe("Cannot find SourceGroup for " + fileObject.getPath());
            return null;
        }
        System.arraycopy(sourceGroupArray2, 0, sourceGroupArray3, 0, sourceGroupArray2.length);
        System.arraycopy(sourceGroupArray, 0, sourceGroupArray3, sourceGroupArray3.length - 1, sourceGroupArray.length);
        for (int i = 0; i < sourceGroupArray3.length; ++i) {
            if (!sourceGroupArray3[i].getRootFolder().equals(fileObject) && !FileUtil.isParentOf((FileObject)sourceGroupArray3[i].getRootFolder(), (FileObject)fileObject)) continue;
            return sourceGroupArray3[i];
        }
        return null;
    }

    private static SourceGroup getJavaSourceGroup(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (!sourceGroupArray[i].getRootFolder().equals(fileObject) && !FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
            return sourceGroupArray[i];
        }
        return null;
    }

    public Object getUserObject() {
        return this.fo;
    }
}

