/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.ui.WhereUsedPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WhereUsedQueryUI
implements RefactoringUI {
    private WhereUsedQuery query = null;
    private final String name;
    private WhereUsedPanel panel;
    private final TreePathHandle element;
    private ElementKind kind;
    private AbstractRefactoring delegate;
    private ResourceBundle bundle;

    public WhereUsedQueryUI(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
        this.query = new WhereUsedQuery(Lookups.singleton((Object)treePathHandle));
        this.query.getContext().add((Object)compilationInfo.getClasspathInfo());
        this.element = treePathHandle;
        Element element = treePathHandle.resolveElement(compilationInfo);
        if (element != null) {
            this.name = UiUtils.getHeader((Element)element, (CompilationInfo)compilationInfo, (String)"%name%");
            this.kind = element.getKind();
        } else {
            this.name = "";
            this.kind = ElementKind.OTHER;
        }
    }

    public WhereUsedQueryUI(TreePathHandle treePathHandle, String string, AbstractRefactoring abstractRefactoring) {
        this.delegate = abstractRefactoring;
        this.element = treePathHandle;
        this.name = string;
    }

    public boolean isQuery() {
        return true;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            this.panel = new WhereUsedPanel(this.name, this.element, changeListener);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.query.putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.panel.isSearchInComments());
        if (this.panel.getScope() == WhereUsedPanel.Scope.ALL) {
            if (this.kind == ElementKind.METHOD && this.panel.isMethodFromBaseClass()) {
                TreePathHandle treePathHandle = this.panel.getBaseMethod();
                if (treePathHandle != null && (treePathHandle.getFileObject() == null || treePathHandle.getFileObject().getNameExt().endsWith("class"))) {
                    this.query.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(this.element, treePathHandle));
                } else {
                    this.query.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(treePathHandle));
                }
            } else {
                this.query.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(this.element));
            }
        } else {
            ClasspathInfo classpathInfo = (ClasspathInfo)this.query.getContext().lookup(ClasspathInfo.class);
            Project project = FileOwnerQuery.getOwner((FileObject)this.element.getFileObject());
            Sources sources = ProjectUtils.getSources((Project)project);
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            for (SourceGroup sourceGroup : sources.getSourceGroups("java")) {
                hashSet.add(sourceGroup.getRootFolder());
            }
            ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])hashSet.toArray(new FileObject[hashSet.size()]));
            classpathInfo = ClasspathInfo.create((ClassPath)classpathInfo.getClassPath(ClasspathInfo.PathKind.BOOT), (ClassPath)classpathInfo.getClassPath(ClasspathInfo.PathKind.COMPILE), (ClassPath)classPath);
            this.query.getContext().add((Object)classpathInfo);
        }
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.checkParameters();
        }
        if (this.kind.isClass() || this.kind.isInterface()) {
            this.setForClass();
            return this.query.checkParameters();
        }
        return null;
    }

    private void setForMethod() {
        if (this.panel.isMethodFromBaseClass()) {
            this.query.setRefactoringSource(Lookups.singleton((Object)this.panel.getBaseMethod()));
        } else {
            this.query.setRefactoringSource(Lookups.singleton((Object)this.element));
        }
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)this.panel.isMethodOverriders());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isMethodFindUsages());
    }

    private void setForClass() {
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES, (Object)this.panel.isClassSubTypes());
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES, (Object)this.panel.isClassSubTypesDirectOnly());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isClassFindUsages());
    }

    public Problem checkParameters() {
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.fastCheckParameters();
        }
        if (this.kind.isClass() || this.kind.isInterface()) {
            this.setForClass();
            return this.query.fastCheckParameters();
        }
        return null;
    }

    public AbstractRefactoring getRefactoring() {
        return this.query != null ? this.query : this.delegate;
    }

    public String getDescription() {
        if (this.panel != null) {
            if (this.kind == ElementKind.INTERFACE || this.kind == ElementKind.CLASS) {
                if (!this.panel.isClassFindUsages()) {
                    if (!this.panel.isClassSubTypesDirectOnly()) {
                        return this.getString("DSC_WhereUsedFindAllSubTypes", this.name);
                    }
                    return this.getString("DSC_WhereUsedFindDirectSubTypes", this.name);
                }
            } else if (this.kind == ElementKind.METHOD) {
                String string = null;
                if (this.panel.isMethodFindUsages()) {
                    string = this.getString("DSC_FindUsages");
                }
                if (this.panel.isMethodOverriders()) {
                    string = string != null ? string + " " + this.getString("DSC_And") + " " : "";
                    string = string + this.getString("DSC_WhereUsedMethodOverriders");
                }
                string = string + " " + this.getString("DSC_WhereUsedOf", this.panel.getMethodDeclaringClass() + '.' + this.name);
                return string;
            }
        }
        return this.getString("DSC_WhereUsed", this.name);
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(WhereUsedQueryUI.class);
        }
        return this.bundle.getString(string);
    }

    private String getString(String string, String string2) {
        return new MessageFormat(this.getString(string)).format(new Object[]{string2});
    }

    public String getName() {
        return new MessageFormat(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_UsagesOf")).format(new Object[]{this.name});
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WhereUsedQueryUI.class);
    }
}

