/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.EncapsulateFieldsRefactoring;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncapsulateFieldPanel
extends JPanel
implements CustomRefactoringPanel {
    private DefaultTableModel model;
    private TreePathHandle selectedObjects;
    private ChangeListener parent;
    private String classname;
    private String[][] methodNames;
    private static boolean ALWAYS_USE_ACCESSORS = true;
    private static int FIELD_ACCESS_INDEX = 3;
    private static int METHOD_ACCESS_INDEX = 0;
    private static final String[] modifierNames = new String[]{"public", "protected", "<default>", "private"};
    private static final String[] columnNames = new String[]{EncapsulateFieldPanel.getString("LBL_ColField"), "    ", EncapsulateFieldPanel.getString("LBL_ColGetter"), "    ", EncapsulateFieldPanel.getString("LBL_ColSetter")};
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_DEFAULT_INDEX = 2;
    private static final int MOD_PRIVATE_INDEX = 3;
    private static final Class[] columnTypes = new Class[]{MemberInfo.class, Boolean.class, String.class, Boolean.class, String.class};
    private boolean initialized = false;
    private JCheckBox jCheckAccess;
    private JComboBox jComboAccess;
    private JComboBox jComboField;
    private JLabel jLblAccessVis;
    private JLabel jLblFieldVis;
    private JLabel jLblTitle;
    private JScrollPane jScrollField;
    private JTable jTableFields;

    public EncapsulateFieldPanel(TreePathHandle treePathHandle, ChangeListener changeListener) {
        String string = EncapsulateFieldPanel.getString("LBL_TitleEncapsulateFields");
        this.selectedObjects = treePathHandle;
        this.parent = changeListener;
        this.model = new TabM(columnNames, 0);
        this.initComponents();
        this.setName(string);
        this.jCheckAccess.setSelected(ALWAYS_USE_ACCESSORS);
        this.jComboAccess.setSelectedIndex(METHOD_ACCESS_INDEX);
        this.jComboField.setSelectedIndex(FIELD_ACCESS_INDEX);
        this.jTableFields.setDefaultRenderer(MemberInfo.class, new UIUtilities.JavaElementTableCellRenderer());
        this.jScrollField.setBackground(this.jTableFields.getBackground());
        this.jScrollField.getViewport().setBackground(this.jTableFields.getBackground());
        this.jTableFields.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.jTableFields.setGridColor(UIManager.getColor("control"));
        }
    }

    public Component getComponent() {
        return this;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.selectedObjects.getFileObject());
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    EncapsulateFieldPanel.this.initialize(compilationController);
                }
            }, true);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public void initialize(CompilationController compilationController) {
        TreePath treePath = this.selectedObjects.resolve((CompilationInfo)compilationController);
        Element element = compilationController.getTrees().getElement(treePath);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (VariableElement variableElement : this.initFields(treePath, (CompilationInfo)compilationController)) {
            TreePath treePath2 = compilationController.getTrees().getPath(variableElement);
            boolean bl = element == variableElement;
            boolean bl2 = bl && !variableElement.getModifiers().contains((Object)Modifier.FINAL);
            String[] stringArray = new String[]{EncapsulateFieldRefactoringPlugin.computeGetterName(variableElement), EncapsulateFieldRefactoringPlugin.computeSetterName(variableElement)};
            arrayList.add(stringArray);
            this.model.addRow(new Object[]{MemberInfo.create(treePath2, (CompilationInfo)compilationController), bl ? Boolean.TRUE : Boolean.FALSE, bl ? stringArray[0] : null, bl2 ? Boolean.TRUE : Boolean.FALSE, bl2 ? stringArray[1] : null});
        }
        this.methodNames = (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
        this.packRows(this.jTableFields);
        this.jTableFields.getTableHeader().setReorderingAllowed(false);
        this.setColumnWidth(1);
        this.setColumnWidth(3);
        this.jTableFields.invalidate();
        this.jTableFields.repaint();
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = tableModelEvent.getColumn();
                int n2 = tableModelEvent.getFirstRow();
                if (n == 1 || n == 3) {
                    Boolean bl = (Boolean)EncapsulateFieldPanel.this.model.getValueAt(n2, n);
                    if (bl.booleanValue()) {
                        if (n == 1) {
                            EncapsulateFieldPanel.this.model.setValueAt(EncapsulateFieldPanel.this.methodNames[n2][0], n2, n + 1);
                        } else {
                            EncapsulateFieldPanel.this.model.setValueAt(EncapsulateFieldPanel.this.methodNames[n2][1], n2, n + 1);
                        }
                    } else if (EncapsulateFieldPanel.this.model.getValueAt(n2, n + 1) != null) {
                        EncapsulateFieldPanel.this.model.setValueAt(null, n2, n + 1);
                    }
                } else {
                    String string = (String)EncapsulateFieldPanel.this.model.getValueAt(n2, n);
                    if (string == null | "".equals(string)) {
                        EncapsulateFieldPanel.this.model.setValueAt(Boolean.FALSE, n2, n - 1);
                    }
                }
                EncapsulateFieldPanel.this.parent.stateChanged(null);
            }
        });
        this.initialized = true;
    }

    private void setColumnWidth(int n) {
        TableColumn tableColumn = this.jTableFields.getColumnModel().getColumn(n);
        JCheckBox jCheckBox = new JCheckBox();
        int n2 = (int)jCheckBox.getPreferredSize().getWidth();
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setResizable(false);
    }

    private int getMinimumRowHeight(JTable jTable, int n) {
        int n2 = jTable.getRowHeight();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, i);
            Component component = jTable.prepareRenderer(tableCellRenderer, n, i);
            int n3 = component.getMinimumSize().height;
            n2 = Math.max(n2, n3);
        }
        return n2;
    }

    private void packRows(JTable jTable) {
        int n = 0;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            int n2 = this.getMinimumRowHeight(jTable, i);
            if (n2 <= n) continue;
            n = n2;
        }
        jTable.setRowHeight(n);
        jTable.getTableHeader().setPreferredSize(new Dimension(jTable.getTableHeader().getPreferredSize().width, n));
    }

    protected DefaultTableModel getTableModel() {
        return this.model;
    }

    private void initComponents() {
        this.jLblTitle = new JLabel();
        this.jScrollField = new JScrollPane();
        this.jTableFields = new JTable();
        this.jLblFieldVis = new JLabel();
        this.jComboField = new JComboBox();
        this.jLblAccessVis = new JLabel();
        this.jComboAccess = new JComboBox();
        this.jCheckAccess = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.jLblTitle.setLabelFor(this.jTableFields);
        Mnemonics.setLocalizedText((JLabel)this.jLblTitle, (String)EncapsulateFieldPanel.getString("LBL_FieldList"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLblTitle, gridBagConstraints);
        this.jScrollField.setPreferredSize(new Dimension(300, 200));
        this.jTableFields.setModel(this.model);
        this.jScrollField.setViewportView(this.jTableFields);
        this.jTableFields.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle").getString("ACSD_jTableFields"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 12, 2);
        this.add((Component)this.jScrollField, gridBagConstraints);
        this.jLblFieldVis.setLabelFor(this.jComboField);
        Mnemonics.setLocalizedText((JLabel)this.jLblFieldVis, (String)EncapsulateFieldPanel.getString("LBL_FieldVis"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 5, 5);
        this.add((Component)this.jLblFieldVis, gridBagConstraints);
        this.jComboField.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.jComboField.setSelectedIndex(3);
        this.jComboField.setPreferredSize(new Dimension(100, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jComboField, gridBagConstraints);
        this.jComboField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle").getString("ACSD_fieldModifiers"));
        this.jLblAccessVis.setLabelFor(this.jComboAccess);
        Mnemonics.setLocalizedText((JLabel)this.jLblAccessVis, (String)EncapsulateFieldPanel.getString("LBL_AccessVis"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add((Component)this.jLblAccessVis, gridBagConstraints);
        this.jComboAccess.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.jComboAccess.setSelectedIndex(0);
        this.jComboAccess.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jComboAccess, gridBagConstraints);
        this.jComboAccess.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle").getString("ACSD_methodAcc"));
        this.jCheckAccess.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckAccess, (String)EncapsulateFieldPanel.getString("LBL_AccessorsEven"));
        this.jCheckAccess.setMargin(new Insets(12, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.jCheckAccess, gridBagConstraints);
        this.jCheckAccess.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle").getString("ACSD_useAccessors"));
    }

    private static String getString(String string) {
        return NbBundle.getMessage(EncapsulateFieldPanel.class, (String)string);
    }

    private List<VariableElement> initFields(TreePath treePath, CompilationInfo compilationInfo) {
        Element element = compilationInfo.getTrees().getElement(treePath);
        TypeElement typeElement = null;
        typeElement = ElementKind.FIELD == element.getKind() ? (TypeElement)element.getEnclosingElement() : (TypeElement)element;
        ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
        for (Element element2 : typeElement.getEnclosedElements()) {
            if (ElementKind.FIELD != element2.getKind()) continue;
            arrayList.add((VariableElement)element2);
        }
        this.classname = typeElement.getQualifiedName().toString();
        String string = " - " + this.classname;
        this.setName(this.getName() + (String)string);
        return arrayList;
    }

    public Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> getAllFields() {
        ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> arrayList = new ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo>();
        Vector<Vector> vector = this.model.getDataVector();
        for (List list : vector) {
            if (list.get(1) != Boolean.TRUE && list.get(3) != Boolean.TRUE) continue;
            String string = (String)list.get(2);
            String string2 = (String)list.get(4);
            MemberInfo memberInfo = (MemberInfo)list.get(0);
            arrayList.add(new EncapsulateFieldsRefactoring.EncapsulateFieldInfo((TreePathHandle)memberInfo.getElementHandle(), "".equals(string) ? null : string, "".equals(string2) ? null : string2));
        }
        return arrayList;
    }

    public boolean isCheckAccess() {
        ALWAYS_USE_ACCESSORS = this.jCheckAccess.isSelected();
        return ALWAYS_USE_ACCESSORS;
    }

    public Set<Modifier> getFieldModifiers() {
        FIELD_ACCESS_INDEX = this.jComboField.getSelectedIndex();
        Modifier modifier = this.getModifier(FIELD_ACCESS_INDEX);
        if (modifier == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(modifier);
    }

    public Set<Modifier> getMethodModifiers() {
        METHOD_ACCESS_INDEX = this.jComboAccess.getSelectedIndex();
        Modifier modifier = this.getModifier(METHOD_ACCESS_INDEX);
        if (modifier == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(modifier);
    }

    private Modifier getModifier(int n) {
        switch (n) {
            case 3: {
                return Modifier.PRIVATE;
            }
            case 2: {
                return null;
            }
            case 1: {
                return Modifier.PROTECTED;
            }
            case 0: {
                return Modifier.PUBLIC;
            }
        }
        throw new IllegalStateException("unknown index: " + n);
    }

    String getClassname() {
        return this.classname;
    }

    private static class TabM
    extends DefaultTableModel {
        public TabM(Object[] objectArray, int n) {
            super(objectArray, n);
        }

        public Class getColumnClass(int n) {
            return columnTypes[n];
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            if (n2 == 1 || n2 == 3) {
                return true;
            }
            return (Boolean)this.getValueAt(n, n2 - 1);
        }
    }
}

