/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.CopyClassPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class CopyClassRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final SingleCopyRefactoring refactoring;
    private CopyClassPanel panel;
    private FileObject resource;
    private FileObject targetFolder;
    private PasteType paste;

    public CopyClassRefactoringUI(FileObject fileObject, FileObject fileObject2, PasteType pasteType) {
        this.refactoring = new SingleCopyRefactoring(Lookups.singleton((Object)fileObject));
        this.resource = fileObject;
        this.targetFolder = fileObject2;
        this.paste = pasteType;
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            FileObject fileObject = this.targetFolder != null ? this.targetFolder : this.resource.getParent();
            this.panel = new CopyClassPanel(changeListener, this.getName() + " - " + this.resource.getName(), RetoucheUtils.getPackageName(fileObject), fileObject, this.resource.getName());
            this.panel.setCombosEnabled(this.targetFolder == null);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.setupRefactoring();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (this.panel == null) {
            return null;
        }
        this.setupRefactoring();
        return this.refactoring.fastCheckParameters();
    }

    private void setupRefactoring() {
        this.refactoring.setNewName(this.panel.getNewName());
        URL uRL = URLMapper.findURL((FileObject)this.panel.getRootFolder(), (int)1);
        try {
            this.refactoring.setTarget(Lookups.singleton((Object)new URL(uRL.toExternalForm() + "/" + this.panel.getPackageName().replace('.', '/'))));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(CopyClassRefactoringUI.class, (String)"DSC_CopyClass", (Object)this.refactoring.getNewName());
    }

    public String getName() {
        return NbBundle.getMessage(CopyClassRefactoringUI.class, (String)"LBL_CopyClass");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CopyClassRefactoringUI.class.getName());
    }

    public boolean isRefactoringBypassRequired() {
        if (this.panel == null) {
            return false;
        }
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        FileObject fileObject = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
        FileObject fileObject2 = RetoucheUtils.getOrCreateFolder((URL)this.refactoring.getTarget().lookup(URL.class));
        if (fileObject != null) {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject2);
            dataObject.copy(dataFolder).rename(this.panel.getNewName());
        }
    }
}

