/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.refactoring.java.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.EncapsulateFieldsRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncapsulateFieldsPlugin
extends JavaRefactoringPlugin {
    private List<EncapsulateFieldRefactoringPlugin> refactorings;
    private final EncapsulateFieldsRefactoring refactoring;
    private ProgressListener listener = new ProgressListener(){

        public void start(ProgressEvent progressEvent) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStart(progressEvent.getOperationType(), progressEvent.getCount());
        }

        public void step(ProgressEvent progressEvent) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStep();
        }

        public void stop(ProgressEvent progressEvent) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStop();
        }
    };

    public EncapsulateFieldsPlugin(EncapsulateFieldsRefactoring encapsulateFieldsRefactoring) {
        this.refactoring = encapsulateFieldsRefactoring;
    }

    @Override
    protected Problem checkParameters(CompilationController compilationController) throws IOException {
        return this.validation(2, compilationController);
    }

    @Override
    public Problem fastCheckParameters() {
        Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> collection = this.refactoring.getRefactorFields();
        if (collection.isEmpty()) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"ERR_EncapsulateNothingSelected"));
        }
        this.initRefactorings(collection, this.refactoring.getMethodModifiers(), this.refactoring.getFieldModifiers(), this.refactoring.isAlwaysUseAccessors());
        try {
            return this.validation(1, null);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    protected Problem preCheck(CompilationController compilationController) throws IOException {
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        TreePath treePath = this.refactoring.getSelectedObject().resolve((CompilationInfo)compilationController);
        if (treePath == null) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"DSC_ElNotAvail"));
        }
        Element element = compilationController.getTrees().getElement(treePath);
        if (element != null && ElementKind.FIELD == element.getKind()) {
            TreePath treePath2 = compilationController.getTrees().getPath(element);
            if (treePath2 == null) {
                return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"DSC_ElNotAvail"));
            }
            TypeElement typeElement = (TypeElement)element.getEnclosingElement();
            if (ElementKind.INTERFACE == typeElement.getKind() || NestingKind.ANONYMOUS == typeElement.getNestingKind()) {
                return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"ERR_EncapsulateInIntf"));
            }
            return null;
        }
        TreePath treePath3 = RetoucheUtils.findEnclosingClass((CompilationInfo)compilationController, treePath, true, false, true, false, false);
        TypeElement typeElement = (TypeElement)compilationController.getTrees().getElement(treePath3);
        if (element != typeElement || typeElement == null) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"ERR_EncapsulateWrongType"));
        }
        if (ElementKind.INTERFACE == typeElement.getKind() || ElementKind.ANNOTATION_TYPE == typeElement.getKind() || NestingKind.ANONYMOUS == typeElement.getNestingKind()) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"ERR_EncapsulateInIntf"));
        }
        for (Element element2 : typeElement.getEnclosedElements()) {
            if (ElementKind.FIELD != element2.getKind()) continue;
            return null;
        }
        return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"ERR_EncapsulateNoFields", (Object)typeElement.getQualifiedName()));
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        EncapsulateFieldRefactoringPlugin encapsulateFieldRefactoringPlugin2;
        Problem problem = null;
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        ArrayList<EncapsulateFieldRefactoringPlugin.EncapsulateDesc> arrayList = new ArrayList<EncapsulateFieldRefactoringPlugin.EncapsulateDesc>(this.refactorings.size());
        for (EncapsulateFieldRefactoringPlugin encapsulateFieldRefactoringPlugin2 : this.refactorings) {
            if (this.cancelRequest) {
                return null;
            }
            EncapsulateFieldRefactoringPlugin.EncapsulateDesc encapsulateDesc = encapsulateFieldRefactoringPlugin2.prepareEncapsulator(problem);
            problem = encapsulateDesc.p;
            encapsulateDesc.p = null;
            if (problem != null && problem.isFatal()) {
                return problem;
            }
            arrayList.add(encapsulateDesc);
            hashSet.addAll(encapsulateDesc.refs);
        }
        EncapsulateFieldRefactoringPlugin.Encapsulator encapsulator = new EncapsulateFieldRefactoringPlugin.Encapsulator(arrayList, problem);
        encapsulateFieldRefactoringPlugin2 = this.createAndAddElements(hashSet, new JavaRefactoringPlugin.TransformTask(this, encapsulator, ((EncapsulateFieldRefactoringPlugin.EncapsulateDesc)arrayList.get((int)0)).fieldHandle), refactoringElementsBag, this.refactoring);
        problem = encapsulator.getProblem();
        return encapsulateFieldRefactoringPlugin2 != null ? encapsulateFieldRefactoringPlugin2 : problem;
    }

    private void initRefactorings(Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> collection, Set<Modifier> set, Set<Modifier> set2, boolean bl) {
        this.refactorings = new ArrayList<EncapsulateFieldRefactoringPlugin>(collection.size());
        for (EncapsulateFieldsRefactoring.EncapsulateFieldInfo encapsulateFieldInfo : collection) {
            EncapsulateFieldRefactoring encapsulateFieldRefactoring = new EncapsulateFieldRefactoring(encapsulateFieldInfo.getField());
            encapsulateFieldRefactoring.setGetterName(encapsulateFieldInfo.getGetterName());
            encapsulateFieldRefactoring.setSetterName(encapsulateFieldInfo.getSetterName());
            encapsulateFieldRefactoring.setMethodModifiers(set);
            encapsulateFieldRefactoring.setFieldModifiers(set2);
            encapsulateFieldRefactoring.setAlwaysUseAccessors(bl);
            this.refactorings.add(new EncapsulateFieldRefactoringPlugin(encapsulateFieldRefactoring));
        }
    }

    private Problem validation(int n, CompilationController compilationController) throws IOException {
        Problem problem = null;
        for (EncapsulateFieldRefactoringPlugin encapsulateFieldRefactoringPlugin : this.refactorings) {
            Problem problem2 = null;
            switch (n) {
                case 1: {
                    problem2 = encapsulateFieldRefactoringPlugin.fastCheckParameters();
                    break;
                }
                case 2: {
                    problem2 = encapsulateFieldRefactoringPlugin.preCheck(compilationController);
                    problem = EncapsulateFieldsPlugin.chainProblems(problem, problem2);
                    if (problem != null && problem.isFatal()) {
                        return problem;
                    }
                    problem2 = encapsulateFieldRefactoringPlugin.checkParameters(compilationController);
                    encapsulateFieldRefactoringPlugin.addProgressListener(this.listener);
                }
            }
            if ((problem = EncapsulateFieldsPlugin.chainProblems(problem, problem2)) == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    private static Problem chainProblems(Problem problem, Problem problem2) {
        if (problem == null) {
            return problem2;
        }
        if (problem2 == null) {
            return problem;
        }
        if (problem2.isFatal()) {
            problem2.setNext(problem);
            return problem2;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        TreePathHandle treePathHandle = this.refactoring.getSelectedObject();
        FileObject fileObject = treePathHandle.getFileObject();
        return JavaSource.forFileObject((FileObject)fileObject);
    }
}

