/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.plugins.ChangeParamsTransformer;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeParametersPlugin
extends JavaRefactoringPlugin {
    private ChangeParametersRefactoring refactoring;
    private TreePathHandle treePathHandle;
    private Set<ElementHandle<ExecutableElement>> allMethods;

    public ChangeParametersPlugin(ChangeParametersRefactoring changeParametersRefactoring) {
        this.refactoring = changeParametersRefactoring;
        this.treePathHandle = (TreePathHandle)changeParametersRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters(CompilationController compilationController) throws IOException {
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray = this.refactoring.getParameterInfo();
        Problem problem = null;
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            Object object;
            int n = parameterInfoArray[i].getOriginalIndex();
            if (n == -1) {
                object = parameterInfoArray[i].getName();
                if (object == null || ((String)object).length() < 1) {
                    problem = ChangeParametersPlugin.createProblem(problem, true, ChangeParametersPlugin.newParMessage("ERR_parname"));
                } else if (!Utilities.isJavaIdentifier((String)object)) {
                    problem = ChangeParametersPlugin.createProblem(problem, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_InvalidIdentifier", (Object)object));
                }
                String string = parameterInfoArray[i].getType();
                if (string == null) {
                    problem = ChangeParametersPlugin.createProblem(problem, true, ChangeParametersPlugin.newParMessage("ERR_partype"));
                }
                if ((object = parameterInfoArray[i].getDefaultValue()) == null || ((String)object).length() < 1) {
                    problem = ChangeParametersPlugin.createProblem(problem, true, ChangeParametersPlugin.newParMessage("ERR_pardefv"));
                }
            }
            if (((ChangeParametersRefactoring.ParameterInfo)(object = parameterInfoArray[i])).getType() == null || !((ChangeParametersRefactoring.ParameterInfo)object).getType().endsWith("...") || i == parameterInfoArray.length - 1) continue;
            problem = ChangeParametersPlugin.createProblem(problem, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_VarargsFinalPosition", (Object[])new Object[0]));
        }
        return problem;
    }

    private static String newParMessage(String string) {
        return new MessageFormat(ChangeParametersPlugin.getString("ERR_newpar")).format(new Object[]{ChangeParametersPlugin.getString(string)});
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ChangeParametersPlugin.class, (String)string);
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo classpathInfo = this.getClasspathInfo(this.refactoring);
        final HashSet<FileObject> hashSet = new HashSet<FileObject>();
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getFileObject()});
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController compilationController) throws Exception {
                    ElementHandle elementHandle;
                    ClassIndex classIndex = compilationController.getClasspathInfo().getClassIndex();
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    TreePathHandle treePathHandle = (TreePathHandle)ChangeParametersPlugin.this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
                    Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                    ElementHandle elementHandle2 = ElementHandle.create((Element)SourceUtils.getEnclosingTypeElement((Element)element));
                    ChangeParametersPlugin.this.allMethods = new HashSet();
                    ChangeParametersPlugin.this.allMethods.add(ElementHandle.create((Element)((ExecutableElement)element)));
                    for (ExecutableElement executableElement : RetoucheUtils.getOverridingMethods((ExecutableElement)element, (CompilationInfo)compilationController)) {
                        hashSet.add(SourceUtils.getFile((Element)executableElement, (ClasspathInfo)compilationController.getClasspathInfo()));
                        elementHandle = ElementHandle.create((Element)SourceUtils.getEnclosingTypeElement((Element)executableElement));
                        hashSet.addAll(classIndex.getResources(elementHandle, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        ChangeParametersPlugin.this.allMethods.add(ElementHandle.create((Element)executableElement));
                    }
                    for (ExecutableElement executableElement : RetoucheUtils.getOverridenMethods((ExecutableElement)element, (CompilationInfo)compilationController)) {
                        hashSet.add(SourceUtils.getFile((Element)executableElement, (ClasspathInfo)compilationController.getClasspathInfo()));
                        elementHandle = ElementHandle.create((Element)SourceUtils.getEnclosingTypeElement((Element)executableElement));
                        hashSet.addAll(classIndex.getResources(elementHandle, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        ChangeParametersPlugin.this.allMethods.add(ElementHandle.create((Element)executableElement));
                    }
                    hashSet.addAll(classIndex.getResources(elementHandle2, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    hashSet.add(SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo()));
                }
            }, true);
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
        return hashSet;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        JavaRefactoringPlugin.TransformTask transformTask;
        Problem problem;
        Set<FileObject> set = this.getRelevantFiles();
        this.fireProgressListenerStart(1, set.size());
        if (!set.isEmpty() && (problem = this.createAndAddElements(set, transformTask = new JavaRefactoringPlugin.TransformTask(this, new ChangeParamsTransformer(this.refactoring, this.allMethods), this.treePathHandle), refactoringElementsBag, this.refactoring)) != null) {
            this.fireProgressListenerStop();
            return problem;
        }
        this.fireProgressListenerStop();
        return null;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        switch (phase) {
            case CHECKPARAMETERS: 
            case FASTCHECKPARAMETERS: 
            case PRECHECK: {
                ClasspathInfo classpathInfo = this.getClasspathInfo(this.refactoring);
                return JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
            }
        }
        return null;
    }

    @Override
    public Problem preCheck(CompilationController compilationController) throws IOException {
        this.fireProgressListenerStart(1, 4);
        Problem problem = null;
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        problem = ChangeParametersPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)compilationController);
        if (problem != null) {
            return problem;
        }
        Element element = this.treePathHandle.resolveElement((CompilationInfo)compilationController);
        if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR) {
            problem = ChangeParametersPlugin.createProblem(problem, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_ChangeParamsWrongType"));
            return problem;
        }
        FileObject fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo());
        if (RetoucheUtils.isFromLibrary(element, compilationController.getClasspathInfo())) {
            problem = ChangeParametersPlugin.createProblem(problem, true, ChangeParametersPlugin.getCannotRefactor(fileObject));
        }
        if (!RetoucheUtils.isElementInOpenProject(fileObject)) {
            problem = new Problem(true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_ProjectNotOpened"));
            return problem;
        }
        if (SourceUtils.getEnclosingTypeElement((Element)element).getKind() == ElementKind.ANNOTATION_TYPE) {
            problem = new Problem(true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_MethodsInAnnotationsNotSupported"));
            return problem;
        }
        for (ExecutableElement executableElement : RetoucheUtils.getOverridenMethods((ExecutableElement)element, (CompilationInfo)compilationController)) {
            if (!RetoucheUtils.isFromLibrary(executableElement, compilationController.getClasspathInfo())) continue;
            problem = ChangeParametersPlugin.createProblem(problem, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_CannnotRefactorLibrary", (Object)element));
        }
        this.fireProgressListenerStop();
        return problem;
    }

    private static final String getCannotRefactor(FileObject fileObject) {
        return new MessageFormat(NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_CannotRefactorFile")).format(new Object[]{fileObject.getName()});
    }
}

