/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetoucheUtils {
    private static final String JAVA_MIME_TYPE = "text/x-java";
    public static volatile boolean cancel = false;
    private static final Logger LOG = Logger.getLogger(RetoucheUtils.class.getName());
    private static Dialog waitDialog = null;
    private static RequestProcessor.Task waitTask = null;

    public static String htmlize(String string) {
        String string2 = Utilities.replaceString((String)string, (String)"<", (String)"&lt;");
        string2 = Utilities.replaceString((String)string2, (String)">", (String)"&gt;");
        return string2;
    }

    public static Collection<ExecutableElement> getOverridenMethods(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        return RetoucheUtils.getOverridenMethods(executableElement, SourceUtils.getEnclosingTypeElement((Element)executableElement), compilationInfo);
    }

    private static Collection<ExecutableElement> getOverridenMethods(ExecutableElement executableElement, TypeElement typeElement, CompilationInfo compilationInfo) {
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            TypeElement typeElement2 = (TypeElement)((DeclaredType)typeMirror).asElement();
            ExecutableElement annotatedConstruct = RetoucheUtils.getMethod(executableElement, typeElement2, compilationInfo);
            arrayList.addAll(RetoucheUtils.getOverridenMethods(executableElement, typeElement2, compilationInfo));
            if (annotatedConstruct != null) {
                arrayList.add(annotatedConstruct);
            }
        }
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            TypeElement typeElement2 = (TypeElement)((DeclaredType)typeMirror2).asElement();
            ExecutableElement executableElement2 = RetoucheUtils.getMethod(executableElement, typeElement2, compilationInfo);
            arrayList.addAll(RetoucheUtils.getOverridenMethods(executableElement, typeElement2, compilationInfo));
            if (executableElement2 == null) continue;
            arrayList.add(executableElement2);
        }
        return arrayList;
    }

    private static ExecutableElement getMethod(ExecutableElement executableElement, TypeElement typeElement, CompilationInfo compilationInfo) {
        for (ExecutableElement executableElement2 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!compilationInfo.getElements().overrides(executableElement, executableElement2, typeElement)) continue;
            return executableElement2;
        }
        return null;
    }

    public static Set<ElementHandle<TypeElement>> getImplementorsAsHandles(ClassIndex classIndex, ClasspathInfo classpathInfo, TypeElement typeElement) {
        cancel = false;
        ClassPath classPath = classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        LinkedList linkedList = new LinkedList(classIndex.getElements(ElementHandle.create((Element)typeElement), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES)));
        HashSet<ElementHandle<TypeElement>> hashSet = new HashSet<ElementHandle<TypeElement>>();
        while (!linkedList.isEmpty()) {
            if (cancel) {
                cancel = false;
                return Collections.emptySet();
            }
            ElementHandle elementHandle = (ElementHandle)linkedList.removeFirst();
            FileObject fileObject = SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)classpathInfo);
            if (fileObject != null && classPath.contains(fileObject)) {
                hashSet.add((ElementHandle<TypeElement>)elementHandle);
            }
            linkedList.addAll(classIndex.getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES)));
        }
        return hashSet;
    }

    public static Collection<ExecutableElement> getOverridingMethods(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        Set<ElementHandle<TypeElement>> set = RetoucheUtils.getImplementorsAsHandles(compilationInfo.getClasspathInfo().getClassIndex(), compilationInfo.getClasspathInfo(), typeElement);
        for (ElementHandle<TypeElement> elementHandle : set) {
            TypeElement typeElement2 = (TypeElement)elementHandle.resolve(compilationInfo);
            if (typeElement2 == null && LOG.isLoggable(Level.INFO)) {
                FileObject fileObject = SourceUtils.getFile(elementHandle, (ClasspathInfo)compilationInfo.getClasspathInfo());
                LOG.log(Level.INFO, "#120577: Cannot resolve " + elementHandle + "; file: " + fileObject);
            }
            for (ExecutableElement executableElement2 : ElementFilter.methodsIn(typeElement2.getEnclosedElements())) {
                if (!compilationInfo.getElements().overrides(executableElement2, executableElement, typeElement2)) continue;
                arrayList.add(executableElement2);
            }
        }
        return arrayList;
    }

    public static boolean isJavaFile(FileObject fileObject) {
        return JAVA_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static String getHtml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, (Language)JavaTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)JAVA_MIME_TYPE));
        FontColorSettings fontColorSettings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            String string2 = ((JavaTokenId)token.id()).primaryCategory();
            if (string2 == null) {
                string2 = "whitespace";
            }
            AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string2);
            stringBuffer.append(RetoucheUtils.color(RetoucheUtils.htmlize(((Object)token.text()).toString()), attributeSet));
        }
        return stringBuffer.toString();
    }

    private static String color(String string, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return Utilities.replaceString((String)Utilities.replaceString((String)string, (String)" ", (String)"&nbsp;"), (String)"\n", (String)"<br>");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (StyleConstants.isBold(attributeSet)) {
            stringBuffer.insert(0, "<b>");
            stringBuffer.append("</b>");
        }
        if (StyleConstants.isItalic(attributeSet)) {
            stringBuffer.insert(0, "<i>");
            stringBuffer.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(attributeSet)) {
            stringBuffer.insert(0, "<s>");
            stringBuffer.append("</s>");
        }
        stringBuffer.insert(0, "<font color=" + RetoucheUtils.getHTMLColor(StyleConstants.getForeground(attributeSet)) + ">");
        stringBuffer.append("</font>");
        return stringBuffer.toString();
    }

    private static String getHTMLColor(Color color) {
        String string = "0" + Integer.toHexString(color.getRed());
        string = string.substring(string.length() - 2);
        String string2 = "0" + Integer.toHexString(color.getGreen());
        string2 = string2.substring(string2.length() - 2);
        String string3 = "0" + Integer.toHexString(color.getBlue());
        string3 = string3.substring(string3.length() - 2);
        String string4 = "#" + string + string2 + string3;
        return string4;
    }

    public static boolean isElementInOpenProject(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isFromLibrary(Element element, ClasspathInfo classpathInfo) {
        FileObject fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)classpathInfo);
        if (fileObject == null) {
            return true;
        }
        return FileUtil.getArchiveFile((FileObject)fileObject) != null;
    }

    public static boolean isValidPackageName(String string) {
        if (string.endsWith(".")) {
            return false;
        }
        if (string.startsWith(".")) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            if (Utilities.isJavaIdentifier((String)stringTokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileInOpenProject(FileObject fileObject) {
        assert (fileObject != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnSourceClasspath(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        if (!Arrays.asList(projectArray).contains(project)) {
            return false;
        }
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source") != null;
    }

    public static boolean isClasspathRoot(FileObject fileObject) {
        return fileObject.equals(ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject));
    }

    public static boolean isRefactorable(FileObject fileObject) {
        return RetoucheUtils.isJavaFile(fileObject) && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject);
    }

    public static String getPackageName(FileObject fileObject) {
        assert (fileObject.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
    }

    public static String getPackageName(CompilationUnitTree compilationUnitTree) {
        assert (compilationUnitTree != null);
        ExpressionTree expressionTree = compilationUnitTree.getPackageName();
        if (expressionTree == null) {
            return "";
        }
        return expressionTree.toString();
    }

    public static String getPackageName(URL uRL) {
        String string;
        File file = null;
        try {
            string = URLDecoder.decode(uRL.getPath(), "utf-8");
            file = FileUtil.normalizeFile((File)new File(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Cannot create package name for url " + uRL);
        }
        string = "";
        do {
            FileObject fileObject;
            if ((fileObject = FileUtil.toFileObject((File)file)) != null) {
                if ("".equals(string)) {
                    return RetoucheUtils.getPackageName(fileObject);
                }
                String string2 = RetoucheUtils.getPackageName(fileObject);
                return string2 + ("".equals(string2) ? "" : ".") + string;
            }
            if (!"".equals(string)) {
                string = "." + string;
            }
            try {
                string = URLDecoder.decode(file.getPath().substring(file.getPath().lastIndexOf(File.separatorChar) + 1), "utf-8") + string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException("Cannot create package name for url " + uRL);
            }
        } while ((file = file.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + uRL);
    }

    public static FileObject getOrCreateFolder(URL uRL) throws IOException {
        try {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject != null) {
                return fileObject;
            }
            File file = new File(uRL.toURI());
            fileObject = FileUtil.createFolder((File)file);
            return fileObject;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IOException)new IOException().initCause(uRISyntaxException);
        }
    }

    public static FileObject getClassPathRoot(URL uRL) throws IOException {
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        File file = FileUtil.normalizeFile((File)new File(URLDecoder.decode(uRL.getPath())));
        while (fileObject == null) {
            fileObject = FileUtil.toFileObject((File)file);
            file = file.getParentFile();
        }
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject);
    }

    public static Collection<TypeElement> getSuperTypes(TypeElement typeElement, CompilationInfo compilationInfo) {
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        LinkedList<TypeElement> linkedList = new LinkedList<TypeElement>();
        linkedList.add(typeElement);
        while (!linkedList.isEmpty()) {
            TypeElement typeElement2 = (TypeElement)linkedList.removeFirst();
            TypeElement typeElement3 = RetoucheUtils.typeToElement(typeElement2.getSuperclass(), compilationInfo);
            if (typeElement3 != null) {
                hashSet.add(typeElement3);
                linkedList.addLast(typeElement3);
            }
            Collection<TypeElement> collection = RetoucheUtils.typesToElements(typeElement2.getInterfaces(), compilationInfo);
            hashSet.addAll(collection);
            linkedList.addAll(collection);
        }
        return hashSet;
    }

    public static Collection<FileObject> getSuperTypesFiles(TreePathHandle treePathHandle) {
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
            SuperTypesTask superTypesTask = new SuperTypesTask(treePathHandle);
            javaSource.runUserActionTask((Task)superTypesTask, true);
            return superTypesTask.getFileObjects();
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
    }

    public static Collection<TypeElement> getSuperTypes(TypeElement typeElement, CompilationInfo compilationInfo, boolean bl) {
        if (!bl) {
            return RetoucheUtils.getSuperTypes(typeElement, compilationInfo);
        }
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        for (TypeElement typeElement2 : RetoucheUtils.getSuperTypes(typeElement, compilationInfo)) {
            FileObject fileObject = SourceUtils.getFile((Element)typeElement2, (ClasspathInfo)compilationInfo.getClasspathInfo());
            if (fileObject == null || !RetoucheUtils.isFileInOpenProject(fileObject) || RetoucheUtils.isFromLibrary(typeElement2, compilationInfo.getClasspathInfo())) continue;
            hashSet.add(typeElement2);
        }
        return hashSet;
    }

    public static TypeElement typeToElement(TypeMirror typeMirror, CompilationInfo compilationInfo) {
        return (TypeElement)compilationInfo.getTypes().asElement(typeMirror);
    }

    private static Collection<TypeElement> typesToElements(Collection<? extends TypeMirror> collection, CompilationInfo compilationInfo) {
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        for (TypeMirror typeMirror : collection) {
            hashSet.add(RetoucheUtils.typeToElement(typeMirror, compilationInfo));
        }
        return hashSet;
    }

    public static Collection<FileObject> elementsToFile(Collection<? extends Element> collection, ClasspathInfo classpathInfo) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        for (Element element : collection) {
            hashSet.add(SourceUtils.getFile((Element)element, (ClasspathInfo)classpathInfo));
        }
        return hashSet;
    }

    public static boolean elementExistsIn(TypeElement typeElement, Element element, CompilationInfo compilationInfo) {
        for (Element element2 : typeElement.getEnclosedElements()) {
            if (compilationInfo.getElements().hides(element, element2) || compilationInfo.getElements().hides(element2, element)) {
                return true;
            }
            if (!(element instanceof ExecutableElement) || !(element2 instanceof ExecutableElement) || !compilationInfo.getElements().overrides((ExecutableElement)element, (ExecutableElement)element2, typeElement) && !compilationInfo.getElements().overrides((ExecutableElement)element2, (ExecutableElement)element, typeElement)) continue;
            return true;
        }
        return false;
    }

    public static ElementHandle getElementHandle(TreePathHandle treePathHandle) {
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
            CompilerTask compilerTask = new CompilerTask(treePathHandle);
            javaSource.runUserActionTask((Task)compilerTask, true);
            return compilerTask.getElementHandle();
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
    }

    public static ElementKind getElementKind(TreePathHandle treePathHandle) {
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
            CompilerTask compilerTask = new CompilerTask(treePathHandle);
            javaSource.runUserActionTask((Task)compilerTask, true);
            return compilerTask.getElementKind();
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
    }

    public static String getSimpleName(TreePathHandle treePathHandle) {
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
            CompilerTask compilerTask = new CompilerTask(treePathHandle);
            javaSource.runUserActionTask((Task)compilerTask, true);
            return compilerTask.getSimpleName();
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
    }

    public static FileObject getFileObject(TreePathHandle treePathHandle) {
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
            CompilerTask compilerTask = new CompilerTask(treePathHandle);
            javaSource.runUserActionTask((Task)compilerTask, true);
            return compilerTask.getFileObject();
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
    }

    public static String getQualifiedName(TreePathHandle treePathHandle) {
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
            CompilerTask compilerTask = new CompilerTask(treePathHandle);
            javaSource.runUserActionTask((Task)compilerTask, true);
            return compilerTask.getQualifiedName();
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
    }

    public static boolean typeExist(TreePathHandle treePathHandle, String string) {
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
            CompilerTask compilerTask = new CompilerTask(treePathHandle, string);
            javaSource.runUserActionTask((Task)compilerTask, true);
            return compilerTask.typeExist();
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
    }

    public static ClasspathInfo getClasspathInfoFor(FileObject ... fileObjectArray) {
        return RetoucheUtils.getClasspathInfoFor(true, fileObjectArray);
    }

    public static ClasspathInfo getClasspathInfoFor(boolean bl, FileObject ... fileObjectArray) {
        return RetoucheUtils.getClasspathInfoFor(bl, false, fileObjectArray);
    }

    public static ClasspathInfo getClasspathInfoFor(boolean bl, boolean bl2, FileObject ... classPath) {
        Project project;
        FileObject fileObject2;
        assert (((FileObject[])classPath).length > 0);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (FileObject fileObject2 : classPath) {
            project = null;
            Object object = null;
            if (fileObject2 != null) {
                project = FileOwnerQuery.getOwner((FileObject)fileObject2);
                object = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source").findOwnerRoot(fileObject2);
            }
            if (project != null && object != null) {
                Object object2 = URLMapper.findURL(object, (int)0);
                if (bl) {
                    hashSet.addAll(SourceUtils.getDependentRoots((URL)object2));
                } else {
                    hashSet.add(object2);
                }
                for (SourceForBinaryQuery.Result result : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
                    hashSet.add(URLMapper.findURL((FileObject)result.getRootFolder(), (int)0));
                }
                continue;
            }
            for (SourceForBinaryQuery.Result result : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                for (FileObject fileObject3 : result.getRoots()) {
                    hashSet.add(URLMapper.findURL((FileObject)fileObject3, (int)0));
                }
            }
        }
        if (bl2) {
            for (FileObject fileObject2 : classPath) {
                if (fileObject2 == null) continue;
                project = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/compile");
                for (Object object2 : project.entries()) {
                    SourceForBinaryQuery.Result result;
                    result = SourceForBinaryQuery.findSourceRoots((URL)object2.getURL());
                    for (FileObject fileObject3 : result.getRoots()) {
                        hashSet.add(URLMapper.findURL((FileObject)fileObject3, (int)0));
                    }
                }
            }
        }
        ClassPath classPath2 = ClassPathSupport.createClassPath((URL[])hashSet.toArray(new URL[hashSet.size()]));
        ClassPath classPath3 = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath classPath4 = classPath[0] != null ? ClassPath.getClassPath((FileObject)classPath[0], (String)"classpath/boot") : classPath3;
        fileObject2 = classPath[0] != null ? ClassPath.getClassPath((FileObject)classPath[0], (String)"classpath/compile") : classPath3;
        project = ClasspathInfo.create((ClassPath)classPath4, (ClassPath)fileObject2, (ClassPath)classPath2);
        return project;
    }

    public static ClasspathInfo getClasspathInfoFor(TreePathHandle ... treePathHandleArray) {
        FileObject[] fileObjectArray = new FileObject[treePathHandleArray.length];
        int n = 0;
        for (TreePathHandle treePathHandle : treePathHandleArray) {
            FileObject fileObject = RetoucheUtils.getFileObject(treePathHandle);
            if (n == 0 && fileObject == null) {
                fileObjectArray = new FileObject[treePathHandleArray.length + 1];
                fileObjectArray[n++] = treePathHandle.getFileObject();
            }
            fileObjectArray[n++] = fileObject;
        }
        return RetoucheUtils.getClasspathInfoFor(fileObjectArray);
    }

    public static void findUsedGenericTypes(Types types, List<TypeMirror> list, List<TypeMirror> list2, TypeMirror typeMirror) {
        if (list.isEmpty()) {
            return;
        }
        if (typeMirror.getKind() == TypeKind.TYPEVAR) {
            int n;
            TypeMirror typeMirror2;
            TypeVariable typeVariable = (TypeVariable)typeMirror;
            TypeMirror typeMirror3 = typeVariable.getLowerBound();
            if (typeMirror3 != null && typeMirror3.getKind() != TypeKind.NULL) {
                RetoucheUtils.findUsedGenericTypes(types, list, list2, typeMirror3);
            }
            if ((typeMirror2 = typeVariable.getUpperBound()) != null) {
                RetoucheUtils.findUsedGenericTypes(types, list, list2, typeMirror2);
            }
            if ((n = RetoucheUtils.findTypeIndex(types, list, typeVariable)) >= 0) {
                list2.add(list.remove(n));
            }
        } else if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            for (TypeMirror typeMirror4 : declaredType.getTypeArguments()) {
                RetoucheUtils.findUsedGenericTypes(types, list, list2, typeMirror4);
            }
        } else if (typeMirror.getKind() == TypeKind.WILDCARD) {
            TypeMirror typeMirror5;
            WildcardType wildcardType = (WildcardType)typeMirror;
            TypeMirror typeMirror6 = wildcardType.getExtendsBound();
            if (typeMirror6 != null) {
                RetoucheUtils.findUsedGenericTypes(types, list, list2, typeMirror6);
            }
            if ((typeMirror5 = wildcardType.getSuperBound()) != null) {
                RetoucheUtils.findUsedGenericTypes(types, list, list2, typeMirror5);
            }
        }
    }

    private static int findTypeIndex(Types types, List<TypeMirror> list, TypeMirror typeMirror) {
        int n = -1;
        for (TypeMirror typeMirror2 : list) {
            ++n;
            if (!types.isSameType(typeMirror, typeMirror2)) continue;
            return n;
        }
        return -1;
    }

    public static List<TypeMirror> resolveTypeParamsAsTypes(List<? extends Element> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(list.size());
        for (Element element : list) {
            arrayList.add(element.asType());
        }
        return arrayList;
    }

    public static TreePath findEnclosingClass(CompilationInfo compilationInfo, TreePath treePath, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Tree tree = treePath.getLeaf();
        TreeUtilities treeUtilities = compilationInfo.getTreeUtilities();
        while (true) {
            if (Tree.Kind.CLASS == tree.getKind()) {
                ClassTree classTree = (ClassTree)tree;
                if (bl3 && treeUtilities.isEnum(classTree) || bl2 && treeUtilities.isInterface(classTree) || bl4 && treeUtilities.isAnnotation(classTree) || bl && !treeUtilities.isInterface(classTree) && !treeUtilities.isEnum(classTree) && !treeUtilities.isAnnotation(classTree)) {
                    Tree.Kind kind = treePath.getParentPath().getLeaf().getKind();
                    if (bl5 || Tree.Kind.NEW_CLASS != kind) break;
                }
            }
            if ((treePath = treePath.getParentPath()) == null) {
                tree = compilationInfo.getCompilationUnit().getTypeDecls().get(0);
                treePath = compilationInfo.getTrees().getPath(compilationInfo.getCompilationUnit(), tree);
                break;
            }
            tree = treePath.getLeaf();
        }
        return treePath;
    }

    public static void copyJavadoc(Element element, Tree tree, WorkingCopy workingCopy) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        String string = workingCopy.getElements().getDocComment(element);
        if (string != null) {
            treeMaker.addComment(tree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-1, (int)-1, (int)-1, (String)string), true);
        }
    }

    public static boolean invokeAfterScanFinished(Runnable runnable, String string) {
        assert (SwingUtilities.isEventDispatchThread());
        if (SourceUtils.isScanInProgress()) {
            final ActionPerformer actionPerformer = new ActionPerformer(runnable);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    actionPerformer.cancel();
                    waitTask.cancel();
                }
            };
            JLabel jLabel = new JLabel(RetoucheUtils.getString("MSG_WaitScan"), UIManager.getIcon("OptionPane.informationIcon"), 2);
            jLabel.setBorder(new EmptyBorder(12, 12, 11, 11));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jLabel, string, true, new Object[]{RetoucheUtils.getString("LBL_CancelAction", new Object[]{string})}, null, 0, null, actionListener);
            waitDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            waitDialog.pack();
            waitTask = RequestProcessor.getDefault().post((Runnable)actionPerformer, 100);
            waitDialog.setVisible(true);
            waitTask = null;
            waitDialog = null;
            return actionPerformer.hasBeenCancelled();
        }
        runnable.run();
        return false;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(RetoucheUtils.class, (String)string);
    }

    private static String getString(String string, Object object) {
        return new MessageFormat(RetoucheUtils.getString(string)).format(object);
    }

    private static class ActionPerformer
    implements Runnable {
        private Runnable action;
        private boolean cancel = false;

        ActionPerformer(Runnable runnable) {
            this.action = runnable;
        }

        public boolean hasBeenCancelled() {
            return this.cancel;
        }

        public void run() {
            try {
                SourceUtils.waitScanFinished();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!ActionPerformer.this.cancel) {
                        if (waitDialog != null) {
                            waitDialog.setVisible(false);
                        }
                        ActionPerformer.this.action.run();
                    }
                }
            });
        }

        public void cancel() {
            assert (SwingUtilities.isEventDispatchThread());
            if (waitDialog != null) {
                this.cancel = true;
                waitDialog.setVisible(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuperTypesTask
    implements CancellableTask<CompilationController> {
        private Collection<FileObject> files;
        TreePathHandle handle;

        SuperTypesTask(TreePathHandle treePathHandle) {
            this.handle = treePathHandle;
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) {
            try {
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
            }
            catch (IOException iOException) {
                throw (RuntimeException)new RuntimeException().initCause(iOException);
            }
            Element element = this.handle.resolveElement((CompilationInfo)compilationController);
            this.files = RetoucheUtils.elementsToFile(RetoucheUtils.getSuperTypes((TypeElement)element, (CompilationInfo)compilationController, true), compilationController.getClasspathInfo());
        }

        public Collection<FileObject> getFileObjects() {
            return this.files;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompilerTask
    implements CancellableTask<CompilationController> {
        private FileObject f;
        private ElementHandle eh;
        private String name;
        private String fqn;
        private String typeToCheck;
        private boolean typeExist;
        private ElementHandle<TypeElement> enclosingTypeHandle;
        private ElementKind kind;
        private IllegalArgumentException iae;
        TreePathHandle handle;

        CompilerTask(TreePathHandle treePathHandle) {
            this.handle = treePathHandle;
        }

        CompilerTask(TreePathHandle treePathHandle, String string) {
            this(treePathHandle);
            this.typeToCheck = string;
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) {
            try {
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
            }
            catch (IOException iOException) {
                throw (RuntimeException)new RuntimeException().initCause(iOException);
            }
            Element element = this.handle.resolveElement((CompilationInfo)compilationController);
            this.f = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo());
            try {
                this.eh = ElementHandle.create((Element)element);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.iae = illegalArgumentException;
            }
            this.name = element.getSimpleName().toString();
            if (element instanceof TypeElement) {
                this.fqn = ((TypeElement)element).getQualifiedName().toString();
            }
            if (this.typeToCheck != null) {
                this.typeExist = compilationController.getElements().getTypeElement(this.typeToCheck) != null;
            }
            this.enclosingTypeHandle = element instanceof TypeElement ? ElementHandle.create((Element)((TypeElement)element)) : ElementHandle.create((Element)SourceUtils.getEnclosingTypeElement((Element)element));
            this.kind = element.getKind();
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public ElementHandle getElementHandle() {
            return this.eh;
        }

        public String getSimpleName() {
            return this.name;
        }

        public String getQualifiedName() {
            return this.fqn;
        }

        public boolean typeExist() {
            return this.typeExist;
        }

        public ElementHandle<TypeElement> getEnclosingTypeHandle() {
            if (this.iae != null) {
                throw this.iae;
            }
            return this.enclosingTypeHandle;
        }

        public ElementKind getElementKind() {
            return this.kind;
        }
    }
}

