/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.utils;

import java.awt.Dialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.dataconnectivity.ui.DatasourceUISettings;
import org.netbeans.modules.visualweb.dataconnectivity.ui.MissingConnectionsAlertPanel;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class ImportDataSource {
    private static File curImportDir = null;
    private static String[] srcPaths = new String[]{".Creator/2_0/context.xml", ".Creator/2_0/jdbc-drivers", ".Creator/2_1/context.xml", ".Creator/2_1/jdbc-drivers", ".netbeans/5.5/context.xml", ".netbeans/5.5/jdbc-drivers", ".netbeans/5.5.1/context.xml", ".netbeans/5.5.1/jdbc-drivers"};
    private static String[] destPaths = new String[]{"migrated/2_0/context.xml", "jdbc-drivers", "migrated/2_1/context.xml", "jdbc-drivers", "migrated/5_5/context.xml", "jdbc-drivers", "migrated/5_5_1/context.xml", "jdbc-drivers"};
    private static File currentUserdir = ImportDataSource.getCurrentUserdir();
    private static final int CREATOR2 = 0;
    private static final int CREATOR2U1 = 2;
    private static final int VWP55 = 4;
    private static final int VWP551 = 6;
    private static final String config = "config";
    private static long brokenAlertLastTime = 0L;
    private static boolean brokenAlertShown = false;
    private static int BROKEN_ALERT_TIMEOUT = 1000;

    private static File getCurrentUserdir() {
        if (currentUserdir == null) {
            currentUserdir = InstalledFileLocator.getDefault().locate(config, null, false).getParentFile();
        }
        return currentUserdir;
    }

    public static boolean isMigrated() {
        File file = new File(currentUserdir.getAbsolutePath() + File.separator + config + File.separator + "migrated");
        return file != null && file.exists() && file.isDirectory();
    }

    public static boolean isMigrated(String string) {
        File file = new File(currentUserdir.getAbsolutePath() + File.separator + string);
        return file.exists();
    }

    public static boolean isMigrated(int n) {
        File file = new File(currentUserdir.getAbsolutePath() + File.separator + config + File.separator + destPaths[n]);
        return file.exists();
    }

    public static void prepareCopy() throws IOException {
        if (ImportDataSource.isMigrated()) {
            return;
        }
        String string = System.getProperty("user.home");
        if (string == null) {
            return;
        }
        File file = ImportDataSource.getCurrentUserdir();
        for (int i = 0; i < srcPaths.length; ++i) {
            File file2 = new File(string + File.separator + srcPaths[i]);
            File file3 = destPaths[i].equals("jdbc-drivers") ? new File(file.getAbsolutePath() + File.separator + destPaths[i]) : new File(file.getAbsolutePath() + File.separator + config + File.separator + destPaths[i]);
            System.out.println("src [" + i + "]:" + file2.getAbsolutePath());
            System.out.println("dest [" + i + "]:" + file3.getAbsolutePath());
            if (file3.exists() && (i == 0 || i == 2 || i == 4 || i == 6)) {
                ++i;
                System.out.println("this should never happen now");
                continue;
            }
            if (!file2.exists()) continue;
            File file4 = file3.getParentFile();
            if (!file4.exists()) {
                file4.mkdirs();
            }
            if (file2.isDirectory()) {
                ImportDataSource.copyDirectory(file2, file3);
                continue;
            }
            if (!file2.isFile()) continue;
            boolean bl = false;
            if (file3.getName().equals("build.properties")) {
                bl = true;
            }
            ImportDataSource.copy(file2, file3, bl);
        }
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                ImportDataSource.copyDirectory(new File(file, stringArray[i]), new File(file2, stringArray[i]));
            }
        } else {
            ImportDataSource.copy(file, file2, false);
        }
    }

    public static void copy(File file, File file2, boolean bl) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2, bl);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    public static boolean isLegacyProject(Project project) {
        boolean bl = false;
        if (JsfProjectUtils.getProjectVersion((Project)project).equals("2.0") || JsfProjectUtils.getProjectVersion((Project)project).equals("3.0")) {
            bl = true;
        }
        return bl;
    }

    public static synchronized void showAlert() {
        if (brokenAlertShown || brokenAlertLastTime + (long)BROKEN_ALERT_TIMEOUT > System.currentTimeMillis() || !DatasourceUISettings.getDefault().isShowAgainBrokenDatasourceAlert()) {
            return;
        }
        if (brokenAlertShown || brokenAlertLastTime + (long)BROKEN_ALERT_TIMEOUT > System.currentTimeMillis()) {
            return;
        }
        brokenAlertShown = true;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                try {
                    object = new MissingConnectionsAlertPanel();
                    JButton jButton = new JButton(NbBundle.getMessage(MissingConnectionsAlertPanel.class, (String)"LBL_UpdateDatasourcesCustomizer_Close"));
                    jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MissingConnectionsAlertPanel.class, (String)"ACSD_UpdateDatasourcesCustomizer_Close"));
                    DialogDescriptor dialogDescriptor = new DialogDescriptor(object, NbBundle.getMessage(MissingConnectionsAlertPanel.class, (String)"MSG_Update_Datasources_Title"), true, new Object[]{jButton}, (Object)jButton, 0, null, null);
                    dialogDescriptor.setMessageType(2);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                    dialog.setVisible(true);
                }
                finally {
                    object = MissingConnectionsAlertPanel.class;
                    synchronized (MissingConnectionsAlertPanel.class) {
                        brokenAlertLastTime = System.currentTimeMillis();
                        brokenAlertShown = false;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
            }
        });
    }
}

