/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.project.datasource;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.sql.RowSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.visualweb.api.j2ee.common.RequestedJdbcResource;
import org.netbeans.modules.visualweb.dataconnectivity.datasource.CurrentProject;
import org.netbeans.modules.visualweb.dataconnectivity.explorer.ProjectDataSourceNode;
import org.netbeans.modules.visualweb.dataconnectivity.naming.DesignTimeInitialContextFactory;
import org.netbeans.modules.visualweb.dataconnectivity.project.datasource.ProjectDataSourceChangeEvent;
import org.netbeans.modules.visualweb.dataconnectivity.project.datasource.ProjectDataSourceListener;
import org.netbeans.modules.visualweb.dataconnectivity.project.datasource.ProjectDataSourcesChangeEvent;
import org.netbeans.modules.visualweb.dataconnectivity.project.datasource.ProjectDataSourcesListener;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DesignTimeDataSource;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DesignTimeDataSourceHelper;
import org.netbeans.modules.visualweb.insync.Model;
import org.netbeans.modules.visualweb.insync.ModelSet;
import org.netbeans.modules.visualweb.insync.ModelSetListener;
import org.netbeans.modules.visualweb.insync.ModelSetsListener;
import org.netbeans.modules.visualweb.insync.live.LiveUnit;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.netbeans.modules.visualweb.insync.models.FacesModelSet;
import org.netbeans.modules.visualweb.project.jsf.services.RefreshService;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDataSourceTracker {
    private static final String DATASOURCE_PREFIX = "java:comp/env/";
    private static final String NON_DEFAULT_DATASOURCE_PREFIX = "java:/";
    private static final String HC_ELEMENT_NAME = "hardcoded-datasource-names";
    private static final String HC_ELEMENT_NAMESPACE = "http://creator.sun.com/project/datasources";
    private static final boolean HC_ELEMENT_SHARED = true;
    private static final String HC_ATTRIBUTE_NAME = "value";
    public static boolean isInitialContextInitialized = false;
    private HashMap<Project, DSTracker> trackers = new HashMap();
    protected ProjectTrackerContextListener insyncDataSourceListener = new ProjectTrackerContextListener();
    protected OpenProjectsListener openProjectsListener = new OpenProjectsListener();
    private static ProjectDataSourceTracker thisOne = new ProjectDataSourceTracker();
    private static final String LOGPREFIX = "PDST: ";
    private static ErrorManager err = ErrorManager.getDefault().getInstance("rave.dbdatasource");

    private ProjectDataSourceTracker() {
        ModelSet.addModelSetsListener((ModelSetsListener)this.insyncDataSourceListener);
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this.openProjectsListener);
    }

    public static ProjectDataSourceTracker getInstance() {
        return thisOne;
    }

    public static RequestedJdbcResource[] getProjectDataSourceInfo(Project project) throws NamingException {
        return ProjectDataSourceTracker.getDSTracker(project).getProjectDataSourceInfo();
    }

    public static void addListener(Project project, ProjectDataSourceListener projectDataSourceListener) {
        ProjectDataSourceTracker.getDSTracker(project).addListener(projectDataSourceListener);
    }

    public static void removeListener(Project project, ProjectDataSourceListener projectDataSourceListener) {
        ProjectDataSourceTracker.getDSTracker(project).removeListener(projectDataSourceListener);
    }

    public static void addListener(Project project, ProjectDataSourcesListener projectDataSourcesListener) {
        ProjectDataSourceTracker.getDSTracker(project).addListener(projectDataSourcesListener);
    }

    public static void removeListener(Project project, ProjectDataSourcesListener projectDataSourcesListener) {
        ProjectDataSourceTracker.getDSTracker(project).removeListener(projectDataSourcesListener);
    }

    public static void removeHardcodedDataSource(Project project, String string) {
        ProjectDataSourceTracker.getDSTracker(project).removeDataSource(string);
    }

    public static void addHardcodedDataSource(Project project, String string) {
        ProjectDataSourceTracker.getDSTracker(project).addHardcodedDataSource(string);
    }

    public static String[] getDynamicDataSources(Project project) {
        CurrentProject.getInstance().setProject(project);
        return ProjectDataSourceTracker.getDSTracker(project).getDynamicDataSources();
    }

    public static String[] getHardcodedDataSources(Project project) {
        return ProjectDataSourceTracker.getDSTracker(project).getHardcodedDataSources();
    }

    public static boolean isHardcodedDataSource(Project project, String string) {
        return ProjectDataSourceTracker.getDSTracker(project).isHardcodedDataSource(string);
    }

    public static String[] getFileDataSourceList(Project project) {
        return ProjectDataSourceTracker.getDSTracker(project).getFileDataSourceList();
    }

    public static void setResolvedDataSource(Project project, String string) {
        ProjectDataSourceTracker.getDSTracker(project).setResolvedDataSource(string);
    }

    public static String getResolvedDataSource(Project project) {
        return ProjectDataSourceTracker.getDSTracker(project).getResolvedDataSource();
    }

    public static Node getNode(Project project) {
        return ProjectDataSourceTracker.getDSTracker(project).getNode();
    }

    public static Project[] getProjects() {
        HashMap<Project, DSTracker> hashMap = ProjectDataSourceTracker.getInstance().trackers;
        return hashMap.keySet().toArray(new Project[hashMap.size()]);
    }

    public static void refreshDesignerForDataSources(String string) {
        RefreshService refreshService = RefreshService.getDefault();
        if (refreshService != null) {
            Project[] projectArray = ProjectDataSourceTracker.getProjects();
            for (int i = 0; i < projectArray.length; ++i) {
                refreshService.refresh(projectArray[i]);
            }
        }
    }

    public static synchronized DSTracker getDSTracker(Project project) {
        DSTracker dSTracker = null;
        dSTracker = ProjectDataSourceTracker.getInstance().trackers.get(project);
        if (dSTracker == null) {
            dSTracker = ProjectDataSourceTracker.getInstance().addDSTracker(project);
        }
        return dSTracker;
    }

    public static void refreshDataSources(Project project) {
        ProjectDataSourceTracker.getDSTracker(project).fireChangeEvent();
    }

    public static synchronized void refreshDataSourceReferences(Project project) {
        ProjectDataSourceTracker.getDSTracker(project).fireProjectDSReferencesChangeEvent();
    }

    public static boolean isProjectModeled(Project project) {
        Iterator<FileObject> iterator = ProjectDataSourceTracker.retrieveFileToModel(project).iterator();
        while (iterator.hasNext()) {
            if (FacesModelSet.getFacesModelIfAvailable((FileObject)iterator.next()) == null) continue;
            return true;
        }
        return false;
    }

    private DSTracker addDSTracker(Project project) {
        DSTracker dSTracker = new DSTracker(project);
        this.trackers.put(project, dSTracker);
        return dSTracker;
    }

    private static List<FileObject> retrieveFileToModel(Project project) {
        FileObject[] fileObjectArray = project.getProjectDirectory().getChildren();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (FileObject fileObject : fileObjectArray) {
            if (!fileObject.isFolder() || !fileObject.getName().equals("src")) continue;
            Enumeration enumeration = fileObject.getFolders(true);
            block1: while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                for (FileObject fileObject3 : fileObject2.getChildren()) {
                    if (!fileObject3.existsExt("java")) continue;
                    arrayList.add(fileObject3);
                    continue block1;
                }
            }
        }
        return arrayList;
    }

    private String getDSNames(LiveUnit liveUnit) {
        DesignBean[] designBeanArray = liveUnit.getBeans();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < designBeanArray.length; ++i) {
            Class<?> clazz = designBeanArray[i].getBeanInfo().getBeanDescriptor().getBeanClass();
            if (!RowSet.class.isAssignableFrom(clazz) && System.getProperty("rave.cached") == null) continue;
            DesignProperty[] designPropertyArray = designBeanArray[i].getProperties();
            for (int j = 0; j < designPropertyArray.length; ++j) {
                Object object;
                if (!designPropertyArray[j].getPropertyDescriptor().getName().equals("dataSourceName") || !((object = designPropertyArray[j].getValue()) instanceof String)) continue;
                if (bl) {
                    stringBuffer.append(",");
                } else {
                    bl = true;
                }
                stringBuffer.append((String)object);
            }
        }
        return stringBuffer.toString();
    }

    private static void logInfo(String string) {
        err.log(1, LOGPREFIX + string);
    }

    private boolean isLoggable() {
        return err.isLoggable(1);
    }

    private static void logErrorInfo(String string) {
        err.log(65536, LOGPREFIX + string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(111);
        stringBuffer.append("Data Source Tracker (" + this.trackers.size() + " projects) \n");
        for (int i = 0; i < this.trackers.size(); ++i) {
            DSTracker dSTracker = this.trackers.get(i);
            stringBuffer.append("*" + i + "*Project ");
            stringBuffer.append(dSTracker.project.getProjectDirectory()).append(" [Dynamic: ");
            stringBuffer.append(dSTracker.getDynamicDataSources()).append(" | Hard: ");
            stringBuffer.append(dSTracker.getHardcodedDataSources()).append(" ] \n");
        }
        return stringBuffer.toString();
    }

    public class OpenProjectsListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("openProjects".equals(propertyChangeEvent.getPropertyName())) {
                List<Project> list = Arrays.asList((Project[])propertyChangeEvent.getOldValue());
                List<Project> list2 = Arrays.asList((Project[])propertyChangeEvent.getNewValue());
                LinkedHashSet<Project> linkedHashSet = new LinkedHashSet<Project>(list);
                linkedHashSet.removeAll(list2);
                for (Project project : linkedHashSet) {
                    ProjectDataSourceTracker.this.trackers.remove(project);
                }
            }
        }
    }

    private class DSTracker {
        private ProjectDataSourceNode projectNode;
        private Project project = null;
        private HashSet listeners = new HashSet();
        private HashSet listenersForDSContainer = new HashSet();
        AuxiliaryConfiguration projectAux = null;
        ArrayList fnames = new ArrayList();
        ArrayList fnameDataSources = new ArrayList();
        TreeSet dynamicDataSouceSet = new TreeSet();
        TreeSet hardCodedDataSourceSet = new TreeSet();
        Element hcdsElement = null;
        String resolvedDataSource = null;

        public DSTracker(Project project) {
            this.project = project;
            this.projectAux = (AuxiliaryConfiguration)this.project.getLookup().lookup(AuxiliaryConfiguration.class);
            if (this.projectAux == null) {
                ProjectDataSourceTracker.logErrorInfo("no AuxiliaryConfiguration.class implementation for Project " + this.project);
            } else {
                ProjectDataSourceTracker.logInfo("we have an AuxiliaryConfiguration");
            }
            this.restoreHardcodedDataSources();
        }

        public Project getProject() {
            return this.project;
        }

        public Node getNode() {
            this.projectNode = new ProjectDataSourceNode(this.project);
            return this.projectNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getDynamicDataSources() {
            String[] stringArray;
            TreeSet treeSet = this.dynamicDataSouceSet;
            synchronized (treeSet) {
                stringArray = this.dynamicDataSouceSet.toArray(new String[this.dynamicDataSouceSet.size()]);
            }
            return stringArray;
        }

        public boolean isHardcodedDataSource(String string) {
            return this.hardCodedDataSourceSet.contains(string);
        }

        public String[] getHardcodedDataSources() {
            return this.hardCodedDataSourceSet.toArray(new String[this.hardCodedDataSourceSet.size()]);
        }

        public void addHardcodedDataSource(String string) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl;
                String string2 = stringArray[i].trim();
                if (string2.length() <= 0 || !(bl = this.hardCodedDataSourceSet.add(string2))) continue;
                this.persistHardcodedDataSources();
            }
        }

        public void removeHardcodedDataSource(String string) {
            if (this.isHardcodedDataSource(string)) {
                this.hardCodedDataSourceSet.remove(string);
                ProjectDataSourceTracker.logInfo("removed hard " + string);
                this.persistHardcodedDataSources();
            }
        }

        public void removeDataSource(String string) {
            this.hardCodedDataSourceSet.remove(string);
            ProjectDataSourceTracker.logInfo("removed" + string);
            this.persistHardcodedDataSources();
        }

        private void persistHardcodedDataSources() {
            if (this.projectAux == null) {
                return;
            }
            if (this.hcdsElement == null) {
                this.restoreHardcodedDataSources();
                if (this.hcdsElement == null) {
                    return;
                }
            }
            String string = this.composeCsv(this.hardCodedDataSourceSet);
            ProjectDataSourceTracker.logInfo("persisting hard data sources " + string);
            this.hcdsElement.setAttribute(ProjectDataSourceTracker.HC_ATTRIBUTE_NAME, string);
            this.projectAux.putConfigurationFragment(this.hcdsElement, true);
            try {
                ProjectManager.getDefault().saveProject(this.project);
            }
            catch (IOException iOException) {
                ProjectDataSourceTracker.logErrorInfo("Could not save project!");
            }
            this.fireChangeEvent();
        }

        private void restoreHardcodedDataSources() {
            if (this.projectAux == null) {
                return;
            }
            this.hcdsElement = this.projectAux.getConfigurationFragment(ProjectDataSourceTracker.HC_ELEMENT_NAME, ProjectDataSourceTracker.HC_ELEMENT_NAMESPACE, true);
            if (this.hcdsElement != null) {
                String string = this.hcdsElement.getAttribute(ProjectDataSourceTracker.HC_ATTRIBUTE_NAME);
                ProjectDataSourceTracker.logInfo("Restoring hard DS for " + this.project);
                if (string != null) {
                    TreeSet<String> treeSet = new TreeSet<String>();
                    String[] stringArray = string.split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string2 = stringArray[i].trim();
                        if (string2.length() <= 0) continue;
                        boolean bl = treeSet.add(stringArray[i]);
                        ProjectDataSourceTracker.logInfo("restored hard DS " + stringArray[i]);
                    }
                    this.hardCodedDataSourceSet = treeSet;
                    this.fireChangeEvent();
                }
            } else {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    this.hcdsElement = documentBuilder.newDocument().createElementNS(ProjectDataSourceTracker.HC_ELEMENT_NAMESPACE, ProjectDataSourceTracker.HC_ELEMENT_NAME);
                    ProjectDataSourceTracker.logInfo("new proj element for hard datasources created.");
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    this.hcdsElement = null;
                    ProjectDataSourceTracker.logErrorInfo("could not create the document element for saving HC DS");
                }
            }
        }

        private void setResolvedDataSource(String string) {
            this.resolvedDataSource = string;
        }

        private String getResolvedDataSource() {
            return this.resolvedDataSource;
        }

        private void fireChangeEvent() {
            if (!this.listeners.isEmpty()) {
                String[] stringArray = this.getDynamicDataSources();
                String[] stringArray2 = this.getHardcodedDataSources();
                for (ProjectDataSourceListener projectDataSourceListener : this.listeners) {
                    projectDataSourceListener.dataSourceChange(new ProjectDataSourceChangeEvent(stringArray, stringArray2));
                }
            }
        }

        private void fireProjectDSReferencesChangeEvent() {
            if (!this.listenersForDSContainer.isEmpty()) {
                String string = this.getResolvedDataSource();
                for (ProjectDataSourcesListener projectDataSourcesListener : this.listenersForDSContainer) {
                    projectDataSourcesListener.dataSourcesChange(new ProjectDataSourcesChangeEvent(string));
                }
            }
        }

        private String composeCsv(SortedSet sortedSet) {
            String string = "";
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                if (string.length() != 0) {
                    string = string + ",";
                }
                string = string + (String)iterator.next();
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RequestedJdbcResource[] getProjectDataSourceInfo() throws NamingException {
            if (Boolean.getBoolean("vwp.designer.jsf.loadModelSync")) {
                FacesModelSet.getInstance((Project)this.project);
            } else {
                FacesModelSet.startModeling((Project)this.project);
            }
            TreeSet treeSet = new TreeSet();
            AbstractCollection abstractCollection = this.dynamicDataSouceSet;
            synchronized (abstractCollection) {
                treeSet.addAll(this.dynamicDataSouceSet);
            }
            treeSet.addAll(this.hardCodedDataSourceSet);
            abstractCollection = new ArrayList();
            DesignTimeDataSourceHelper designTimeDataSourceHelper = new DesignTimeDataSourceHelper();
            for (String string : treeSet) {
                try {
                    DesignTimeDataSource designTimeDataSource = designTimeDataSourceHelper.getDataSourceFromFullName(string);
                    ((ArrayList)abstractCollection).add(new RequestedJdbcResource(this.stripDATASOURCE_PREFIX(string), designTimeDataSource.getDriverClassName(), designTimeDataSource.getUrl(), designTimeDataSource.getUsername(), designTimeDataSource.getPassword()));
                }
                catch (NamingException namingException) {
                    ((ArrayList)abstractCollection).add(new RequestedJdbcResource(this.stripDATASOURCE_PREFIX(string), null, null, null, null));
                }
            }
            ProjectDataSourceTracker.logInfo("returning RequestedJdbcResource array of length " + ((ArrayList)abstractCollection).size());
            for (int i = 0; i < ((ArrayList)abstractCollection).size(); ++i) {
                String string;
                string = (RequestedJdbcResource)((ArrayList)abstractCollection).get(i);
                ProjectDataSourceTracker.logInfo("resourceName     : " + string.getResourceName() + " ");
                ProjectDataSourceTracker.logInfo("  driverClassName: " + string.getDriverClassName() + " ");
                ProjectDataSourceTracker.logInfo("  url            : " + string.getUrl() + " ");
                ProjectDataSourceTracker.logInfo("  username       : " + string.getUsername() + " ");
                ProjectDataSourceTracker.logInfo("  password       : " + DesignTimeDataSource.encryptPassword(string.getPassword()) + " ");
            }
            return ((ArrayList)abstractCollection).toArray(new RequestedJdbcResource[((ArrayList)abstractCollection).size()]);
        }

        private String stripDATASOURCE_PREFIX(String string) {
            if (string == null) {
                return string;
            }
            if (string.startsWith(ProjectDataSourceTracker.NON_DEFAULT_DATASOURCE_PREFIX)) {
                return string.substring(ProjectDataSourceTracker.NON_DEFAULT_DATASOURCE_PREFIX.length());
            }
            if (!string.startsWith(ProjectDataSourceTracker.DATASOURCE_PREFIX)) {
                return string;
            }
            if (string.equals(ProjectDataSourceTracker.DATASOURCE_PREFIX)) {
                return string;
            }
            return string.substring(ProjectDataSourceTracker.DATASOURCE_PREFIX.length());
        }

        private void addListener(ProjectDataSourceListener projectDataSourceListener) {
            this.listeners.add(projectDataSourceListener);
        }

        private void removeListener(ProjectDataSourceListener projectDataSourceListener) {
            this.listeners.remove(projectDataSourceListener);
        }

        private void addListener(ProjectDataSourcesListener projectDataSourcesListener) {
            this.listenersForDSContainer.add(projectDataSourcesListener);
        }

        private void removeListener(ProjectDataSourcesListener projectDataSourcesListener) {
            this.listenersForDSContainer.remove(projectDataSourcesListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void changeDataSourcesForFile(String string, String string2) {
            TreeSet treeSet = this.dynamicDataSouceSet;
            synchronized (treeSet) {
                int n = this.fnames.size();
                boolean bl = false;
                if (string2 == null || "".equals(string2.trim())) {
                    bl = true;
                }
                int n2 = -1;
                for (int i = 0; i < n; ++i) {
                    if (!string.equals((String)this.fnames.get(i))) continue;
                    n2 = i;
                    break;
                }
                if (n2 >= 0) {
                    if (bl) {
                        if (ProjectDataSourceTracker.this.isLoggable()) {
                            ProjectDataSourceTracker.logInfo("  removing file from list:");
                            ProjectDataSourceTracker.logInfo("    file:     " + string);
                            ProjectDataSourceTracker.logInfo("    DSnames:: " + string2);
                        }
                        this.fnames.remove(n2);
                        this.fnameDataSources.remove(n2);
                        this.updateDesignDataSourceList();
                    } else {
                        String string3 = (String)this.fnameDataSources.get(n2);
                        if (!string3.equals(string2)) {
                            if (ProjectDataSourceTracker.this.isLoggable()) {
                                ProjectDataSourceTracker.logInfo("  changing file:");
                                ProjectDataSourceTracker.logInfo("    file:     " + string);
                                ProjectDataSourceTracker.logInfo("    DSnames:: " + string2);
                            }
                            this.fnameDataSources.set(n2, string2);
                            this.updateDesignDataSourceList();
                        } else if (ProjectDataSourceTracker.this.isLoggable()) {
                            ProjectDataSourceTracker.logInfo("  no change to file:");
                            ProjectDataSourceTracker.logInfo("    file:     " + string);
                            ProjectDataSourceTracker.logInfo("    DSnames:: " + string2);
                        }
                    }
                }
                if (n2 < 0 && !bl) {
                    this.fnames.add(string);
                    this.fnameDataSources.add(string2);
                    this.updateDesignDataSourceList();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateDesignDataSourceList() {
            if (ProjectDataSourceTracker.this.isLoggable()) {
                ProjectDataSourceTracker.logInfo("-----possible update of list of dynamic data sources");
            }
            TreeSet treeSet = this.dynamicDataSouceSet;
            synchronized (treeSet) {
                TreeSet<String> treeSet2 = new TreeSet<String>();
                for (int i = 0; i < this.fnameDataSources.size(); ++i) {
                    String string = (String)this.fnameDataSources.get(i);
                    if (string == null) continue;
                    String[] stringArray = string.split(",");
                    for (int j = 0; j < stringArray.length; ++j) {
                        boolean bl = treeSet2.add(stringArray[j]);
                    }
                }
                if (!treeSet2.isEmpty()) {
                    for (String string : treeSet2) {
                        if (!this.isHardcodedDataSource(string)) continue;
                        this.removeDataSource(string);
                        ProjectDataSourceTracker.logInfo("  removing hard " + string);
                    }
                }
                if (ProjectDataSourceTracker.this.isLoggable()) {
                    ProjectDataSourceTracker.logInfo("  calculation of ds in project list:");
                    ProjectDataSourceTracker.logInfo("        old:: " + this.dynamicDataSouceSet);
                    ProjectDataSourceTracker.logInfo("        new:: " + treeSet2);
                }
                if (!treeSet2.equals(this.dynamicDataSouceSet)) {
                    this.dynamicDataSouceSet = treeSet2;
                    this.fireChangeEvent();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getFileDataSourceList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            TreeSet treeSet = this.dynamicDataSouceSet;
            synchronized (treeSet) {
                StringBuffer stringBuffer;
                for (int i = 0; i < this.fnames.size(); ++i) {
                    stringBuffer = new StringBuffer((String)this.fnames.get(i));
                    stringBuffer.append(" :: ").append((String)this.fnameDataSources.get(i));
                    arrayList.add(stringBuffer.toString());
                }
                Iterator iterator = this.hardCodedDataSourceSet.iterator();
                while (iterator.hasNext()) {
                    stringBuffer = new StringBuffer("Manually added :: ");
                    stringBuffer.append((String)iterator.next());
                    arrayList.add(stringBuffer.toString());
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }

    public class ProjectTrackerContextListener
    implements ModelSetListener,
    ModelSetsListener {
        public void modelSetAdded(ModelSet modelSet) {
            ProjectDataSourceTracker.logInfo("adding listener for project " + modelSet.getProject());
            modelSet.addModelSetListener((ModelSetListener)ProjectDataSourceTracker.this.insyncDataSourceListener);
        }

        public void modelSetRemoved(ModelSet modelSet) {
            modelSet.removeModelSetListener((ModelSetListener)ProjectDataSourceTracker.this.insyncDataSourceListener);
        }

        public void modelProjectChanged() {
        }

        public void modelAdded(Model model) {
            this.changeFileDataSources(model, false);
        }

        public void modelChanged(Model model) {
            this.changeFileDataSources(model, false);
        }

        public void modelRemoved(Model model) {
            this.changeFileDataSources(model, true);
        }

        public void changeFileDataSources(Model model, boolean bl) {
            LiveUnit liveUnit;
            FacesModel facesModel;
            ProjectDataSourceTracker.logInfo("** received project DS name change event:");
            if (!isInitialContextInitialized) {
                DesignTimeInitialContextFactory.setInitialContextFactoryBuilder();
            }
            if (model instanceof FacesModel) {
                facesModel = (FacesModel)model;
                if (facesModel.isBusted()) {
                    return;
                }
            } else {
                return;
            }
            FileObject fileObject = model.getFile();
            String string = fileObject.getPath();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            String string2 = project.getProjectDirectory().getPath();
            if (string2.length() < string.length()) {
                string = string.substring(string2.length());
            }
            String string3 = null;
            if (!bl && (liveUnit = facesModel.getLiveUnit()) != null) {
                string3 = ProjectDataSourceTracker.this.getDSNames(liveUnit);
            }
            if (ProjectDataSourceTracker.this.isLoggable()) {
                ProjectDataSourceTracker.logInfo("    project:  " + project);
                ProjectDataSourceTracker.logInfo("        dir:  " + string2);
                ProjectDataSourceTracker.logInfo("    file:     " + string);
                ProjectDataSourceTracker.logInfo("    DSnames:: " + string3);
            }
            ProjectDataSourceTracker.getDSTracker(project).changeDataSourcesForFile(string, string3);
        }
    }
}

