/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.explorer;

import java.awt.Image;
import java.beans.PropertyEditor;
import java.io.CharConversionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import javax.naming.NamingException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.api.j2ee.common.RequestedJdbcResource;
import org.netbeans.modules.visualweb.dataconnectivity.datasource.BrokenDataSourceSupport;
import org.netbeans.modules.visualweb.dataconnectivity.explorer.DataSourcePropertyEditor;
import org.netbeans.modules.visualweb.dataconnectivity.explorer.ProjectDataSourceNode;
import org.netbeans.modules.visualweb.dataconnectivity.model.ProjectDataSourceManager;
import org.netbeans.modules.visualweb.dataconnectivity.project.datasource.ProjectDataSourceChangeEvent;
import org.netbeans.modules.visualweb.dataconnectivity.project.datasource.ProjectDataSourceListener;
import org.netbeans.modules.visualweb.dataconnectivity.project.datasource.ProjectDataSourceTracker;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;

public class ProjectDataSourceNodeChildren
extends Children.Keys
implements Node.Cookie,
ProjectDataSourceListener {
    Project nbProject = null;
    String url;
    private final String DYNAMIC_DATA_SOURCES = "dynamic_data_sources";
    private final String HARD_CODED_DATA_SOURCES = "hard_coded_data_sources";

    public ProjectDataSourceNodeChildren(Project project) {
        this.nbProject = project;
    }

    protected void addNotify() {
        super.addNotify();
        this.updateKeys();
        ProjectDataSourceTracker.addListener(this.nbProject, this);
    }

    protected void removeNotify() {
        ProjectDataSourceTracker.removeListener(this.nbProject, this);
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    private void updateKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("dynamic_data_sources");
        this.refreshKey("dynamic_data_sources");
        arrayList.add("hard_coded_data_sources");
        this.refreshKey("hard_coded_data_sources");
        if (!arrayList.isEmpty()) {
            this.setKeys(arrayList);
        } else {
            this.setKeys(Collections.EMPTY_SET);
        }
    }

    protected Node[] createNodes(Object object) {
        Node[] nodeArray;
        block4: {
            String[] stringArray;
            String string;
            block3: {
                string = (String)object;
                nodeArray = null;
                if (!string.equals("dynamic_data_sources")) break block3;
                String[] stringArray2 = ProjectDataSourceTracker.getDynamicDataSources(this.nbProject);
                if (stringArray2 == null || stringArray2.length <= 0) break block4;
                nodeArray = new Node[stringArray2.length];
                for (int i = 0; i < stringArray2.length; ++i) {
                    nodeArray[i] = this.createDatasourceNode(stringArray2[i]);
                }
                break block4;
            }
            if (string.equals("hard_coded_data_sources") && (stringArray = ProjectDataSourceTracker.getHardcodedDataSources(this.nbProject)) != null && stringArray.length > 0) {
                nodeArray = new Node[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    nodeArray[i] = this.createDatasourceNode(stringArray[i]);
                }
            }
        }
        return nodeArray;
    }

    private Node createDatasourceNode(String string) {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF){
            final Image icon;
            final Image disconnectedIcon;
            Image brokenBadgedImage;
            Image datasourceImage;
            String dispName;
            {
                this.icon = Utilities.loadImage((String)"org/netbeans/modules/visualweb/dataconnectivity/resources/datasource_container.png");
                this.disconnectedIcon = Utilities.loadImage((String)"org/netbeans/modules/visualweb/dataconnectivity/resources/disconnected.png");
                this.brokenBadgedImage = Utilities.mergeImages((Image)this.icon, (Image)this.disconnectedIcon, (int)8, (int)0);
                this.datasourceImage = Utilities.loadImage((String)"org/netbeans/modules/visualweb/dataconnectivity/resources/datasource.png");
            }

            public Image getIcon(int n) {
                this.dispName = super.getDisplayName();
                try {
                    this.dispName = BrokenDataSourceSupport.isBroken(ProjectDataSourceNodeChildren.this.nbProject) ? "<font color=\"#A40000\">" + this.dispName + "</font>" : XMLUtil.toElementContent((String)this.dispName);
                }
                catch (CharConversionException charConversionException) {
                    // empty catch block
                }
                if (BrokenDataSourceSupport.isBroken(ProjectDataSourceNodeChildren.this.nbProject)) {
                    return this.brokenBadgedImage;
                }
                return this.datasourceImage;
            }

            public Image getOpenedIcon(int n) {
                return this.getIcon(n);
            }

            protected Sheet createSheet() {
                Sheet sheet = super.createSheet();
                Sheet.Set set = sheet.createPropertiesSet();
                set.put((Node.Property)new DataSourceURLProperty());
                sheet.put(set);
                return sheet;
            }

            final class DataSourceURLProperty
            extends PropertySupport.ReadOnly {
                private String url;

                DataSourceURLProperty() {
                    super("URL", DataSourceURLProperty.class, NbBundle.getMessage(DataSourceURLProperty.class, (String)"LBL_URL"), NbBundle.getMessage(DataSourceURLProperty.class, (String)"DESC_URL") + ", " + dispName);
                    try {
                        this.url = (String)this.getValue();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Exceptions.printStackTrace((Throwable)illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Exceptions.printStackTrace((Throwable)invocationTargetException);
                    }
                }

                public Object getValue() throws IllegalAccessException, InvocationTargetException {
                    ProjectDataSourceManager projectDataSourceManager = new ProjectDataSourceManager(ProjectDataSourceNodeChildren.this.nbProject);
                    RequestedJdbcResource requestedJdbcResource = null;
                    try {
                        requestedJdbcResource = projectDataSourceManager.getDataSourceWithName(dispName);
                    }
                    catch (NamingException namingException) {
                        Exceptions.printStackTrace((Throwable)namingException);
                    }
                    if (requestedJdbcResource != null) {
                        return requestedJdbcResource.getUrl();
                    }
                    return "";
                }

                public PropertyEditor getPropertyEditor() {
                    return new DataSourcePropertyEditor(this.url);
                }
            }
        };
        String string2 = "java:comp/env/jdbc/";
        int n = string.indexOf(string2);
        String string3 = string.substring(string2.length());
        abstractNode.setName(string);
        abstractNode.setDisplayName(string3);
        abstractNode.setShortDescription(string3);
        Image image = Utilities.loadImage((String)"org/netbeans/modules/visualweb/dataconnectivity/resources/datasource.png");
        abstractNode.setIconBaseWithExtension("org/netbeans/modules/visualweb/dataconnectivity/resources/datasource.png");
        new ProjectDataSourceNode(this.nbProject);
        return abstractNode;
    }

    public void dataSourceChange(ProjectDataSourceChangeEvent projectDataSourceChangeEvent) {
        this.updateKeys();
    }
}

