/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.datasource;

import java.awt.Component;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.api.j2ee.common.RequestedJdbcResource;
import org.netbeans.modules.visualweb.dataconnectivity.model.DataSourceInfo;
import org.netbeans.modules.visualweb.dataconnectivity.model.DataSourceInfoEvent;
import org.netbeans.modules.visualweb.dataconnectivity.model.DataSourceInfoListener;
import org.netbeans.modules.visualweb.dataconnectivity.model.ProjectDataSourceManager;
import org.netbeans.modules.visualweb.dataconnectivity.naming.DatabaseSettingsImporter;
import org.netbeans.modules.visualweb.dataconnectivity.project.datasource.ProjectDataSourceTracker;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DesignTimeDataSourceHelper;
import org.netbeans.modules.visualweb.dataconnectivity.ui.DataSourceCreationNotSupported;
import org.netbeans.modules.visualweb.dataconnectivity.utils.ImportDataSource;
import org.netbeans.modules.visualweb.insync.Model;
import org.netbeans.modules.visualweb.insync.ModelSet;
import org.netbeans.modules.visualweb.insync.ModelSetsListener;
import org.netbeans.modules.visualweb.insync.models.FacesModelSet;
import org.netbeans.modules.visualweb.project.jsf.services.DesignTimeDataSourceService;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceResolver
implements DataSourceInfoListener,
Runnable {
    private static final String DRIVER_CLASS_NET = "org.apache.derby.jdbc.ClientDriver";
    private static final String DATASOURCE_PREFIX = "java:comp/env/";
    private static DataSourceResolver dataSourceResolver;
    private String dataSourceInfo = null;
    protected WaitForModelingListener modelingListener = new WaitForModelingListener();
    private Project project;
    private ProgressHandle handle = null;
    private TopComponent topComponent;
    private RequestProcessor.Task task = null;
    private final RequestProcessor WAIT_FOR_MODELING_RP = new RequestProcessor("DataSourceResolver.WAIT_FOR_MODELING_RP");
    private Model[] modelSets = null;

    private DataSourceResolver() {
    }

    public static DataSourceResolver getInstance() {
        if (dataSourceResolver == null) {
            dataSourceResolver = new DataSourceResolver();
        }
        return dataSourceResolver;
    }

    @Override
    public void dataSourceInfoModified(DataSourceInfoEvent dataSourceInfoEvent) {
        this.dataSourceInfo = dataSourceInfoEvent.getDataSourceInfoId();
    }

    @Override
    public void datasourceInfoAdded(DataSourceInfoEvent dataSourceInfoEvent) {
        this.dataSourceInfo = dataSourceInfoEvent.getDataSourceInfoId();
    }

    @Override
    public void dataSourceInfoRemoved(DataSourceInfoEvent dataSourceInfoEvent) {
    }

    public boolean isDataSourceMissing(Project project, String string) {
        DesignTimeDataSourceService designTimeDataSourceService = (DesignTimeDataSourceService)Lookup.getDefault().lookup(DesignTimeDataSourceService.class);
        Set set = designTimeDataSourceService.getBrokenDatasources(project);
        boolean bl = false;
        for (RequestedJdbcResource requestedJdbcResource : set) {
            if (!("jdbc/" + string).equals(requestedJdbcResource.getJndiName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Set<RequestedJdbcResource> getProjectDataSources(Project project) {
        DesignTimeDataSourceService designTimeDataSourceService = (DesignTimeDataSourceService)Lookup.getDefault().lookup(DesignTimeDataSourceService.class);
        return designTimeDataSourceService.getProjectDataSources(project);
    }

    public boolean isDataSourceUnique(Project project, String string, String string2) {
        String[] stringArray;
        for (String string3 : stringArray = ProjectDataSourceTracker.getDynamicDataSources(project)) {
            if (!string3.equals("java:comp/env//jdbc/" + string) || this.getDataSourceUrl(string).equals(string2)) continue;
            return false;
        }
        return true;
    }

    private String getDataSourceUrl(String string) {
        String string2 = null;
        DataSourceInfo dataSourceInfo2 = null;
        List<DataSourceInfo> list = DatabaseSettingsImporter.getInstance().getDataSourcesInfo();
        for (DataSourceInfo dataSourceInfo2 : list) {
            if (!string.equals(dataSourceInfo2.getName())) continue;
            string2 = dataSourceInfo2.getUrl();
        }
        return string2;
    }

    public void updateSettings() {
        this.doCopying();
        this.registerConnections();
    }

    public void update(Project project) {
        this.updateProject(project);
    }

    public JDBCDriver findMatchingDriver(String string) {
        int n = 0;
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers();
        for (n = 0; n < jDBCDriverArray.length; ++n) {
            if (jDBCDriverArray[n].getClassName().equals(string)) {
                return jDBCDriverArray[n];
            }
            if (!string.equals("org.gjt.mm.mysql.Driver") || !jDBCDriverArray[n].getClassName().equals("com.mysql.jdbc.Driver")) continue;
            return jDBCDriverArray[n];
        }
        return null;
    }

    private boolean updateProject(Project project, DataSourceInfo dataSourceInfo) throws NamingException {
        boolean bl = false;
        ProjectDataSourceManager projectDataSourceManager = new ProjectDataSourceManager(project);
        if (projectDataSourceManager.getDataSourceWithName(dataSourceInfo.getName()) == null) {
            projectDataSourceManager.addDataSource(dataSourceInfo);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void doCopying() {
        try {
            ImportDataSource.prepareCopy();
        }
        catch (IOException iOException) {
            Logger.getLogger("copy").info("Migrating user settings failed " + iOException);
        }
    }

    private void registerConnections() {
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(DRIVER_CLASS_NET);
        if (jDBCDriverArray.length > 0) {
            DatabaseSettingsImporter.getInstance().locateAndRegisterDrivers();
            DatabaseSettingsImporter.getInstance().locateAndRegisterConnections(false);
        }
    }

    private void updateProject(Project project) {
        try {
            new DesignTimeDataSourceHelper().updateDataSource(project);
            this.checkConnections(project);
        }
        catch (NamingException namingException) {
            Logger.getLogger("copy").info("Migrating user settings failed " + namingException);
        }
    }

    private void checkConnections(Project project) {
        DesignTimeDataSourceService designTimeDataSourceService = (DesignTimeDataSourceService)Lookup.getDefault().lookup(DesignTimeDataSourceService.class);
        Set set = designTimeDataSourceService.getBrokenDatasources(project);
        if (!set.isEmpty()) {
            ImportDataSource.showAlert();
        }
    }

    public synchronized void postUnsupportedDataSourceCreationDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DataSourceCreationNotSupported dataSourceCreationNotSupported = new DataSourceCreationNotSupported();
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DataSourceCreationNotSupported.class, (String)"MSG_DataSourceNotSupported"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                dataSourceCreationNotSupported.setVisible(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelProjectForDataSources(Project project) {
        this.project = project;
        ModelSet.addModelSetsListener((ModelSetsListener)this.modelingListener);
        this.topComponent = TopComponent.getRegistry().getActivated();
        this.topComponent.setCursor(Utilities.createProgressCursor((Component)this.topComponent));
        String string = NbBundle.getMessage(DataSourceResolver.class, (String)"LBL_ProgressBar");
        try {
            FacesModelSet facesModelSet = FacesModelSet.startModeling((Project)this.project);
            if (facesModelSet == null) {
                this.handle = ProgressHandleFactory.createHandle((String)string);
                this.handle.start();
                this.handle.switchToIndeterminate();
            }
            if (facesModelSet != null) {
                if (this.handle != null) {
                    this.handle.finish();
                }
                ModelSet.removeModelSetsListener((ModelSetsListener)this.modelingListener);
                ProjectDataSourceTracker.refreshDataSourceReferences(this.project);
                this.update(this.project);
            }
        }
        finally {
            this.topComponent.setCursor(null);
        }
    }

    public synchronized void updateTask() {
        if (this.task == null) {
            this.task = this.WAIT_FOR_MODELING_RP.create((Runnable)this);
        }
        this.task.schedule(50);
    }

    @Override
    public synchronized void run() {
        for (Model model : this.modelSets) {
            String string = model.getFile().getExt();
            if (!string.equals("java")) continue;
            FacesModelSet.getFacesModelIfAvailable((FileObject)model.getFile());
        }
        ProjectDataSourceTracker.refreshDataSourceReferences(this.project);
        this.update(this.project);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DataSourceResolver.this.handle != null) {
                    DataSourceResolver.this.handle.finish();
                }
            }
        });
        this.modelSets = null;
        ModelSet.removeModelSetsListener((ModelSetsListener)this.modelingListener);
    }

    public boolean isDatasourceCreationSupported(Project project) {
        DesignTimeDataSourceService designTimeDataSourceService = (DesignTimeDataSourceService)Lookup.getDefault().lookup(DesignTimeDataSourceService.class);
        return designTimeDataSourceService.isDatasourceCreationSupported(project);
    }

    static /* synthetic */ Model[] access$102(DataSourceResolver dataSourceResolver, Model[] modelArray) {
        dataSourceResolver.modelSets = modelArray;
        return modelArray;
    }

    public class WaitForModelingListener
    implements ModelSetsListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelSetAdded(ModelSet modelSet) {
            try {
                DataSourceResolver.access$102(DataSourceResolver.this, modelSet.getModels());
                DataSourceResolver.this.updateTask();
            }
            finally {
                DataSourceResolver.this.task.waitFinished();
                DataSourceResolver.this.topComponent.setCursor(null);
            }
        }

        public void modelSetRemoved(ModelSet modelSet) {
        }

        public void modelProjectChanged() {
        }
    }
}

