/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.jsfsupport.container;

import com.sun.faces.util.HtmlUtils;
import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.netbeans.modules.visualweb.jsfsupport.container.ResettableStringWriter;

public class PrettyJspWriter
extends ResponseWriter {
    String encoding = "ISO-8859-1";
    private int currentIndent = 0;
    private int indentAmount = 4;
    private boolean closeStart;
    private boolean isEmptyElement;
    private boolean dontEscape;
    private ResettableStringWriter writer;
    private char[] buffer = new char[1028];
    private char[] charHolder = new char[1];

    public PrettyJspWriter() {
    }

    public PrettyJspWriter(ResettableStringWriter resettableStringWriter) {
        this.writer = resettableStringWriter;
    }

    public void setOutputWriter(ResettableStringWriter resettableStringWriter) {
        this.writer = resettableStringWriter;
    }

    public int getCurrentIndent() {
        return this.currentIndent;
    }

    public void setIndentAmount(int n) {
        this.indentAmount = n;
    }

    public void indent() {
        this.currentIndent += this.indentAmount;
    }

    public void outdent() {
        this.currentIndent -= this.indentAmount;
        if (this.currentIndent < 0) {
            this.currentIndent = 0;
        }
    }

    private void writeIndent() throws IOException {
        for (int i = 0; i < this.currentIndent; ++i) {
            this.writer.write(32);
        }
    }

    public String getContentType() {
        return "text/html";
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void startDocument() throws IOException {
        this.currentIndent = 0;
    }

    public void endDocument() throws IOException {
        this.currentIndent = 0;
        this.writer.flush();
    }

    public void flush() throws IOException {
        this.closeStartIfNecessary();
        this.writer.flush();
    }

    public void startElement(String string, UIComponent uIComponent) throws IOException {
        ValueBinding valueBinding;
        char c = string.charAt(0);
        if (c == 's' || c == 'S' && (string.equalsIgnoreCase("script") || string.equalsIgnoreCase("style"))) {
            this.dontEscape = true;
        }
        this.closeStartIfNecessary();
        this.writeIndent();
        this.writer.write("<" + string);
        if (uIComponent != null && (valueBinding = uIComponent.getValueBinding("binding")) != null) {
            this.writeAttribute("design-id", valueBinding.getExpressionString(), null);
        }
        this.closeStart = true;
        this.isEmptyElement = true;
        this.indent();
    }

    private void closeStartIfNecessary() throws IOException {
        if (this.closeStart) {
            this.writer.write(">\n");
            this.closeStart = false;
        }
    }

    public void endElement(String string) throws IOException {
        this.dontEscape = false;
        if (this.closeStart) {
            if (this.isEmptyElement) {
                this.writer.write(" />");
                this.closeStart = false;
                this.outdent();
                return;
            }
            this.writer.write(">\n");
            this.closeStart = false;
        }
        this.outdent();
        this.writeIndent();
        this.writer.write("</");
        this.writer.write(string);
        this.writer.write(">\n");
    }

    public void writeAttribute(String string, Object object, String string2) throws IOException {
        this.writer.write(" ");
        this.writer.write(string);
        this.writer.write("=\"");
        HtmlUtils.writeAttribute((Writer)this.writer, (char[])this.buffer, (String)object.toString());
        this.writer.write("\"");
    }

    public void writeURIAttribute(String string, Object object, String string2) throws IOException {
        this.writer.write(" ");
        this.writer.write(string);
        this.writer.write("=\"");
        String string3 = object.toString();
        if (string3.startsWith("javascript:")) {
            HtmlUtils.writeAttribute((Writer)this.writer, (char[])this.buffer, (String)string3);
        } else {
            HtmlUtils.writeURL((Writer)this.writer, (String)string3, (String)this.encoding, null);
        }
        this.writer.write("\"");
    }

    public void writeComment(Object object) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write("<!-- ");
        this.writer.write(object.toString());
        this.writer.write(" -->");
    }

    public void writeText(Object object, String string) throws IOException {
        this.isEmptyElement = false;
        this.closeStartIfNecessary();
        this.writeIndent();
        if (this.dontEscape) {
            this.writer.write(object.toString());
        } else {
            HtmlUtils.writeText((Writer)this.writer, (char[])this.buffer, (String)object.toString());
        }
    }

    public void writeText(char c) throws IOException {
        this.isEmptyElement = false;
        this.closeStartIfNecessary();
        this.writeIndent();
        if (this.dontEscape) {
            this.writer.write(c);
        } else {
            this.charHolder[0] = c;
            HtmlUtils.writeText((Writer)this.writer, (char[])this.buffer, (char[])this.charHolder);
        }
    }

    public void writeText(char[] cArray, int n, int n2) throws IOException {
        this.isEmptyElement = false;
        this.closeStartIfNecessary();
        this.writeIndent();
        if (this.dontEscape) {
            this.writer.write(cArray);
        } else {
            HtmlUtils.writeText((Writer)this.writer, (char[])this.buffer, (char[])cArray);
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        throw new RuntimeException("cloneWithWriter not supported by the Rave container!");
    }

    public void close() throws IOException {
        this.closeStartIfNecessary();
        this.writer.close();
    }

    public void write(char c) throws IOException {
        this.isEmptyElement = false;
        this.closeStartIfNecessary();
        this.writer.write(c);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.isEmptyElement = false;
        this.closeStartIfNecessary();
        this.writer.write(cArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.isEmptyElement = false;
        this.closeStartIfNecessary();
        this.writer.write(n);
    }

    public void write(String string) throws IOException {
        this.isEmptyElement = false;
        this.closeStartIfNecessary();
        this.writer.write(string);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.isEmptyElement = false;
        this.closeStartIfNecessary();
        this.writer.write(string, n, n2);
    }

    public int getPosition() {
        return this.writer.getPosition();
    }

    public void reset(int n) {
        this.writer.reset(n);
        this.closeStart = false;
    }
}

