/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.propertysupport.nodes;

import java.awt.EventQueue;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinition;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElement;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElementManager;
import org.netbeans.modules.uml.propertysupport.DefinitionPropertyBuilder;
import org.netbeans.modules.uml.propertysupport.nodes.PreferenceHelper;

public class DefinitionPropertyEditor
extends PropertyEditorSupport {
    private IPropertyDefinition mDefinition = null;
    private IPropertyElement mElement = null;
    private DefinitionPropertyBuilder.ValidValues mValidValues = null;
    private String mInProcessValue = null;

    public DefinitionPropertyEditor(IPropertyDefinition iPropertyDefinition, IPropertyElement iPropertyElement) {
        this.setDefinition(iPropertyDefinition);
        this.setElement(iPropertyElement);
    }

    public void setValue(Object object) {
        if (object instanceof String && !object.equals(this.getElement().getTranslatedValue())) {
            this.getElement().setValue((String)object);
        }
    }

    public Object getValue() {
        return this.getElement().getValue();
    }

    public String getAsText() {
        String string = "";
        IPropertyElement iPropertyElement = this.getElement();
        if (iPropertyElement != null) {
            String string2 = this.mInProcessValue;
            if (string2 == null) {
                string2 = iPropertyElement.getValue();
            }
            string = this.mValidValues != null ? this.mValidValues.translateValue(string2) : iPropertyElement.getTranslatedValue();
        }
        return this.translateFullyQualifiedName(string);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string.length() > 0) {
            String string2 = this.translateToFullyQualifiedName(string);
            final IPropertyElement iPropertyElement = this.getElement();
            if (iPropertyElement != null && string2 != null) {
                String string3 = string2;
                if (this.mValidValues != null && (string3 = this.mValidValues.translateValueBackToPSK(string2)) == null) {
                    string3 = string2;
                }
                if (!string3.equals(iPropertyElement.getValue())) {
                    iPropertyElement.setValue(string3);
                    this.mInProcessValue = string2;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            iPropertyElement.setModified(true);
                            PreferenceHelper.saveModifiedPreferences(iPropertyElement);
                            IPropertyElementManager iPropertyElementManager = iPropertyElement.getPropertyElementManager();
                            iPropertyElementManager.interpretElementValue(iPropertyElement);
                            DefinitionPropertyEditor.this.mInProcessValue = null;
                            DefinitionPropertyEditor.this.firePropertyChange();
                        }
                    };
                    EventQueue.invokeLater(runnable);
                }
            }
        }
    }

    protected String translateEnumerationValue(String string) {
        IPropertyDefinition iPropertyDefinition;
        String string2;
        char c;
        String string3 = null;
        if (string != null && string.length() > 0 && Character.isDigit(c = string.charAt(0)) && (string2 = (iPropertyDefinition = this.getDefinition()).getEnumValues()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string4 = stringTokenizer.nextToken();
                if (!string4.equals(string)) continue;
                string3 = Integer.toString(i);
                break;
            }
            if (this.mValidValues != null && string3 != null) {
                string3 = this.mValidValues.translateValue(string3);
            }
        }
        return string3;
    }

    public String[] getTags() {
        String[] stringArray = null;
        if (!this.mDefinition.getControlType().equals("custom")) {
            this.mValidValues = DefinitionPropertyBuilder.instance().retrieveValidValues(this.mDefinition, this.mElement);
            if (this.mValidValues != null) {
                stringArray = this.mValidValues.getValidValues();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = this.translateFullyQualifiedName(stringArray[i]);
                }
            }
        }
        return stringArray;
    }

    public IPropertyElement getElement() {
        return this.mElement;
    }

    public void setElement(IPropertyElement iPropertyElement) {
        this.mElement = iPropertyElement;
    }

    public IPropertyDefinition getDefinition() {
        return this.mDefinition;
    }

    public void setDefinition(IPropertyDefinition iPropertyDefinition) {
        this.mDefinition = iPropertyDefinition;
    }

    protected String translateFullyQualifiedName(String string) {
        String string2 = string;
        if (string != null && string.indexOf("::") > 0) {
            int n = string.lastIndexOf("::");
            StringBuffer stringBuffer = new StringBuffer(string.substring(n + 2));
            stringBuffer.append(" : ");
            stringBuffer.append(string.substring(0, n));
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    protected String translateToFullyQualifiedName(String string) {
        String string2 = string;
        if (string != null && string.indexOf(" : ") > 0) {
            int n = string.indexOf(" : ");
            String string3 = string.substring(0, n);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(n + 3));
            stringBuffer.append("::");
            stringBuffer.append(string3);
            string2 = stringBuffer.toString();
        }
        return string2;
    }
}

