/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.propertysupport.nodes;

import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinition;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElement;
import org.netbeans.modules.uml.propertysupport.nodes.DefinitionPropertySupport;
import org.netbeans.modules.uml.propertysupport.nodes.PreferenceHelper;

public final class DefinitionFontProperty
extends DefinitionPropertySupport {
    public DefinitionFontProperty(IPropertyDefinition iPropertyDefinition, IPropertyElement iPropertyElement, boolean bl, boolean bl2) {
        super(iPropertyDefinition, iPropertyElement, Font.class, bl, bl2);
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        IPropertyElement iPropertyElement = this.getElement();
        Font font = this.buildCurrentFont(iPropertyElement);
        return font;
    }

    public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (object instanceof Font) {
            Font font = (Font)object;
            IPropertyElement iPropertyElement = this.getElement();
            DefinitionFontProperty.updateFontOnPropertyElement(iPropertyElement, font);
            PreferenceHelper.saveModifiedPreferences(iPropertyElement);
        }
    }

    private static void updateFontOnPropertyElement(IPropertyElement iPropertyElement, Font font) {
        if (iPropertyElement != null && font != null) {
            String string = font.getName();
            IPropertyElement iPropertyElement2 = iPropertyElement.getSubElement("FaceName", null);
            if (iPropertyElement2 != null) {
                iPropertyElement2.setValue(string);
                iPropertyElement2.setModified(true);
            }
            Integer n = new Integer(font.getSize());
            IPropertyElement iPropertyElement3 = iPropertyElement.getSubElement("Height", null);
            if (iPropertyElement3 != null) {
                iPropertyElement3.setValue(n.toString());
                iPropertyElement3.setModified(true);
            }
            boolean bl = font.isBold();
            IPropertyElement iPropertyElement4 = iPropertyElement.getSubElement("Weight", null);
            if (bl && iPropertyElement4 != null) {
                iPropertyElement4.setValue("700");
                iPropertyElement4.setModified(true);
            } else if (iPropertyElement4 != null) {
                iPropertyElement4.setValue("400");
                iPropertyElement4.setModified(true);
            }
            boolean bl2 = font.isItalic();
            IPropertyElement iPropertyElement5 = iPropertyElement.getSubElement("Italic", null);
            if (bl2 && iPropertyElement5 != null) {
                iPropertyElement5.setValue("1");
                iPropertyElement5.setModified(true);
            } else if (iPropertyElement5 != null) {
                iPropertyElement5.setValue("0");
                iPropertyElement5.setModified(true);
            }
            iPropertyElement.setModified(true);
        }
    }

    public Font buildCurrentFont(IPropertyElement iPropertyElement) {
        Font font = null;
        if (iPropertyElement != null) {
            IPropertyElement iPropertyElement2 = iPropertyElement.getSubElement("FaceName", null);
            String string = iPropertyElement2.getValue();
            String string2 = iPropertyElement.getSubElement("Height", null).getValue();
            String string3 = iPropertyElement.getSubElement("Weight", null).getValue();
            int n = new Integer(string3);
            String string4 = iPropertyElement.getSubElement("Italic", null).getValue();
            int n2 = 0;
            if (n > 400) {
                n2 |= 1;
            }
            if (string4.equals("1")) {
                n2 |= 2;
            }
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                font = new Font(string, n2, new Integer(string2));
            }
        }
        return font;
    }
}

