/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.propertysupport.customizers;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.profiles.IStereotype;
import org.netbeans.modules.uml.core.support.Debug;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinition;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElement;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElementManager;
import org.netbeans.modules.uml.propertysupport.DefinitionPropertyBuilder;
import org.netbeans.modules.uml.propertysupport.customizers.Customizer;
import org.netbeans.modules.uml.propertysupport.customizers.ListCellEditor;
import org.netbeans.modules.uml.propertysupport.customizers.PropertyDataFormatter;
import org.netbeans.modules.uml.propertysupport.customizers.TextCellEditor;
import org.netbeans.modules.uml.propertysupport.nodes.CustomPropertyEditor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class PropertyElementCustomizer
extends JPanel
implements Customizer,
EnhancedCustomPropertyEditor {
    private ResourceBundle mBundle = NbBundle.getBundle(PropertyElementCustomizer.class);
    private PropertyElementTabelModel mDataModel = new PropertyElementTabelModel();
    private Vector<IPropertyElement> localElement = new Vector();
    private IPropertyElement mElement = null;
    private IPropertyDefinition mDefinition = null;
    private CustomPropertyEditor mEditor = null;
    private JLabel jLabel1;
    private JButton mAddBtn;
    private JPanel mControlPanel;
    private JTable mDataTable;
    private JScrollPane mPropertyData;
    private JButton mRemoveBtn;

    public PropertyElementCustomizer() {
        this((IPropertyElement)null);
    }

    public PropertyElementCustomizer(IPropertyElement iPropertyElement) {
        this.initComponents();
        this.mDataTable.getSelectionModel().addListSelectionListener(new SelectionListener());
        this.setElement(iPropertyElement, null);
    }

    public void setElement(IPropertyElement iPropertyElement, IPropertyDefinition iPropertyDefinition) {
        this.mElement = iPropertyElement;
        this.mDefinition = iPropertyDefinition;
        if (iPropertyElement != null) {
            this.mDataModel = null;
            this.initializeModel();
        }
    }

    public void setPropertySupport(CustomPropertyEditor customPropertyEditor) {
        this.mEditor = customPropertyEditor;
    }

    protected void notifyChanged() {
        if (this.mEditor != null) {
            this.mEditor.firePropertyChange();
        }
    }

    protected void initializeModel() {
        if (this.mElement != null && this.mDefinition != null) {
            Serializable serializable;
            this.mDataModel = new PropertyElementTabelModel();
            this.mDataModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    PropertyElementCustomizer.this.dataChangedPerformed(tableModelEvent);
                }
            });
            TableCellRenderer[] tableCellRendererArray = this.mDataModel.initializeModel();
            this.mDataTable.setModel(this.mDataModel);
            this.mDataTable.setDoubleBuffered(true);
            for (int i = 0; i < tableCellRendererArray.length; ++i) {
                serializable = this.mDataTable.getColumnModel().getColumn(i);
                if (serializable == null) continue;
                ((TableColumn)serializable).setCellRenderer(tableCellRendererArray[i]);
                if (tableCellRendererArray[i] instanceof ListCellRender) {
                    ((TableColumn)serializable).setCellEditor(new ListCellEditor());
                    continue;
                }
                if (!(tableCellRendererArray[i] instanceof TextCellRender)) continue;
                ((TableColumn)serializable).setCellEditor(new TextCellEditor());
            }
            DefinitionPropertyBuilder definitionPropertyBuilder = DefinitionPropertyBuilder.instance();
            serializable = this.mElement.getSubElements();
            if (serializable != null) {
                IPropertyElement iPropertyElement;
                Iterator iterator = ((Vector)serializable).iterator();
                while (iterator.hasNext()) {
                    iPropertyElement = (IPropertyElement)iterator.next();
                    IPropertyDefinition iPropertyDefinition = iPropertyElement.getPropertyDefinition();
                    if (!iPropertyDefinition.isOnDemand()) continue;
                    definitionPropertyBuilder.loadOnDemandProperties(iPropertyElement);
                }
                iterator = ((Vector)(this.localElement.size() > 0 ? this.localElement : serializable)).iterator();
                while (iterator.hasNext()) {
                    iPropertyElement = (IPropertyElement)iterator.next();
                    this.mDataModel.addPropertyElement(iPropertyElement);
                }
            }
        }
    }

    private void initComponents() {
        this.mPropertyData = new JScrollPane();
        this.mDataTable = new JTable();
        this.mControlPanel = new JPanel();
        this.mAddBtn = new JButton();
        this.mRemoveBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.mDataTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.mPropertyData.setViewportView(this.mDataTable);
        this.mDataTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyElementCustomizer.class, (String)"ACSD_PropertyTable"));
        this.mDataTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyElementCustomizer.class, (String)"ACSD_PropertyTable"));
        this.mDataTable.getAccessibleContext().setAccessibleParent(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.mPropertyData, gridBagConstraints);
        this.mControlPanel.setLayout(new GridBagLayout());
        this.mControlPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.mControlPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.mAddBtn, (String)NbBundle.getMessage(PropertyElementCustomizer.class, (String)"BTN_ADD"));
        this.mAddBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyElementCustomizer.this.mAddBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.mAddBtn, gridBagConstraints);
        this.mAddBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyElementCustomizer.class, (String)"BTN_ADD"));
        this.mAddBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyElementCustomizer.class, (String)"ASD_NA"));
        this.mControlPanel.add(Box.createVerticalStrut(5));
        Mnemonics.setLocalizedText((AbstractButton)this.mRemoveBtn, (String)NbBundle.getMessage(PropertyElementCustomizer.class, (String)"BTN_REMOVE"));
        this.mRemoveBtn.setEnabled(false);
        this.mRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyElementCustomizer.this.mRemoveBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.mRemoveBtn, gridBagConstraints);
        this.mRemoveBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyElementCustomizer.class, (String)"BTN_REMOVE"));
        this.mRemoveBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyElementCustomizer.class, (String)"ASD_NA"));
        this.jLabel1.setLabelFor(this.mDataTable);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PropertyElementCustomizer.class, (String)"LBL_PropertyValues"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    private void mRemoveBtnActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.mDataTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        this.setLastEditedCell(true);
        this.mDataModel.removeRows(nArray);
    }

    private void mAddBtnActionPerformed(ActionEvent actionEvent) {
        this.mDataModel.createNewProperty();
        int n = this.mDataModel.getRowCount() - 1;
    }

    public void dataChangedPerformed(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getType();
        if (n == -1 && this.mDataTable.getModel().getColumnCount() == 1) {
            TableColumn tableColumn = this.mDataTable.getColumnModel().getColumn(0);
            DefaultCellEditor defaultCellEditor = (DefaultCellEditor)tableColumn.getCellEditor();
            Component component = defaultCellEditor.getComponent();
            JComboBox jComboBox = null;
            if (component instanceof JComboBox) {
                jComboBox = (JComboBox)component;
                jComboBox.getModel().setSelectedItem("");
            }
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        Object var1_1 = null;
        this.setLastEditedCell(true);
        this.mDataModel.saveModel();
        this.mDataModel = null;
        IPropertyElementManager iPropertyElementManager = this.mElement.getPropertyElementManager();
        IPropertyElement iPropertyElement = this.mElement.getParent();
        iPropertyElementManager.reloadElement(this.mElement.getElement(), this.mElement.getPropertyDefinition(), this.mElement);
        this.notifyChanged();
        return var1_1;
    }

    public void setVisible(boolean bl) {
        if (bl && this.mDataModel == null) {
            this.initializeModel();
        }
        super.setVisible(bl);
    }

    private void setLastEditedCell(Boolean bl) {
        int n = this.mDataTable.getEditingRow();
        int n2 = this.mDataTable.getEditingColumn();
        if (n < 0 || n2 < 0) {
            return;
        }
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this.mDataTable.getCellEditor(n, n2);
        Component component = defaultCellEditor.getComponent();
        if (component instanceof JTextField) {
            String string = ((JTextField)component).getText();
            Debug.out.println("getLastUpdatedCell: lasteditedText=" + string);
            if (bl.booleanValue()) {
                this.mDataTable.getModel().setValueAt(string, n, n2);
                defaultCellEditor.stopCellEditing();
            } else {
                ((JTextField)component).setText("");
                defaultCellEditor.cancelCellEditing();
            }
        }
        component.transferFocus();
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            PropertyElementCustomizer.this.mRemoveBtn.setEnabled(PropertyElementCustomizer.this.mDataTable.getSelectedRows().length > 0);
        }
    }

    public class TextCellRender
    extends DefaultTableCellRenderer {
        protected void setValue(Object object) {
            if (object instanceof IPropertyElement) {
                IPropertyElement iPropertyElement = (IPropertyElement)object;
                String string = iPropertyElement.getValue();
                this.setText(string == null ? "" : string);
            }
        }
    }

    public class ListCellRender
    extends DefaultTableCellRenderer {
        protected void setValue(Object object) {
            if (object instanceof IPropertyElement) {
                IPropertyElement iPropertyElement = (IPropertyElement)object;
                String string = iPropertyElement.getValue();
                String string2 = string == null ? "" : string;
                this.setText(PropertyDataFormatter.translateFullyQualifiedName(string2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PropertyElementTabelModel
    extends AbstractTableModel {
        private ArrayList<PropertyData> mData = new ArrayList();
        private ArrayList<PropertyData> mRemovedData = new ArrayList();
        private ArrayList<IPropertyDefinition> mColumnDefintions = new ArrayList();

        public PropertyElementTabelModel() {
        }

        public PropertyElementTabelModel(IElement iElement, ArrayList<IStereotype> arrayList) {
        }

        public void saveModel() {
            PropertyElementCustomizer.this.localElement.removeAllElements();
            for (PropertyData propertyData : this.mData) {
                propertyData.save();
                PropertyElementCustomizer.this.localElement.add(propertyData.getPropertyElement());
            }
            for (PropertyData propertyData : this.mRemovedData) {
                propertyData.remove();
            }
        }

        public void removeRow(int n) {
            PropertyData propertyData = this.mData.get(n);
            this.mData.remove(n);
            this.mRemovedData.add(propertyData);
        }

        public void removeRows(int[] nArray) {
            if (nArray == null || nArray.length == 0) {
                return;
            }
            PropertyData[] propertyDataArray = new PropertyData[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                propertyDataArray[i] = this.mData.get(nArray[i]);
            }
            PropertyData propertyData = null;
            PropertyData propertyData2 = null;
            block1: for (int i = 0; i < propertyDataArray.length; ++i) {
                propertyData = propertyDataArray[i];
                for (int j = 0; j < this.getRowCount(); ++j) {
                    propertyData2 = this.mData.get(j);
                    if (propertyData2 != propertyData) continue;
                    this.fireTableRowsDeleted(j, j);
                    this.mData.remove(propertyData2);
                    this.mRemovedData.add(propertyData2);
                    continue block1;
                }
            }
        }

        public TableCellRenderer[] initializeModel() {
            Object object;
            ArrayList<DefaultTableCellRenderer> arrayList = new ArrayList<DefaultTableCellRenderer>();
            if (PropertyElementCustomizer.this.mDefinition != null) {
                object = PropertyElementCustomizer.this.mDefinition.getSubDefinitions();
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    IPropertyDefinition iPropertyDefinition = (IPropertyDefinition)iterator.next();
                    if (iPropertyDefinition.getMultiplicity() != 1L) continue;
                    this.mColumnDefintions.add(iPropertyDefinition);
                    switch (DefinitionPropertyBuilder.instance().getControlType(iPropertyDefinition)) {
                        case 1: 
                        case 11: {
                            arrayList.add(new TextCellRender());
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            arrayList.add(new ListCellRender());
                            break;
                        }
                        case 4: {
                            arrayList.add(new ListCellRender());
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 7: {
                            break;
                        }
                        case 8: {
                            break;
                        }
                    }
                }
            }
            object = new TableCellRenderer[arrayList.size()];
            arrayList.toArray((T[])object);
            return object;
        }

        protected IPropertyDefinition getColumnDefinition(int n) {
            IPropertyDefinition iPropertyDefinition = null;
            if (n < this.getColumnCount()) {
                iPropertyDefinition = this.mColumnDefintions.get(n);
            }
            return iPropertyDefinition;
        }

        protected void printData(ArrayList<PropertyData> arrayList) {
            if (arrayList == null) {
                Debug.out.println("Data is null");
            } else if (arrayList.size() == 0) {
                Debug.out.println("Data is emty");
            } else {
                IPropertyElement iPropertyElement = null;
                Debug.out.println("*****");
                for (int i = 0; i < arrayList.size(); ++i) {
                    for (int j = 0; j < this.getColumnCount(); ++j) {
                        iPropertyElement = this.getPropertyElement(i, j);
                        Debug.out.println("[" + i + "," + j + "]: " + iPropertyElement.getValue());
                    }
                }
                Debug.out.println("*****");
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public int getColumnCount() {
            return this.mColumnDefintions.size();
        }

        @Override
        public String getColumnName(int n) {
            String string = "< UNKNOWN >";
            IPropertyDefinition iPropertyDefinition = this.getColumnDefinition(n);
            if (iPropertyDefinition != null) {
                string = iPropertyDefinition.getDisplayName();
            }
            return string;
        }

        @Override
        public int getRowCount() {
            return this.mData.size();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            IPropertyElement iPropertyElement = this.getPropertyElement(n, n2);
            if (iPropertyElement != null && object instanceof String) {
                if (n2 == 2) {
                    String string = PropertyDataFormatter.translateToFullyQualifiedName((String)object);
                    iPropertyElement.setValue(string);
                } else {
                    iPropertyElement.setValue((String)object);
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            IPropertyElement iPropertyElement = this.getPropertyElement(n, n2);
            return iPropertyElement;
        }

        protected IPropertyElement getPropertyElement(int n, int n2) {
            IPropertyElement iPropertyElement = null;
            if (n < this.getRowCount()) {
                Vector vector;
                IPropertyElement iPropertyElement2;
                PropertyData propertyData = this.mData.get(n);
                if (n2 < this.getColumnCount() && (iPropertyElement2 = propertyData.getPropertyElement()) != null && (vector = iPropertyElement2.getSubElements()) != null) {
                    iPropertyElement = (IPropertyElement)vector.get(n2);
                }
            }
            return iPropertyElement;
        }

        public void addPropertyElement(IPropertyElement iPropertyElement) {
            this.mData.add(new PropertyData(iPropertyElement, null));
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        public void createNewProperty() {
            DefinitionPropertyBuilder definitionPropertyBuilder = DefinitionPropertyBuilder.instance();
            IPropertyElement iPropertyElement = definitionPropertyBuilder.retrievePropertyElement(PropertyElementCustomizer.this.mDefinition, PropertyElementCustomizer.this.mElement);
            this.addPropertyElement(iPropertyElement);
        }

        class PropertyData {
            private IPropertyElement mPropertyElement = null;
            private Node.Property[] mData = null;

            public PropertyData(IPropertyElement iPropertyElement, Node.Property[] propertyArray) {
                this.mPropertyElement = iPropertyElement;
                this.mData = propertyArray;
            }

            public IPropertyElement getPropertyElement() {
                return this.mPropertyElement;
            }

            public void save() {
                IPropertyElement iPropertyElement = this.getPropertyElement();
                if (iPropertyElement != null) {
                    this.save(iPropertyElement);
                }
            }

            protected void save(IPropertyElement iPropertyElement) {
                if (iPropertyElement != null) {
                    String string = iPropertyElement.getValue();
                    String string2 = PropertyDataFormatter.translateToFullyQualifiedName(string);
                    iPropertyElement.setValue(string2);
                    iPropertyElement.save();
                    Vector vector = iPropertyElement.getSubElements();
                    for (IPropertyElement iPropertyElement2 : vector) {
                        this.save(iPropertyElement2);
                    }
                }
            }

            public void remove() {
                IPropertyElement iPropertyElement = this.getPropertyElement();
                if (iPropertyElement != null) {
                    iPropertyElement.remove();
                }
            }

            public Node.Property getData(int n) {
                Node.Property property = null;
                if (n < this.mData.length) {
                    property = this.mData[n];
                }
                return property;
            }

            public int getNumberOfColumns() {
                return this.mData.length;
            }
        }
    }
}

