/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen.resource;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.DesignComponentDataFlavorSupport;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceItemPresenter;
import org.netbeans.modules.vmd.screen.MainPanel;
import org.openide.util.Utilities;

public class ResourceItemPanel
extends JLabel
implements MouseListener {
    private static Border SELECTED_RESOURCE_BORDER = new LineBorder(MainPanel.SELECT_COLOR, 2, false);
    private static Border HOVER_RESOURCE_BORDER = new LineBorder(MainPanel.HOVER_COLOR, 2, false);
    private static Border RESOURCE_BORDER = new EmptyBorder(2, 2, 2, 2);
    private DesignComponent component;
    private boolean selected;
    private boolean hovered;
    private DragSource dragSource;
    private DragListener listener;
    private DropTarget dropTarget;

    public ResourceItemPanel(DesignComponent designComponent) {
        this.component = designComponent;
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.listener = new DragListener();
        this.initDragAndDrop();
    }

    private void initDragAndDrop() {
        this.dragSource = new DragSource();
        this.dropTarget = new DropTarget(this, new DropListener());
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this.listener);
    }

    public void reload() {
        InfoPresenter infoPresenter = (InfoPresenter)this.component.getPresenter(InfoPresenter.class);
        ScreenResourceItemPresenter screenResourceItemPresenter = (ScreenResourceItemPresenter)this.component.getPresenter(ScreenResourceItemPresenter.class);
        assert (infoPresenter != null) : "Null InfoPresenter";
        assert (screenResourceItemPresenter != null) : "Null ScreenResourceItemPresenter";
        InfoPresenter.NameType nameType = screenResourceItemPresenter.getNameType();
        Image image = infoPresenter.getIcon(InfoPresenter.IconType.COLOR_16x16);
        this.setIcon(image != null ? new ImageIcon(image) : null);
        this.selected = this.component.getDocument().getSelectedComponents().contains(this.component);
        this.resolveBorder();
        this.setText(infoPresenter.getDisplayName(nameType));
    }

    public JPopupMenu getComponentPopupMenu() {
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.doSelect(mouseEvent);
    }

    private void doSelect(final MouseEvent mouseEvent) {
        final DesignDocument designDocument = this.component.getDocument();
        final ArrayList arrayList = new ArrayList();
        designDocument.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                if ((mouseEvent.getModifiersEx() & 0x80) == 128) {
                    Collection collection = designDocument.getSelectedComponents();
                    arrayList.addAll(collection);
                    if (collection.contains(ResourceItemPanel.this.component)) {
                        arrayList.remove(ResourceItemPanel.this.component);
                    } else {
                        arrayList.add(ResourceItemPanel.this.component);
                    }
                } else {
                    arrayList.add(ResourceItemPanel.this.component);
                }
                designDocument.setSelectedComponents("screen", arrayList);
            }
        });
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doSelect(mouseEvent);
            Utilities.actionsToPopup((Action[])ActionsSupport.createActionsArray((DesignComponent)this.component), (Component)this).show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doSelect(mouseEvent);
            Utilities.actionsToPopup((Action[])ActionsSupport.createActionsArray((DesignComponent)this.component), (Component)this).show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.hovered = true;
        this.resolveBorder();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.hovered = false;
        this.resolveBorder();
    }

    private void resolveBorder() {
        if (this.hovered) {
            this.setBorder(HOVER_RESOURCE_BORDER);
        } else {
            this.setBorder(this.selected ? SELECTED_RESOURCE_BORDER : RESOURCE_BORDER);
        }
    }

    private class ScreenTransferable
    implements Transferable {
        private DesignComponent component;

        public ScreenTransferable(DesignComponent designComponent) {
            this.component = designComponent;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor == DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR) {
                return this.component;
            }
            return null;
        }
    }

    private class DropListener
    implements DropTargetListener {
        private DropListener() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            ResourceItemPanel.this.hovered = true;
            ResourceItemPanel.this.resolveBorder();
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.rejectDrag();
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            ResourceItemPanel.this.hovered = false;
            ResourceItemPanel.this.resolveBorder();
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
        }
    }

    private class DragListener
    implements DragGestureListener {
        private ScreenTransferable flavor;

        private DragListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (this.flavor == null) {
                this.flavor = new ScreenTransferable(ResourceItemPanel.this.component);
            }
            try {
                dragGestureEvent.startDrag(null, this.flavor);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                invalidDnDOperationException.printStackTrace();
            }
        }
    }
}

