/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.IOUtils;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.javame.MidpProjectPropertiesSupport;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.screen.ScreenAccessController;

public class ScreenViewController
implements DesignDocumentAwareness {
    public static final String SCREEN_ID = "screen";
    private DesignDocument designDocument;
    private JPanel visual;
    private JToolBar toolbar;
    private JComponent loadingPanel = IOUtils.createLoadingPanel();

    public ScreenViewController(DataObjectContext dataObjectContext) {
        this.visual = new JPanel();
        this.visual.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        dataObjectContext.addDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    public JComponent getVisualRepresentation() {
        return this.visual;
    }

    public JComponent getToolbarRepresentation() {
        return this.toolbar;
    }

    public void setDesignDocument(final DesignDocument designDocument) {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            public void run() {
                ScreenAccessController screenAccessController;
                if (ScreenViewController.this.designDocument != null && (screenAccessController = (ScreenAccessController)ScreenViewController.this.designDocument.getListenerManager().getAccessController(ScreenAccessController.class)) != null) {
                    screenAccessController.hideNotify();
                }
                ScreenViewController.this.toolbar.removeAll();
                ScreenViewController.this.visual.removeAll();
                ScreenViewController.this.designDocument = designDocument;
                ScreenAccessController screenAccessController2 = screenAccessController = ScreenViewController.this.designDocument != null ? (ScreenAccessController)ScreenViewController.this.designDocument.getListenerManager().getAccessController(ScreenAccessController.class) : null;
                if (screenAccessController != null) {
                    screenAccessController.showNotify();
                    final DataObjectContext dataObjectContext = ProjectUtils.getDataObjectContextForDocument((DesignDocument)ScreenViewController.this.designDocument);
                    if (dataObjectContext != null) {
                        ScreenViewController.this.designDocument.getTransactionManager().readAccess(new Runnable(){

                            public void run() {
                                screenAccessController.setScreenSize(MidpProjectPropertiesSupport.getDeviceScreenSizeFromProject((DataObjectContext)dataObjectContext));
                            }
                        });
                    }
                    ScreenViewController.this.visual.add((Component)new JScrollPane(screenAccessController.getMainPanel()), "Center");
                    JToolBar.Separator separator = new JToolBar.Separator();
                    separator.setOrientation(1);
                    ScreenViewController.this.toolbar.add(separator);
                    ScreenViewController.this.toolbar.add(screenAccessController.getToolBar());
                } else {
                    ScreenViewController.this.visual.add((Component)ScreenViewController.this.loadingPanel, "Center");
                }
                ScreenViewController.this.toolbar.validate();
                ScreenViewController.this.visual.validate();
            }
        });
    }

    public void setScreenSize(final Dimension dimension) {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            public void run() {
                if (ScreenViewController.this.designDocument != null) {
                    ScreenViewController.this.designDocument.getTransactionManager().readAccess(new Runnable(){

                        public void run() {
                            ScreenAccessController screenAccessController = (ScreenAccessController)ScreenViewController.this.designDocument.getListenerManager().getAccessController(ScreenAccessController.class);
                            if (screenAccessController != null) {
                                screenAccessController.setScreenSize(dimension);
                            }
                        }
                    });
                }
            }
        });
    }
}

